/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.utils.ExceptionUtil;
import com.elitesland.support.provider.item.dto.ItmBrandRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.support.provider.item.dto.ItmItemIcDTO;
import com.elitesland.support.provider.item.dto.ItmItemLotRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSpuBusinessRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.elitesland.support.provider.item.param.ItmBrandRpcDtoParam;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcDtoParam;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemUomConvRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmBrandRpcService;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RmiItemService {
    private static final Logger log = LoggerFactory.getLogger(RmiItemService.class);
    @Autowired
    private ItmItemRpcService itmItemRpcService;
    @Autowired
    private ItmBrandRpcService itmBrandRpcService;

    public List<ItmItemBusinessRpcDTO> findItmItemBusinessByBUCodeAndBrand(String ouCode, String brandCode) {
        ItmItemBusinessRpcDtoParam param = new ItmItemBusinessRpcDtoParam();
        if (StrUtil.isNotBlank((CharSequence)ouCode)) {
            param.setBuCodes(Collections.singletonList(ouCode));
        }
        if (StrUtil.isNotBlank((CharSequence)brandCode)) {
            param.setBrandList(Collections.singletonList(brandCode));
        }
        return this.selectItmItemBusinessByParam(param);
    }

    public List<ItmItemBusinessRpcDTO> findItmItemBusinessByBUCodeAndBrandAndItemList(String ouCode, String brandCode, List<String> itemCodeList) {
        log.info("\u6839\u636e\u54c1\u724c\u7ec4\u7ec7\u6a21\u677f\u5546\u54c1\u83b7\u53d6\u5546\u54c1\u6743\u9650\u6570\u636e,\u53c2\u6570:{},{},{}", new Object[]{ouCode, brandCode, JSONUtil.toJsonStr(itemCodeList)});
        ItmItemBusinessRpcDtoParam param = new ItmItemBusinessRpcDtoParam();
        if (StrUtil.isNotBlank((CharSequence)ouCode)) {
            param.setBuCodes(Collections.singletonList(ouCode));
        }
        if (StrUtil.isNotBlank((CharSequence)brandCode)) {
            param.setBrandList(Collections.singletonList(brandCode));
        }
        if (CollUtil.isNotEmpty(itemCodeList)) {
            param.setItemCodes(itemCodeList);
        }
        return this.selectItmItemBusinessByParam(param);
    }

    public List<ItmItemBusinessRpcDTO> selectItmItemBusinessByParam(ItmItemBusinessRpcDtoParam param) {
        try {
            log.info("\u65b0\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)param));
            List dtos = this.itmItemRpcService.selectItmItemBusinessByParam(param);
            log.info("\u65b0\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)dtos));
            return dtos;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u65b0\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u670d\u52a1\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u65b0\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public PagingVO<ItmItemBusinessRpcPagingDTO> selectItemBusinessRpcDtoByParam(ItmItemBusinessRpcPagingParam param) {
        try {
            log.info("\u65b0\u5206\u9875\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)param));
            PagingVO dtos = this.itmItemRpcService.selectItemBusinessRpcDtoByParam(param);
            log.info("\u65b0\u5206\u9875\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)dtos));
            return dtos;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u65b0\u5206\u9875\u67e5\u8be2\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u670d\u52a1\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u65b0\u5206\u9875\u67e5\u8be2\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<ItmItemBusinessRpcDTO> findItmItemBusinessByParam(ItmItemBusinessRpcDtoParam param) {
        try {
            log.info("\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)param));
            List dtos = this.itmItemRpcService.findItmItemBusinessByParam(param);
            log.info("\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)dtos));
            return dtos;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
            throw new BusinessException("\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public PagingVO<ItmItemBusinessRpcPagingDTO> findItemBusinessRpcDtoByParam(ItmItemBusinessRpcPagingParam param) {
        try {
            log.info("\u5206\u9875\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)param));
            PagingVO dtos = this.itmItemRpcService.findItemBusinessRpcDtoByParam(param);
            log.info("\u5206\u9875\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)dtos));
            return dtos;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u5206\u9875\u67e5\u8be2\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u670d\u52a1\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u5206\u9875\u67e5\u8be2\u7ecf\u8425\u76ee\u5f55\u5217\u8868\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<ItmItemBaseRpcDTO> findItemBaseRpcDtoByParam(ItmItemBaseRpcParam param) {
        try {
            log.info("\u83b7\u53d6\u5546\u54c1\u57fa\u7840\u4fe1\u606f\u5217\u8868\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)param));
            List itemBaseRpcDtoByParam = this.itmItemRpcService.findItemBaseRpcDtoByParam(param);
            log.info("\u83b7\u53d6\u5546\u54c1\u57fa\u7840\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)itemBaseRpcDtoByParam));
            return itemBaseRpcDtoByParam;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u83b7\u53d6\u5546\u54c1\u57fa\u7840\u4fe1\u606f\u5217\u8868\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
            throw new BusinessException("\u83b7\u53d6\u5546\u54c1\u57fa\u7840\u4fe1\u606f\u5217\u8868\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<ItmItemUomConvRpcDTO> findItemUomConvDtoByParam(ItmItemUomConvRpcDtoParam param) {
        try {
            log.info("\u83b7\u53d6\u5546\u54c1\u5355\u4f4d\u8f6c\u5316\u7387\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)param));
            List result = this.itmItemRpcService.findItemUomConvDtoByParam(param);
            log.info("\u83b7\u53d6\u5546\u54c1\u5355\u4f4d\u8f6c\u5316\u7387\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)result));
            return result;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u83b7\u53d6\u5546\u54c1\u5355\u4f4d\u8f6c\u5316\u7387\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
            throw new BusinessException("\u83b7\u53d6\u5546\u54c1\u5355\u4f4d\u8f6c\u5316\u7387\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<ItmItemAttachmentProviderDTO> findSkuImgByItemIds(List<Long> itemIds) {
        try {
            log.info("\u5546\u54c1\u56fe\u7247\u67e5\u8be2\u5165\u53c2,{}", (Object)JSON.toJSONString(itemIds));
            List skuImgByItemIds = this.itmItemRpcService.findSkuImgByItemIds(itemIds);
            log.info("\u5546\u54c1\u56fe\u7247\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)skuImgByItemIds));
            return skuImgByItemIds;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u5546\u54c1\u56fe\u7247\u67e5\u8be2\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
            throw new BusinessException("\u5546\u54c1\u56fe\u7247\u67e5\u8be2\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<ItmItemScpBaseRpcDTO> findItemScpBaseRpcDtoByParam(ItmItemScpBaseRpcParam param) {
        try {
            log.info("\u5c0f\u7a0b\u5e8f-\u5546\u54c1\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)param));
            List itmItemScpBaseRpcDTO = this.itmItemRpcService.findItemScpBaseRpcDtoByParam(param);
            log.info("\u5c0f\u7a0b\u5e8f--\u5546\u54c1\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)itmItemScpBaseRpcDTO));
            return itmItemScpBaseRpcDTO;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u5c0f\u7a0b\u5e8f-\u5546\u54c1\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u5c0f\u7a0b\u5e8f-\u5546\u54c1\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<ItmItemRpcDTO> findItemRpcDtoByParam(ItmItemRpcDtoParam param) {
        try {
            log.info("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)param));
            List itemRpcDtoByParam = this.itmItemRpcService.findItemRpcDtoByParam(param);
            log.info("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)itemRpcDtoByParam));
            return itemRpcDtoByParam;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
            throw new BusinessException("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<ItmItemLotRpcDTO> findLotRpcDTOS(List<Long> itemIds) {
        try {
            log.info("\u5546\u54c1\u7b80\u8981\u4fe1\u606f\u67e5\u8be2\u5165\u53c2,{}", (Object)JSON.toJSONString(itemIds));
            List lotRpcDTOS = this.itmItemRpcService.findLotRpcDTOS(itemIds);
            log.info("\u5546\u54c1\u7b80\u8981\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)lotRpcDTOS));
            return lotRpcDTOS;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
            throw new BusinessException("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<Long, ItmItemIcDTO> findSimpleItemMap(List<Long> itemIds) {
        try {
            log.info("\u5546\u54c1\u7b80\u8981\u4fe1\u606f\u67e5\u8be2\u5165\u53c2,{}", (Object)JSON.toJSONString(itemIds));
            List simpleItem = this.itmItemRpcService.findIcItem(itemIds);
            log.info("\u5546\u54c1\u7b80\u8981\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)simpleItem));
            return simpleItem.stream().collect(Collectors.toMap(ItmItemIcDTO::getId, Function.identity()));
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
            throw new BusinessException("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<Long, ItmItemScpBaseRpcDTO> findScpItemMap(List<Long> itemIds) {
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(itemIds);
        List itmItemScpBaseList = this.itmItemRpcService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        if (CollUtil.isEmpty((Collection)itmItemScpBaseList)) {
            return new HashMap<Long, ItmItemScpBaseRpcDTO>();
        }
        return itmItemScpBaseList.stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId, Function.identity()));
    }

    public Map<Long, ItmItemSimpleRpcDTO> findBaseItemMap(List<Long> itemIds) {
        List itmItemScpBaseList = this.itmItemRpcService.findSimpleItem(itemIds);
        if (CollUtil.isEmpty((Collection)itmItemScpBaseList)) {
            return new HashMap<Long, ItmItemSimpleRpcDTO>();
        }
        return itmItemScpBaseList.stream().collect(Collectors.toMap(ItmItemSimpleRpcDTO::getId, Function.identity()));
    }

    public Map<Long, List<String>> findRootBrandByCateId(Long cateId) {
        try {
            log.info("\u5546\u54c1\u54c1\u724c\u67e5\u8be2\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)cateId));
            Map itemBrand = this.itmItemRpcService.findRootBrandByCateId(cateId);
            log.info("\u5546\u54c1\u54c1\u724c\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)itemBrand));
            return itemBrand;
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u5546\u54c1\u54c1\u724c\u67e5\u8be2\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
            throw new BusinessException("\u5546\u54c1\u54c1\u724c\u67e5\u8be2\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public String getFirstCateByCodes(List<String> codes) {
        try {
            return this.itmItemRpcService.findFirstCateByCodes(codes);
        }
        catch (Exception e) {
            ExceptionUtil.handleRootException(e);
            log.error("\u83b7\u53d6\u9996\u9009\u5206\u7c7b\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new BusinessException("\u83b7\u53d6\u9996\u9009\u5206\u7c7b\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, List<ItmItemSpuBusinessRpcDTO>> findMoqByParam(List<String> spuCodes, String buCode) {
        if (StrUtil.isBlank((CharSequence)buCode)) {
            log.info("\u67e5\u8be2\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf\uff0cbuCode\u4e3a\u7a7a");
            return new HashMap<String, List<ItmItemSpuBusinessRpcDTO>>();
        }
        ItmItemBusinessRpcDtoParam businessRpcDtoParam = new ItmItemBusinessRpcDtoParam();
        businessRpcDtoParam.setSpuCodes(spuCodes);
        businessRpcDtoParam.setBusinessBuCode(buCode);
        List itemBusinessMoqList = this.itmItemRpcService.findItemBusinessMoq(businessRpcDtoParam);
        if (CollUtil.isNotEmpty((Collection)itemBusinessMoqList)) {
            return itemBusinessMoqList.stream().collect(Collectors.groupingBy(ItmItemSpuBusinessRpcDTO::getSpuCode));
        }
        return new HashMap<String, List<ItmItemSpuBusinessRpcDTO>>();
    }

    public Map<String, ItmBrandRpcDTO> getBrandMap(List<String> brandCodes) {
        if (CollUtil.isEmpty(brandCodes)) {
            return new HashMap<String, ItmBrandRpcDTO>();
        }
        ItmBrandRpcDtoParam itmBrandRpcDtoParam = new ItmBrandRpcDtoParam();
        itmBrandRpcDtoParam.setBrandCodes(brandCodes);
        List brandDtoByParam = this.itmBrandRpcService.findBrandDtoByParam(itmBrandRpcDtoParam);
        if (CollUtil.isNotEmpty((Collection)brandDtoByParam)) {
            return brandDtoByParam.stream().collect(Collectors.toMap(ItmBrandRpcDTO::getBrandCode, Function.identity()));
        }
        return new HashMap<String, ItmBrandRpcDTO>();
    }
}

