package com.elitesland.scp.infr.repo.mrp;



import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseVO;
import com.elitesland.scp.domain.entity.mrp.QScpThousandUseDO;
import com.elitesland.scp.domain.entity.mrp.ScpThousandUseDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Repository;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: wangly
 * @create: 2025-03-28
 * @Version 1.0
 **/
@Repository
@RequiredArgsConstructor
public class ScpThousandUseRepoProc {


    private final JPAQueryFactory jpaQueryFactory;
    private final ScpThousandUseRepo repo;
    private final QScpThousandUseDO qdo = QScpThousandUseDO.scpThousandUseDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ScpThousandUseVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ScpThousandUseVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 门店id
                qdo.stWhId,
                // 门店编码
                qdo.stWhCode,
                // 门店名称
                qdo.stWhName,
                // 门店类型
                qdo.stWhType,
                // 参考日期开始
                qdo.referenceDataStart,
                // 参考日期结束
                qdo.referenceDataEnd,
                // 有效日期开始
                qdo.validDataStart,
                // 有效日期结束
                qdo.validDataEnd,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param param 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ScpThousandUseVO> getJpaQueryWhere(ScpThousandUseParam param) {
        JPAQuery<ScpThousandUseVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(param));
        // 动态排序
        jpaQuery.orderBy(qdo.createTime.desc());
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param param 查询参数
     * @return jpaQuery对象
     */
    public long count(ScpThousandUseParam param) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(param));

        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param param 条件
     * @return {@link Predicate}
     */
    private Predicate where(ScpThousandUseParam param){
        List<Predicate> list = new ArrayList<>();
        list.add(qdo.deleteFlag.eq(0));
        /** id 精确 */
        if (!ObjectUtils.isEmpty(param.getId())) {
            list.add(qdo.id.eq(param.getId()));
        }
        /** 门店id 精确 */
        if (!ObjectUtils.isEmpty(param.getStWhId())) {
            list.add(qdo.stWhId.eq(param.getStWhId()));
        }
        /** 门店编码	 精确 */
        if (!ObjectUtils.isEmpty(param.getStWhCode())) {
            list.add(qdo.stWhCode.eq(param.getStWhCode()));
        }
        /** 门店名称 精确 */
        if (!ObjectUtils.isEmpty(param.getStWhName())) {
            list.add(qdo.stWhName.eq(param.getStWhName()));
        }
        /** 门店类型 精确 */
        if (!ObjectUtils.isEmpty(param.getStWhType())) {
            list.add(qdo.stWhType.eq(param.getStWhType()));
        }
        /** 参考日期开始 精确 */
        if (!ObjectUtils.isEmpty(param.getReferenceDataStart())) {
            list.add(qdo.referenceDataStart.eq(param.getReferenceDataStart()));
        }
        /** 参考日期结束 精确 */
        if (!ObjectUtils.isEmpty(param.getReferenceDataEnd())) {
            list.add(qdo.referenceDataEnd.eq(param.getReferenceDataEnd()));
        }
        if(param.getCheckFlag()!=null && param.getCheckFlag()){
            list.add(qdo.validDataStart.loe(param.getValidDataEnd()));
            list.add(qdo.validDataEnd.goe(param.getValidDataStart()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(param.getExt1())) {
            list.add(qdo.ext1.eq(param.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(param.getExt2())) {
            list.add(qdo.ext2.eq(param.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(param.getExt3())) {
            list.add(qdo.ext3.eq(param.getExt3()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ScpThousandUseVO queryByKey(Long id) {
        JPAQuery<ScpThousandUseVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param param 查询参数
     * @return 结果集合
     */
    public List<ScpThousandUseVO> queryListDynamic(ScpThousandUseParam param) {
        JPAQuery<ScpThousandUseVO> jpaQuery = getJpaQueryWhere(param);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param param 查询参数
     * @return 分页结果
     */
    public PagingVO<ScpThousandUseVO> queryPaging(ScpThousandUseParam param) {
        long total = count(param);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<ScpThousandUseVO> jpaQuery = getJpaQueryWhere(param);
        List<ScpThousandUseVO> result = jpaQuery
                .offset(param.getPageRequest().getOffset())
                .limit(param.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ScpThousandUseVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ScpThousandUseDO save(ScpThousandUseDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ScpThousandUseDO> saveAll(List<ScpThousandUseDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param param 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ScpThousandUseParam param) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(param.getId()));
        // id
        if (param.getId() != null) {
            update.set(qdo.id, param.getId());
        }
        // 门店id
        if (param.getStWhId() != null) {
            update.set(qdo.stWhId, param.getStWhId());
        }
        // 门店编码
        if (param.getStWhCode() != null) {
            update.set(qdo.stWhCode, param.getStWhCode());
        }
        // 门店名称
        if (param.getStWhName() != null) {
            update.set(qdo.stWhName, param.getStWhName());
        }
        // 门店类型
        if (param.getStWhType() != null) {
            update.set(qdo.stWhType, param.getStWhType());
        }
        // 参考日期开始
        if (param.getReferenceDataStart() != null) {
            update.set(qdo.referenceDataStart, param.getReferenceDataStart());
        }
        // 参考日期结束
        if (param.getReferenceDataEnd() != null) {
            update.set(qdo.referenceDataEnd, param.getReferenceDataEnd());
        }
        // 有效日期开始
        if (param.getValidDataStart() != null) {
            update.set(qdo.validDataStart, param.getValidDataStart());
        }
        // 有效日期结束
        if (param.getValidDataEnd() != null) {
            update.set(qdo.validDataEnd, param.getValidDataEnd());
        }
        // 拓展字段1
        if (param.getExt1() != null) {
            update.set(qdo.ext1, param.getExt1());
        }
        // 拓展字段2
        if (param.getExt2() != null) {
            update.set(qdo.ext2, param.getExt2());
        }
        // 拓展字段3
        if (param.getExt3() != null) {
            update.set(qdo.ext3, param.getExt3());
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

}