/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.cart;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.scp.application.facade.vo.cart.CartDetailParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDetailRespVO;
import com.elitesland.scp.application.facade.vo.param.app.AddressParamVO;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dbo/cart"}, produces={"application/json"})
@Api(value="\u7532\u6307\u4e59\u91c7-\u91c7\u8d2d\u8f66\u7ba1\u7406", tags={"\u7532\u6307\u4e59\u91c7-\u91c7\u8d2d\u8f66\u7ba1\u7406"})
public class DboCartManagerController {
    private static final Logger log = LoggerFactory.getLogger(DboCartManagerController.class);
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpStoreCartService scpStoreCartService;

    @PostMapping(value={"/cacheAddress"})
    public ApiResult<Boolean> cacheDboAddress(@RequestBody AddressParamVO addressParam) {
        try {
            GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
            assert (userDetails != null) : "\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
            OrgStoreBaseRpcParam storeParam = new OrgStoreBaseRpcParam();
            storeParam.setStoreCodeList(addressParam.getStoreCodeList());
            List stores = (List)this.orgStoreRpcService.findOrgStoreBaseByParam(storeParam).getData();
            if (stores == null || stores.isEmpty()) {
                return ApiResult.fail((String)"\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            String cacheKey = "DBO_ADDRESS_CACHE:" + userDetails.getUser().getUsername();
            RedisUtils.instance().del(new String[]{cacheKey});
            String addressJson = JSON.toJSONString((Object)addressParam);
            RedisUtils.instance().set(cacheKey, (Object)addressJson, 86400L);
            return ApiResult.ok((Object)true);
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5730\u5740\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ApiResult.fail((String)"\u5730\u5740\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25");
        }
    }

    @GetMapping(value={"/getCachedAddress"})
    @ApiOperation(value="\u67e5\u8be2\u7532\u6307\u4e59\u91c7\u62a5\u8d27\u5730\u5740\u7f13\u5b58")
    public ApiResult<AddressParamVO> getCachedAddress() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        assert (userDetails != null) : "\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        String cacheKey = "DBO_ADDRESS_CACHE:" + userDetails.getUser().getUsername();
        String addressJson = (String)RedisUtils.instance().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)addressJson)) {
            AddressParamVO addressParam = (AddressParamVO)JSON.parseObject((String)addressJson, AddressParamVO.class);
            return ApiResult.ok((Object)addressParam);
        }
        return ApiResult.ok((Object)new AddressParamVO());
    }

    @PostMapping(value={"/updateAddress"})
    public ApiResult<List<CartDetailRespVO>> updateAddress(@RequestBody CartDetailParamVO paramVO) {
        return ApiResult.ok(this.scpStoreCartService.detail(paramVO));
    }

    public DboCartManagerController(OrgStoreRpcService orgStoreRpcService, ScpStoreCartService scpStoreCartService) {
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpStoreCartService = scpStoreCartService;
    }
}

