/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.mrp;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDPlanRespVO;
import com.elitesland.scp.application.facade.vo.save.mrp.ScpMrpDPlanSaveVO;
import com.elitesland.scp.domain.convert.mrp.ScpMrpDPlanConvert;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDPlanDO;
import com.elitesland.scp.domain.service.mrp.ScpMrpDPlanDomainService;
import com.elitesland.scp.infr.repo.mrp.ScpMrpDPlanRepo;
import com.elitesland.scp.infr.repo.mrp.ScpMrpDPlanRepoProc;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpMrpDPlanDomainServiceImpl
implements ScpMrpDPlanDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpMrpDPlanDomainServiceImpl.class);
    private final ScpMrpDPlanRepo scpMrpDPlanRepo;
    private final ScpMrpDPlanRepoProc scpMrpDPlanRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasIds(List<Long> masIds) {
        this.scpMrpDPlanRepo.deleteByMasIds(masIds);
    }

    @Override
    public List<ScpMrpDPlanRespVO> findByMasIds(List<Long> masIds) {
        List<ScpMrpDPlanDO> scpMrpDPlanDOList = this.scpMrpDPlanRepo.findByMasIdIn(masIds);
        if (CollectionUtil.isEmpty(scpMrpDPlanDOList)) {
            return Collections.emptyList();
        }
        return ScpMrpDPlanConvert.INSTANCE.doToRespVO(scpMrpDPlanDOList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(List<ScpMrpDPlanSaveVO> saveVOList) {
        this.scpMrpDPlanRepo.saveAll(ScpMrpDPlanConvert.INSTANCE.saveVoToDo(saveVOList));
    }

    @Override
    @Transactional
    public List<ScpMrpDPlanDO> saveDO(List<ScpMrpDPlanDO> scpMrpDPlanDOList) {
        return this.scpMrpDPlanRepo.saveAll(scpMrpDPlanDOList);
    }

    @Override
    @Transactional
    public void updatePushStatus(List<Long> planIds, String pushStatus, String poNo, Long poDId, Integer poLineNo, String pushFailReason) {
        this.scpMrpDPlanRepoProc.updatePushStatus(planIds, pushStatus, poNo, poDId, poLineNo, pushFailReason);
    }

    @Override
    public List<ScpMrpDPlanRespVO> findByIds(List<Long> ids) {
        return this.scpMrpDPlanRepoProc.findByIds(ids);
    }

    @Override
    public List<ScpMrpDPlanRespVO> findByMrpId(Long mrpId) {
        return this.scpMrpDPlanRepoProc.findByMrpId(mrpId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpMrpDPlanRepo.deleteAllById(ids);
    }

    public ScpMrpDPlanDomainServiceImpl(ScpMrpDPlanRepo scpMrpDPlanRepo, ScpMrpDPlanRepoProc scpMrpDPlanRepoProc) {
        this.scpMrpDPlanRepo = scpMrpDPlanRepo;
        this.scpMrpDPlanRepoProc = scpMrpDPlanRepoProc;
    }
}

