/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.template;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.domain.entity.template.QScpTemplateSetDO;
import com.elitesland.scp.domain.entity.template.ScpTemplateOrderDO;
import com.elitesland.scp.domain.entity.template.ScpTemplateSetDO;
import com.elitesland.scp.dto.template.DemandOrderDetailRpcParamDTO;
import com.elitesland.scp.dto.template.DemandOrderDetailRpcRespDTO;
import com.elitesland.scp.dto.template.DemandOrderListRpcParamDTO;
import com.elitesland.scp.dto.template.DemandOrderListRpcRespDTO;
import com.elitesland.scp.enums.DayOfWeekEnumHelper;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.template.ScpDemandOrderTemplateRepoProc;
import com.elitesland.scp.infr.repo.template.ScpDemandTemplateSetRepo;
import com.elitesland.scp.infr.repo.template.ScpDemandTemplateSetRepoProc;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.service.template.DemandTemplateRpcService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DemandTemplateRpcServiceImpl
implements DemandTemplateRpcService {
    private static final Logger log = LoggerFactory.getLogger(DemandTemplateRpcServiceImpl.class);
    private final ScpDemandTemplateSetRepoProc scpDemandTemplateSetRepoProc;
    private final ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final ScpDemandTemplateSetRepo scpDemandTemplateSetRepo;
    private static final QScpTemplateSetDO scpTemplateSetDO = QScpTemplateSetDO.scpTemplateSetDO;
    private final RmiSysUDCService rmiSysUDCService;

    public ApiResult<List<DemandOrderListRpcRespDTO>> list(DemandOrderListRpcParamDTO dto) {
        OrgStoreDetailRpcDTO storeDetailRpcDTO;
        log.info("\u9009\u62e9\u6a21\u677f\u5217\u8868\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)dto));
        List<Object> templateSetList = this.scpDemandTemplateSetRepoProc.findTemplateSetList(dto);
        log.info("\u9009\u62e9\u6a21\u677f\u5217\u8868\u7ed3\u679c,\u8fc7\u6ee4\u524d:{}", (Object)JSONUtil.toJsonStr(templateSetList));
        templateSetList = templateSetList.stream().filter(e -> this.detailedTimeContainsDay(e.getDetailedTime())).collect(Collectors.toList());
        log.info("\u9009\u62e9\u6a21\u677f\u5217\u8868\u7ed3\u679c,\u8fc7\u6ee4\u8be6\u7ec6\u65e5\u671f\u540e:{}", (Object)JSONUtil.toJsonStr(templateSetList));
        String demandWhStCode = dto.getDemandWhStCode();
        String type = dto.getType();
        boolean isStore = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type);
        String region = "";
        if (isStore && (storeDetailRpcDTO = this.rmiOrgStoreRpcService.findOrgStoreByStoreCode(demandWhStCode)) != null) {
            region = storeDetailRpcDTO.getRegion();
        }
        List<Long> templateIds = templateSetList.stream().map(DemandOrderListRpcRespDTO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderList = this.scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIds);
        List tempIdsByType = orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(demandWhStCode)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        List<Object> tempIdsByRegion = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)region) && isStore) {
            String finalRegion = region;
            tempIdsByRegion = orderList.stream().filter(e -> e.getWhStZoCode() != null && e.getWhStZoCode().equals(finalRegion)).map(ScpTemplateOrderDO::getMasId).collect(Collectors.toList());
        }
        List<Object> expected = new ArrayList<Object>();
        expected.addAll(tempIdsByType);
        expected.addAll(tempIdsByRegion);
        List<Object> finalExpected = expected = expected.stream().distinct().collect(Collectors.toList());
        List<DemandOrderListRpcRespDTO> filterData = templateSetList.stream().filter(e -> finalExpected.contains(e.getId())).collect(Collectors.toList());
        log.info("\u52a0\u8f7d\u6a21\u677f\u67e5\u8be2\u7ed3\u679c,\u8fc7\u6ee4\u540e:{}", (Object)JSONUtil.toJsonStr(filterData));
        if (CollUtil.isEmpty(filterData)) {
            return ApiResult.ok();
        }
        List<Long> templateIdsFiltered = filterData.stream().map(DemandOrderListRpcRespDTO::getId).distinct().collect(Collectors.toList());
        List<ScpTemplateOrderDO> orderListFiltered = this.scpDemandOrderTemplateRepoProc.findByMasIdIn(templateIdsFiltered);
        Map<Long, BigDecimal> itemTypeMap = this.sumItemCodes(orderListFiltered);
        filterData.forEach(item -> item.setTypeNumber((BigDecimal)itemTypeMap.get(item.getId())));
        return ApiResult.ok(filterData);
    }

    public ApiResult<DemandOrderDetailRpcRespDTO> detail(DemandOrderDetailRpcParamDTO dto) {
        log.info("rpc\u8be6\u60c5\u67e5\u8be2\u5165\u53c2{}", (Object)JSONUtil.toJsonStr((Object)dto));
        DemandOrderDetailRpcRespDTO respVO = new DemandOrderDetailRpcRespDTO();
        Long id = dto.getId();
        String demandTemCode = dto.getDemandTemCode();
        if (id == null && StrUtil.isBlank((CharSequence)demandTemCode)) {
            return ApiResult.ok();
        }
        Optional templateSetRepoById = id != null ? this.scpDemandTemplateSetRepo.findById(id) : this.scpDemandTemplateSetRepo.findOne((Predicate)DemandTemplateRpcServiceImpl.scpTemplateSetDO.demandTemCode.eq((Object)demandTemCode));
        if (templateSetRepoById.isEmpty()) {
            return ApiResult.ok();
        }
        ScpTemplateSetDO templateSetDO = (ScpTemplateSetDO)((Object)templateSetRepoById.get());
        respVO.setRemark(templateSetDO.getRemark());
        respVO.setDemandTemCode(templateSetDO.getDemandTemCode());
        respVO.setDemandTemName(templateSetDO.getDemandTemName());
        respVO.setDetailedTime(templateSetDO.getDetailedTime());
        respVO.setStartDate(templateSetDO.getStartDate());
        respVO.setEndDate(templateSetDO.getEndDate());
        respVO.setDemandTemStatus(templateSetDO.getDemandTemStatus());
        respVO.setId(templateSetDO.getId());
        List<ScpTemplateOrderDO> orderData = this.scpDemandOrderTemplateRepoProc.findByMasId(templateSetDO.getId());
        if (CollUtil.isEmpty(orderData)) {
            return ApiResult.ok((Object)respVO);
        }
        List<ScpTemplateOrderDO> removeDuplicatesByWhStZoCode = this.removeDuplicatesByWhStZoCode(orderData);
        List whStZoObjects = removeDuplicatesByWhStZoCode.stream().map(order -> {
            DemandOrderDetailRpcRespDTO.WhStZoObject whStZoObject = new DemandOrderDetailRpcRespDTO.WhStZoObject();
            if (order.getType() != null) {
                whStZoObject.setType(order.getType().toString());
            }
            if (order.getType() != null) {
                whStZoObject.setTypeName(this.getTypeName(whStZoObject.getType()));
            }
            whStZoObject.setWhStZoId(order.getWhStZoId());
            whStZoObject.setWhStZoCode(order.getWhStZoCode());
            whStZoObject.setWhStZoName(order.getWhStZoName());
            whStZoObject.setDetailedAddress(order.getDetailedAddress());
            whStZoObject.setBelongOrgCode(order.getBelongOrgCode());
            whStZoObject.setBelongOrgName(order.getBelongOrgName());
            whStZoObject.setBelongOuCode(order.getBelongOuCode());
            whStZoObject.setBelongOuName(order.getBelongOuName());
            whStZoObject.setStoreType(order.getStoreType());
            if (StrUtil.isNotBlank((CharSequence)order.getStoreType())) {
                whStZoObject.setStoreTypeName(this.getStoreTypeName(order.getStoreType()));
            }
            return whStZoObject;
        }).collect(Collectors.toList());
        respVO.setWhStZoObjects(whStZoObjects);
        List<ScpTemplateOrderDO> removeDuplicatesByItemCode = this.removeDuplicatesByItemCode(orderData);
        List itemObjects = removeDuplicatesByItemCode.stream().map(order -> {
            DemandOrderDetailRpcRespDTO.ItemObject itemObject = new DemandOrderDetailRpcRespDTO.ItemObject();
            itemObject.setItemId(order.getItemId());
            itemObject.setItemCode(order.getItemCode());
            itemObject.setItemName(order.getItemName());
            itemObject.setItemCateCode(order.getItemCateCode());
            itemObject.setItemCateName(order.getItemCateName());
            itemObject.setItemSpec(order.getItemSpec());
            itemObject.setBasicUnitMeasure(order.getBasicUnitMeasure());
            itemObject.setWeight(SysUtils.processQtyScale(order.getWeight()));
            itemObject.setDemandQuantity(SysUtils.processQtyScale(order.getDemandQuantity()));
            itemObject.setTotalWeight(SysUtils.processQtyScale(order.getTotalWeight()));
            itemObject.setWeightUom(order.getWeightUom());
            itemObject.setWeightUomName(order.getWeightUomName());
            return itemObject;
        }).collect(Collectors.toList());
        respVO.setItemObjects(itemObjects);
        return ApiResult.ok((Object)respVO);
    }

    public Map<Long, BigDecimal> sumItemCodes(List<ScpTemplateOrderDO> orderData) {
        List filteredList = orderData.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getItemCode())).collect(Collectors.toList());
        HashMap<Long, Set> itemCodesMap = new HashMap<Long, Set>();
        HashMap<Long, BigDecimal> sumItemCodesMap = new HashMap<Long, BigDecimal>();
        for (ScpTemplateOrderDO order : filteredList) {
            Long masId = order.getMasId();
            String itemCode = order.getItemCode();
            if (itemCodesMap.containsKey(masId) && ((Set)itemCodesMap.get(masId)).contains(itemCode)) continue;
            BigDecimal sum = sumItemCodesMap.getOrDefault(masId, BigDecimal.ZERO);
            sum = sum.add(BigDecimal.ONE);
            sumItemCodesMap.put(masId, sum);
            Set itemCodes = itemCodesMap.getOrDefault(masId, new HashSet());
            itemCodes.add(itemCode);
            itemCodesMap.put(masId, itemCodes);
        }
        return sumItemCodesMap;
    }

    private boolean detailedTimeContainsDay(String detailedTimeStr) {
        DayOfWeek dayOfWeek = LocalDate.now().getDayOfWeek();
        String dayOfWeekStr = dayOfWeek.toString();
        List list = DayOfWeekEnumHelper.splitAndList((String)detailedTimeStr);
        return list.contains(dayOfWeekStr);
    }

    private String getTypeName(String type) {
        Map<String, String> templateOrderType = this.rmiSysUDCService.getCodeMap("yst-suplan", "TEMPLATE_ORDER_TYPE");
        return templateOrderType.get(type);
    }

    private String getStoreTypeName(String storeType) {
        Map<String, String> storeType2 = this.rmiSysUDCService.getCodeMap("yst-supp", "STORE_TYPE2");
        return storeType2.get(storeType);
    }

    public List<ScpTemplateOrderDO> removeDuplicatesByWhStZoCode(List<ScpTemplateOrderDO> orderData) {
        return orderData.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getWhStZoCode())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ScpTemplateOrderDO>(Comparator.comparing(ScpTemplateOrderDO::getWhStZoCode))), ArrayList::new));
    }

    public List<ScpTemplateOrderDO> removeDuplicatesByItemCode(List<ScpTemplateOrderDO> orderData) {
        return orderData.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getItemCode())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ScpTemplateOrderDO>(Comparator.comparing(ScpTemplateOrderDO::getItemCode))), ArrayList::new));
    }

    public DemandTemplateRpcServiceImpl(ScpDemandTemplateSetRepoProc scpDemandTemplateSetRepoProc, ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc, RmiOrgStoreRpcService rmiOrgStoreRpcService, ScpDemandTemplateSetRepo scpDemandTemplateSetRepo, RmiSysUDCService rmiSysUDCService) {
        this.scpDemandTemplateSetRepoProc = scpDemandTemplateSetRepoProc;
        this.scpDemandOrderTemplateRepoProc = scpDemandOrderTemplateRepoProc;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.scpDemandTemplateSetRepo = scpDemandTemplateSetRepo;
        this.rmiSysUDCService = rmiSysUDCService;
    }
}

