package com.elitesland.scp.domain.entity.stock;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
* @description: 预测安全库存目标库存批次记录
* @author: jeesie.jiang
* @create: 2025-01-21
* @Version 1.0
**/
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Table(name = "scp_predict_st_stock_calc")
@org.hibernate.annotations.Table(appliesTo = "scp_predict_st_stock_calc", comment = "预测安全库存目标库存批次记录")
public class ScpPredictStStockCalcDO extends BaseModel implements Serializable {

    @Column(name = "ou_id", columnDefinition = "bigint")
    @Comment("公司ID")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(40)")
    @Comment("公司编码")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(48)")
    @Comment("公司名称")
    private String ouName;

    @Column(name = "pred_lot_no", columnDefinition = "varchar(40)")
    @Comment("预测批次")
    private String predLotNo;

    @Column(name = "calcu_status", columnDefinition = "varchar(40)")
    @Comment("计算状态")
    private String calcuStatus;


    @Column(name = "calcu_msg", columnDefinition = "varchar(1000)")
    @Comment("失败原因")
    private String calcuMsg;





}