package com.elitesland.scp.domain.service.minOrder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingSaveVO;
import com.elitesland.scp.domain.convert.minOrder.ScpMinOrderSettingConvert;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingDO;
import com.elitesland.scp.infr.dto.minOrder.ScpMinOrderSettingDTO;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingRepo;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingRepoProc;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingStoreRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpMinOrderSettingDomainServiceImpl implements ScpMinOrderSettingDomainService {

    private final ScpMinOrderSettingRepo scpMinOrderSettingRepo;
    private final ScpMinOrderSettingRepoProc scpMinOrderSettingRepoProc;
    private final ScpMinOrderSettingStoreRepoProc scpMinOrderSettingStoreRepoProc;
    private final RmiSysUDCService rmiSysUDCService;

    @Override
    @SysCodeProc
    public PagingVO<ScpMinOrderSettingPageRespVO> queryMinOrderSettingList(ScpMinOrderSettingPageParamVO paramVO) {
        long count = scpMinOrderSettingRepoProc.countMinOrderSetting(paramVO);
        if (count > 0) {
            Map<String, String> docTypeMap = rmiSysUDCService.getCodeMap("yst-suplan", "OB_DOC_TYPE");
            var MinOrderSettings = scpMinOrderSettingRepoProc.queryMinOrderSetting(paramVO);
            Map<Long, Long> usedIdMap = getUsedIdMap(MinOrderSettings);
            MinOrderSettings.forEach(item -> {
                if (StrUtil.isNotBlank(item.getDocType())) {
                    List<String> itemCateName = StrUtil.split(item.getDocType(), ',').stream().map(docTypeMap::get).collect(Collectors.toList());
                    item.setDocTypeNames(itemCateName);
                }
                item.setUseFlag(usedIdMap.containsKey(item.getId()));
            });
            return new PagingVO<>(count, MinOrderSettings);
        }
        return new PagingVO<>();
    }

    private Map<Long, Long> getUsedIdMap(List<ScpMinOrderSettingPageRespVO> MinOrderSettings) {
        List<Long> ids = MinOrderSettings.stream().map(ScpMinOrderSettingPageRespVO::getId).collect(Collectors.toList());
        List<Long> usedSettings = scpMinOrderSettingStoreRepoProc.findUsedSettingByMasIds(ids);
        if (CollUtil.isNotEmpty(usedSettings)) {
            return usedSettings.stream().collect(Collectors.toMap(Long::valueOf, Function.identity()));
        }
        return new HashMap<>();
    }

    @Override
    @SysCodeProc
    public Optional<ScpMinOrderSettingDTO> findMinOrderSettingById(Long id) {
        return scpMinOrderSettingRepo.findById(id).map(ScpMinOrderSettingConvert.INSTANCE::doToDto);
    }

    @Override
    public Long saveMinOrderSetting(ScpMinOrderSettingSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpMinOrderSettingDO intentDO = ScpMinOrderSettingConvert.INSTANCE.saveVoToDO(saveVO);
            intentDO.setDocType(StrUtil.join(",", saveVO.getDocTypes()));
            Long masId = scpMinOrderSettingRepo.save(intentDO).getId();
            return masId;
        } else {
            Optional<ScpMinOrderSettingDO> option = scpMinOrderSettingRepo.findById(saveVO.getId());
            if (option.isEmpty()) {
                throw new BusinessException("订货强配活动ID：" + saveVO.getId() + "不存在");
            }
            ScpMinOrderSettingDO scpMinOrderSettingDO = option.get();
            ScpMinOrderSettingConvert.INSTANCE.copySaveParamToDo(saveVO, scpMinOrderSettingDO);
            scpMinOrderSettingDO.setDocType(StrUtil.join(",", saveVO.getDocTypes()));
            Long masId = scpMinOrderSettingRepo.save(scpMinOrderSettingDO).getId();
            return masId;
        }
    }

    @Override
    public void enableMinOrderSetting(List<Long> ids, Boolean enable) {
        scpMinOrderSettingRepoProc.enableMinOrderSetting(ids, enable);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        List<ScpMinOrderSettingDO> settingDOS = scpMinOrderSettingRepo.findByIdIn(ids);
        scpMinOrderSettingRepoProc.deleteByIds(ids);
    }
}
