package com.elitesland.scp.infr.repo.stock;

import com.elitesland.scp.domain.entity.stock.ScpSafetyTargetStockDO;
import com.elitesland.scp.infr.dto.stock.ScpSafetyTargetStockDTO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-01-15
* @Version 1.0
**/
@Repository
public interface ScpSafetyTargetStockRepo extends JpaRepository<ScpSafetyTargetStockDO, Long>, QuerydslPredicateExecutor<ScpSafetyTargetStockDO> {

    @Query(value = "select * from scp_safety_target_stock where (delete_flag=0 or delete_flag is null) " +
            "and CONCAT(COALESCE(ou_id, ''), COALESCE(wh_id, ''), COALESCE(item_id, '')) = (?1)",nativeQuery = true)
    List<ScpSafetyTargetStockDO> findByBusinessKey(String businessKey);


    @Query(value = "select * from scp_safety_target_stock where (delete_flag=0 or delete_flag is null) " +
            "and CONCAT(COALESCE(ou_id, ''), COALESCE(wh_id, ''), COALESCE(item_id, '')) in (?1)",nativeQuery = true)
    List<ScpSafetyTargetStockDO> findAllByBusinessKey(List<String> businessKeys);


    List<ScpSafetyTargetStockDO> findAllByBusinessIdIn(List<String> businessIds);

}
