package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "购物车保存对象", description = "购物车")
public class StoreCartSaveVO implements Serializable {
    private static final long serialVersionUID = 3257501573580086493L;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "采购车类型", required = true)
    @NotBlank(message = "采购车类型不能为空")
    private String cartType;

    @ApiModelProperty(value = "商品ID", required = true)
    @NotNull(message = "商品ID不能为空")
    private Long itemId;

    @ApiModelProperty(value = "商品编码", required = true)
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty(value = "商品名称", required = true)
    @NotBlank(message = "商品名称不能为空")
    private String itemName;

    @ApiModelProperty(value = "单位", required = true)
    @NotBlank(message = "单位不能为空")
    private String uom;

    @ApiModelProperty(value = "单位名称", required = true)
    @NotBlank(message = "单位名称不能为空")
    private String uomName;

    @ApiModelProperty(value = "商品SPU-ID", required = true)
    @NotNull(message = "商品SPU-ID不能为空")
    private Long spuId;

    @ApiModelProperty(value = "商品SPU编码", required = true)
    @NotBlank(message = "商品SPU编码不能为空")
    private String spuCode;

    @ApiModelProperty(value = "商品SPU名称", required = true)
    @NotBlank(message = "商品SPU名称不能为空")
    private String spuName;

    @ApiModelProperty("数量")
    @NotNull(message = "商品数量不能为空")
    private BigDecimal qty;

    @ApiModelProperty("含税单价(总价)")
    @NotNull(message = "含税单价不能为空")
    private BigDecimal itemPrice;

    @ApiModelProperty("销售单价（不含服务费）")
    private BigDecimal salePrice;

    @ApiModelProperty("结算单价")
    private BigDecimal settlementPrice;

    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("图片url")
    private String url;

    @ApiModelProperty(value = "商品品类编码")
    @NotBlank(message = "商品品类编码不能为空")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    @NotBlank(message = "商品品类名称不能为空")
    private String itemCateName;

    @ApiModelProperty("基本单位")
    @NotBlank(message = "基本单位不能为空")
    private String uom2;
    @ApiModelProperty(value = "基本单位名称")
    @NotBlank(message = "基本单位名称不能为空")
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    @NotNull(message = "单位转换系数不能为空")
    private BigDecimal uomRatio;

    @ApiModelProperty("有效位数")
    @NotNull(message = "有效位数不能为空")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "商品分类")
    @NotBlank(message = "商品分类不能为空")
    private String itemType;

    @ApiModelProperty(value = "包装规格")
    private String itemAttrName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty(value = "最小起订量")
    private BigDecimal moq;

    @ApiModelProperty(value = "商品配送类型")
    private String itemType2;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("仓配结算价")
    private BigDecimal costPrice;

    @ApiModelProperty("采购价")
    private BigDecimal purPrice;

    @ApiModelProperty("总价格")
    private BigDecimal price;

    @ApiModelProperty("科技费价格")
    private BigDecimal tefPrice;

    @ApiModelProperty("营销费价格")
    private BigDecimal mefPrice;

    @ApiModelProperty("运营费价格")
    private BigDecimal oefPrice;

    @ApiModelProperty("是否收取项目费用")
    private Boolean isProjFeeCharged;

    @ApiModelProperty(value = "配送类型")
    @NotBlank(message = "配送类型不能为空")
    private String deliveryType;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuCode;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuCode;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuCode;

    @ApiModelProperty("科技服务费用归属公司")
    private String tefFeeOuName;

    @ApiModelProperty("运营费服务费用归属公司")
    private String oefFeeOuName;

    @ApiModelProperty("营销费服务费用归属公司")
    private String mefFeeOuName;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty("预售状态")
    private Boolean preSaleStatus;
    /**
     * 甲指乙采 业务需要页面手动输入收货地址，购物车保存地址信息，便于取价
     */
    @ApiModelProperty("国家")
    private String country;
    private String countryName;

    @ApiModelProperty("省")
    private String province;
    private String provinceName;

    @ApiModelProperty("市")
    private String city;
    private String cityName;

    @ApiModelProperty("区县")
    private String county;
    private String countyName;

    @ApiModelProperty("详细地址")
    private String detailAddr;

    @ApiModelProperty("联系人")
    private String contPerson;

    @ApiModelProperty("联系人电话")
    private String tel;

}
