package com.elitesland.scp.application.facade.vo.query.msg;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 消息通用分页查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Getter
@Setter
@ApiModel(description = "已发布的消息通用分页查询参数")
public class CommonPublishedMessagePageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 536333389221483986L;

    @ApiModelProperty(value = "消息标题")
    private String title;

    @ApiModelProperty(value = "分类")
    private String category;

    @ApiModelProperty(value = "消息类型")
    private String messageType;

    @ApiModelProperty(value = "发布时间-起始")
    private LocalDateTime publishTimeStart;

    @ApiModelProperty(value = "发布时间-截止")
    private LocalDateTime publishTimeEnd;

    @ApiModelProperty(value = "接收人标识", required = true)
    private String receiverId;
}