package com.elitesland.scp.application.service.calendar;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetApproveVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSaveVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSubmitVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetImportDTO;

import java.util.List;
import java.util.Optional;

public interface ScpStoreCalendarSetService {

    /**
     * 门店订货日历配置查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpStoreCalendarSetPageRespVO> page(ScpStoreCalendarSetPageParamVO paramVO);

    /**
     * 门店订货日历配置详情查询
     *
     * @param id
     * @return
     */
    Optional<ScpStoreCalendarSetRespVO> findCalendarSetById(Long id);

    /**
     * 门店订货日历配置保存
     *
     * @param saveVO
     * @return
     */
    Long saveCalendarSet(ScpStoreCalendarSetSaveVO saveVO);

    /**
     * 删除
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 提交
     *
     * @param submitVO
     */
    void submit(ScpStoreCalendarSetSubmitVO submitVO);

    /**
     * 批量审批通过
     *
     * @param approveSaveParam
     */
    void batchApprove(ScpStoreCalendarSetApproveVO approveSaveParam);

    /**
     * 批量审批拒绝
     *
     * @param approveSaveParam
     */
    void batchReject(ScpStoreCalendarSetApproveVO approveSaveParam);

    void executeImport(List<ScpStoreCalendarSetImportDTO> scpStoreCalendarSetDTO);
}
