package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.*;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-28
* @Version 1.0
**/
public interface ScpStoreDemandCalendarDomainService {


    PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO createParam);


    void createBatch(List<ScpStoreDemandCalendarDO> createList);

    void deleteBatch(List<Long> ids);

    /**
     * 根据年月门店查询
     * @param concatKey
     * @return
     */
    List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthKey(List<String> concatKey);

    /**
     * 根据年月门店配送类型查询
     * @param
     * @return
     */
    List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthAndDeliveryTypeKey(Collection<String> typeSet,
                                                                              Collection<String> storeCodeSet,
                                                                              Collection<String> yearSet,
                                                                              Collection<String> monthSet,
                                                                              Collection<String> deliverySet);

    /**
     * 根据门店、年、月、日查询
     * @param concatKey
     * @return
     */
    List<ScpStoreDemandCalendarDO> findByStoreDayCalendar(List<String> concatKey);


    List<ScpStoreDemandCalendarDTO> listCalendarDTOs(ScpStoreDemandCalendarParam scpStoreDemandCalendarParam);

    List<ScpStoreDemandCalendarDTO> findStoreCalendarByParam(ScpStoreDemandCalendarParamVO param);

    /**
     * 根据条件查询日历门店信息
     * @param param
     * @return
     */
    List<ScpCalendarStoreRespVO> listStoreByQueryParam(ScpCalendarStoreQueryParamVO param);

    void batchInsert(List<ScpStoreDemandCalendarDO> createList,int batchSize);

    void deleteByStoreAndYear(String type, List<String> storeCodes,String year);

    void deleteByStoreAndYearAndDeliveryType(String type, List<String> storeCodes,String year, String deliveryType);

    void deleteByStoreAndYearAndMonth(String type, List<String> storeCodes,String year, String month);
    void deleteByStoreAndYearAndMonthAndDeliveryType(String type, List<String> storeCodes, String year, String month, String deliveryType);

    /**
     * 根据门店编号、区域和所属种类判断能否配送
     */
//    boolean isCanDelivery(String storeCode, String region, String deliveryType);

    /**
     * 根据门店编号、区域和所属种类返回字典
     */
    Map<String, Boolean> isCanDelivery(String storeCode, String region, List<String> deliveryType);
}