package com.elitesland.scp.domain.service.purLimit;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingSaveVO;
import com.elitesland.scp.domain.convert.purLimit.ScpPurLimitSettingConvert;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingDO;
import com.elitesland.scp.infr.dto.purLimit.ScpPurLimitSettingDTO;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingRepo;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingRepoProc;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingStoreRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpPurLimitSettingDomainServiceImpl implements ScpPurLimitSettingDomainService {

    private final ScpPurLimitSettingRepo scpPurLimitSettingRepo;
    private final ScpPurLimitSettingRepoProc scpPurLimitSettingRepoProc;
    private final ScpPurLimitSettingStoreRepoProc scpPurLimitSettingStoreRepoProc;
    private final RmiSysUDCService rmiSysUDCService;

    @Override
    @SysCodeProc
    public PagingVO<ScpPurLimitSettingPageRespVO> queryPurLimitSettingList(ScpPurLimitSettingPageParamVO paramVO) {
        long count = scpPurLimitSettingRepoProc.countPurLimitSetting(paramVO);
        if (count > 0) {
            Map<String, String> docTypeMap = rmiSysUDCService.getCodeMap("yst-suplan", "OB_DOC_TYPE");
            var PurLimitSettings = scpPurLimitSettingRepoProc.queryPurLimitSetting(paramVO);
            Map<Long, Long> usedIdMap = getUsedIdMap(PurLimitSettings);
            PurLimitSettings.forEach(item -> {
                if (StrUtil.isNotBlank(item.getDocType())) {
                    List<String> itemCateName = StrUtil.split(item.getDocType(), ',').stream().map(docTypeMap::get).collect(Collectors.toList());
                    item.setDocTypeNames(itemCateName);
                }
                item.setUseFlag(usedIdMap.containsKey(item.getId()));
            });
            return new PagingVO<>(count, PurLimitSettings);
        }
        return new PagingVO<>();
    }

    private Map<Long, Long> getUsedIdMap(List<ScpPurLimitSettingPageRespVO> PurLimitSettings) {
        List<Long> ids = PurLimitSettings.stream().map(ScpPurLimitSettingPageRespVO::getId).collect(Collectors.toList());
        List<Long> usedSettings = scpPurLimitSettingStoreRepoProc.findUsedSettingByMasIds(ids);
        if (CollUtil.isNotEmpty(usedSettings)) {
            return usedSettings.stream().collect(Collectors.toMap(Long::valueOf, Function.identity()));
        }
        return new HashMap<>();
    }

    @Override
    @SysCodeProc
    public Optional<ScpPurLimitSettingDTO> findPurLimitSettingById(Long id) {
        return scpPurLimitSettingRepo.findById(id).map(ScpPurLimitSettingConvert.INSTANCE::doToDto);
    }

    @Override
    public Long savePurLimitSetting(ScpPurLimitSettingSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpPurLimitSettingDO intentDO = ScpPurLimitSettingConvert.INSTANCE.saveVoToDO(saveVO);
            intentDO.setDocType(StrUtil.join(",", saveVO.getDocTypes()));
            Long masId = scpPurLimitSettingRepo.save(intentDO).getId();
            return masId;
        } else {
            Optional<ScpPurLimitSettingDO> option = scpPurLimitSettingRepo.findById(saveVO.getId());
            if (option.isEmpty()) {
                throw new BusinessException("订货强配活动ID：" + saveVO.getId() + "不存在");
            }
            ScpPurLimitSettingDO scpPurLimitSettingDO = option.get();
            ScpPurLimitSettingConvert.INSTANCE.copySaveParamToDo(saveVO, scpPurLimitSettingDO);
            scpPurLimitSettingDO.setDocType(StrUtil.join(",", saveVO.getDocTypes()));
            Long masId = scpPurLimitSettingRepo.save(scpPurLimitSettingDO).getId();
            return masId;
        }
    }

    @Override
    public void enablePurLimitSetting(List<Long> ids, Boolean enable) {
        scpPurLimitSettingRepoProc.enablePurLimitSetting(ids, enable);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        List<ScpPurLimitSettingDO> settingDOS = scpPurLimitSettingRepo.findByIdIn(ids);
        scpPurLimitSettingRepoProc.deleteByIds(ids);
    }
}
