package com.elitesland.scp.infr.repo.alloc;

import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingStoreDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

public interface ScpAllocSettingStoreRepo extends JpaRepository<ScpAllocSettingStoreDO, Long>, QuerydslPredicateExecutor<ScpAllocSettingStoreDO> {

    Optional<ScpAllocSettingStoreDO> findById(Long id);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_alloc_setting_store where mas_id = ?1 ", nativeQuery = true)
    void deleteByMasId(Long masId);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_alloc_setting_store where id in ?1 ", nativeQuery = true)
    void deleteByIds(List<Long> ids);

    @Modifying()
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_alloc_setting_store set alloc_num = alloc_num + 1 where mas_id in ?1 and store_code = ?2", nativeQuery = true)
    void updateAllocNumByParam(List<Long> masIds, String storeCode);

    @Modifying()
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update scp_alloc_setting_store set max_num = ?3 where mas_id = ?1 and store_code = ?2 ", nativeQuery = true)
    void updateMaxNumByParam(Long masId, String storeCode, BigDecimal maxNum);

    List<ScpAllocSettingStoreDO> findByMasId(Long masId);

    List<ScpAllocSettingStoreDO> findAllByStoreCodeIn(List<String> storeCodes);
}
