/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AddressParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemSpecParamVO;
import com.elitesland.scp.application.facade.vo.param.app.CommonItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.ScpStoreItemParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemActivityRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemSpecRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmSkuRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmSpuRespVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.AppItemActivityService;
import com.elitesland.scp.application.service.app.ScpCacheService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.item.ScpCateItemService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.app.ScpStoreItemConvert;
import com.elitesland.scp.domain.convert.authority.AppItmItemConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingItemDomainService;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingItemDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class AppItemActivityrServiceImpl
implements AppItemActivityService {
    private static final Logger log = LoggerFactory.getLogger(AppItemActivityrServiceImpl.class);
    private final RmiItemService rmiItemService;
    private final CartRedisUtil cartRedisUtil;
    private final CollectRedisUtil collectRedisUtil;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final ScpCacheService scpCacheService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final ScpCateItemService scpCateItemService;
    private final ScpMinOrderSettingItemDomainService scpMinOrderSettingItemDomainService;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService;
    private final ScpPurLimitSettingItemDomainService scpPurLimitSettingItemDomainService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpAllocSettingItemDomainService scpAllocSettingItemDomainService;
    private final TaskExecutor taskExecutor;

    @Override
    @SysCodeProc
    public PagingVO<AppItemActivityRespVO> query(AppItemActivityParamVO paramVO) throws ExecutionException, InterruptedException {
        return new PagingVO();
    }

    @Override
    public PagingVO<AppItmItemPageVO> itemPage(AppItemPageParamVO paramVO) {
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBusinessType())) {
            List<String> itemTypes = this.scpOrderSettingDomainService.findItemCatesByBusinessType(paramVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            paramVO.setItemTypes(itemTypes);
        }
        if (StrUtil.isBlank((CharSequence)paramVO.getBrand())) {
            return new PagingVO();
        }
        Long count = this.scpCateItemRepoProc.countAppItemSpu(paramVO);
        if (count == 0L) {
            return new PagingVO();
        }
        List<AppItmItemPageVO> itemList = this.scpCateItemRepoProc.pageAppItemSpu(paramVO);
        this.itemMessageImageAndDetailsQuery(itemList, paramVO.getStoreCode(), paramVO.getBusinessType(), paramVO.getOuCode());
        this.getPriceAndStock(paramVO.getBusinessType(), itemList, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        return new PagingVO(count.longValue(), itemList);
    }

    @Override
    public PagingVO<AppItmItemPageVO> skuItemPage(AppItemPageParamVO paramVO) {
        if (ScpUdcEnum.BUSINESS_TYPE_50.getValueCode().equals(paramVO.getBusinessType()) && paramVO.getAddressParam() == null) {
            log.error("\u88c5\u4fee\u7c7b\u4e1a\u52a1\uff0c\u6ca1\u6709\u83b7\u53d6\u7532\u6307\u4e59\u91c7\u7c7b\u5546\u54c1\u8ba2\u5355\u7684\u6536\u8d27\u4eba\u5730\u5740");
            return PagingVO.builder().total(0L).records(Collections.emptyList()).build();
        }
        return this.getAppItmItemPageVOPagingVO(paramVO);
    }

    private PagingVO<AppItmItemPageVO> getAppItmItemPageVOPagingVO(AppItemPageParamVO paramVO) {
        Map longBigDecimalMap;
        Map purLimitMap2;
        Map minOrderMap;
        Map allocSettingMap;
        Long count;
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBusinessType())) {
            List<String> deliveryTypes = this.scpOrderSettingDomainService.findDeliveryTypeByBusinessType(paramVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            paramVO.setDeliveryTypes(deliveryTypes);
        }
        if ((count = this.scpCateItemRepoProc.countAppItemAndWhNetSku(paramVO)) == 0L) {
            return new PagingVO();
        }
        List<AppItmItemPageVO> itemList = this.scpCateItemRepoProc.pageAppItemAndWhNetSku(paramVO);
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        ScpsmanInfoDO byLoginAccount = this.scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
        log.info("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7:{}", (Object)JSONUtil.toJsonStr((Object)((Object)byLoginAccount)));
        if (byLoginAccount == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u8ba2\u8d27\u8d26\u53f7\u67e5\u8be2\u5f02\u5e38");
        }
        String scpManType = byLoginAccount.getScpsmanType();
        List<String> itemCodeList = itemList.stream().map(AppItmItemPageVO::getItemCode).collect(Collectors.toList());
        List<String> usefulItemCodeList = this.getUsefulItemCodeList(paramVO, itemCodeList, scpManType);
        itemList = itemList.stream().filter(item -> usefulItemCodeList.contains(item.getItemCode())).collect(Collectors.toList());
        this.itemMessageImageAndDetailsQuery(itemList, paramVO.getStoreCode(), paramVO.getBusinessType(), paramVO.getOuCode());
        if (ScpUdcEnum.BUSINESS_TYPE_50.getValueCode().equals(paramVO.getBusinessType())) {
            this.getPurPriceAndStock(paramVO.getBusinessType(), itemList, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), paramVO.getAddressParam());
        } else {
            this.getPriceAndStock(paramVO.getBusinessType(), itemList, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        }
        List<String> preSaleItemCodeList = this.scpCateItemService.getPreSaleItemList(itemCodeList);
        log.info("\u5c0f\u7a0b\u5e8f\u9884\u552e\u5546\u54c1{}", (Object)JSONUtil.toJsonStr(preSaleItemCodeList));
        CompletableFuture<Map> allocSettingMapFuture = CompletableFuture.supplyAsync(() -> {
            List<ScpAllocSettingItemRespVO> allocSettingItemList = this.scpAllocSettingItemDomainService.getEnableAllocSettingItemByStoreCode(paramVO.getStoreCode(), paramVO.getBusinessType());
            if (CollUtil.isNotEmpty(allocSettingItemList)) {
                return allocSettingItemList.stream().collect(Collectors.toMap(ScpAllocSettingItemRespVO::getItemCode, Function.identity(), (k1, k2) -> k1));
            }
            return new HashMap();
        }, (Executor)this.taskExecutor);
        CompletableFuture<Map> minOrderMapFuture = CompletableFuture.supplyAsync(() -> {
            List<ScpMinOrderSettingItemRespVO> minOrderSettingItemRespVOList = this.scpMinOrderSettingItemDomainService.getEnableMinOrderSettingItemByStoreCode(paramVO.getStoreCode(), paramVO.getDeliveryTypes());
            if (CollUtil.isNotEmpty(minOrderSettingItemRespVOList)) {
                return minOrderSettingItemRespVOList.stream().collect(Collectors.toMap(ScpMinOrderSettingItemRespVO::getItemId, ScpMinOrderSettingItemRespVO::getMinNum, (k1, k2) -> k1));
            }
            return new HashMap();
        }, (Executor)this.taskExecutor);
        CompletableFuture<Map> purLimitMapFuture = CompletableFuture.supplyAsync(() -> {
            List<ScpPurLimitSettingItemRespVO> purLimitSettingItemByStoreCode = this.scpPurLimitSettingItemDomainService.getEnablePurLimitSettingItemByStoreCode(paramVO.getStoreCode(), paramVO.getDeliveryTypes());
            return purLimitSettingItemByStoreCode.stream().collect(Collectors.toMap(ScpPurLimitSettingItemRespVO::getItemId, ScpPurLimitSettingItemRespVO::getMinNum, (k1, k2) -> k1));
        }, (Executor)this.taskExecutor);
        CompletionStage longBigDecimalMapFuture = purLimitMapFuture.thenComposeAsync(purLimitMap -> {
            if (!CollUtil.isEmpty((Map)purLimitMap)) {
                return CompletableFuture.supplyAsync(() -> {
                    Map<Long, BigDecimal> longBigDecimalMap = this.scpDemandOrderRepoProc.countAllocatedOrderItemByItemCodes(new ArrayList<Long>(purLimitMap.keySet()), paramVO.getStoreCode(), LocalDateTime.now());
                    log.info("\u9650\u8d2d\u67e5\u8be2\u7ed3\u679c\uff1a{}", longBigDecimalMap);
                    return longBigDecimalMap;
                }, (Executor)this.taskExecutor);
            }
            return CompletableFuture.completedFuture(new HashMap());
        }, (Executor)this.taskExecutor);
        try {
            allocSettingMap = allocSettingMapFuture.get();
            minOrderMap = minOrderMapFuture.get();
            purLimitMap2 = purLimitMapFuture.get();
            longBigDecimalMap = (Map)((CompletableFuture)longBigDecimalMapFuture).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("\u5c0f\u7a0b\u5e8f\u5546\u54c1\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException(e.getMessage());
        }
        Map<String, String> itemType2 = this.rmiSysUDCService.getCodeMap("yst-supp", "ITEM_TYPE2");
        ArrayList<AppItmItemPageVO> noAvalQtyList = new ArrayList<AppItmItemPageVO>();
        ArrayList<AppItmItemPageVO> haveAvalQtyList = new ArrayList<AppItmItemPageVO>();
        for (AppItmItemPageVO item2 : itemList) {
            if (preSaleItemCodeList.contains(item2.getItemCode())) {
                item2.setPreSaleStatus(true);
            }
            BigDecimal moq = (BigDecimal)minOrderMap.get(item2.getItemId());
            item2.setMoq(moq);
            ScpAllocSettingItemRespVO scpAllocSettingItemRespVO = (ScpAllocSettingItemRespVO)allocSettingMap.get(item2.getItemCode());
            item2.setAllocLimitFlag(scpAllocSettingItemRespVO != null);
            Long itemId = item2.getItemId();
            BigDecimal purLimitQty = (BigDecimal)purLimitMap2.get(itemId);
            BigDecimal useQty = (BigDecimal)longBigDecimalMap.get(itemId);
            BigDecimal canUseQty = this.calculateCanUseQty(purLimitQty, useQty);
            if (canUseQty != null) {
                item2.setPurLimitQty(canUseQty);
            }
            Optional.ofNullable(itemType2.get(item2.getItemType2())).ifPresent(item2::setItemType2Name);
            List<AppItmItemPageVO> details = item2.getDetails();
            if (CollUtil.isNotEmpty(details)) {
                details.removeIf(detail -> detail.getPrice() == null);
            }
            if (details == null || details.isEmpty()) continue;
            AtomicReference<Object> avalQty = new AtomicReference<Object>(null);
            List<AppItmItemPageVO> collect = details.stream().peek(detail -> {
                detail.setMoq(moq);
                item2.setAllocLimitFlag(scpAllocSettingItemRespVO != null);
                if (canUseQty != null) {
                    detail.setPurLimitQty(canUseQty);
                }
                if (preSaleItemCodeList.contains(item2.getItemCode())) {
                    detail.setPreSaleStatus(true);
                }
                Optional.ofNullable((String)itemType2.get(detail.getItemType2())).ifPresent(detail::setItemType2Name);
                if (detail.getAvalQty() != null && avalQty.get() == null) {
                    avalQty.set(detail.getAvalQty());
                }
            }).toList();
            item2.setAvalQty(avalQty.get());
            item2.setDetails(collect);
            if (!ScpConstant.PUR_TRN_DELIVERY_TYPES.contains(item2.getItemType2()) && Objects.equals(item2.getAvalQty(), BigDecimal.ZERO)) {
                noAvalQtyList.add(item2);
                continue;
            }
            haveAvalQtyList.add(item2);
        }
        List processedItems = haveAvalQtyList.stream().filter(Objects::nonNull).sorted(Comparator.comparing(AppItmItemPageVO::getAvalQty, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(noAvalQtyList)) {
            processedItems.addAll(noAvalQtyList.stream().filter(Objects::nonNull).toList());
        }
        return new PagingVO(count.longValue(), processedItems);
    }

    private BigDecimal calculateCanUseQty(BigDecimal purLimitQty, BigDecimal useQty) {
        if (purLimitQty != null) {
            BigDecimal subtract = purLimitQty.subtract(useQty == null ? BigDecimal.ZERO : useQty);
            return BigDecimal.ZERO.compareTo(subtract) >= 0 ? BigDecimal.ZERO : subtract;
        }
        return null;
    }

    private List<AppItmItemPageVO> setStoreDemandCalendar(AppItemPageParamVO paramVO, List<AppItmItemPageVO> itemList, String scpManType) {
        List<Object> result = new ArrayList();
        String invisibleAccount = SysUtils.getInvisibleAccount();
        if (StrUtil.isNotBlank((CharSequence)scpManType) && StrUtil.isNotBlank((CharSequence)invisibleAccount)) {
            List invisibleAccountList = Arrays.stream(invisibleAccount.split(",")).collect(Collectors.toList());
            log.info("\u4e0d\u53ef\u89c1\u8d26\u53f7:{},\u5f53\u524d\u8d26\u53f7:{}", (Object)JSONUtil.toJsonStr(invisibleAccountList), (Object)scpManType);
            if (invisibleAccountList.contains(scpManType)) {
                Map<String, List<AppItmItemPageVO>> deliveryTypeAndItemMap = itemList.stream().collect(Collectors.groupingBy(AppItmItemPageVO::getItemType2));
                Map<String, Boolean> canDeliveryMap = this.storeDemandCalendarDomainService.isCanDelivery(paramVO.getStoreCode(), null, new ArrayList<String>(deliveryTypeAndItemMap.keySet()));
                log.info("\u5c0f\u7a0b\u5e8f\u53ef\u914d\u9001\u5546\u54c1\u7684\u914d\u9001\u7c7b\u578b:{}", (Object)JSONUtil.toJsonStr(canDeliveryMap));
                for (Map.Entry<String, List<AppItmItemPageVO>> entry : deliveryTypeAndItemMap.entrySet()) {
                    String deliveryType = entry.getKey();
                    List<AppItmItemPageVO> itemList1 = entry.getValue();
                    if (canDeliveryMap.get(deliveryType) != null && !canDeliveryMap.get(deliveryType).booleanValue()) continue;
                    result.addAll(itemList1);
                }
            } else {
                result = itemList;
            }
        } else {
            result = itemList;
        }
        return result;
    }

    private List<String> getUsefulItemCodeList(AppItemPageParamVO paramVO, List<String> itemCodeList, String scpManType) {
        List<String> usefulItemCodeList;
        String invisibleAccount = SysUtils.getInvisibleAccount();
        if (StrUtil.isNotBlank((CharSequence)scpManType) && StrUtil.isNotBlank((CharSequence)invisibleAccount)) {
            List invisibleAccountList = Arrays.stream(invisibleAccount.split(",")).collect(Collectors.toList());
            log.info("\u4e0d\u53ef\u89c1\u8d26\u53f7:{},\u5f53\u524d\u8d26\u53f7:{}", (Object)JSONUtil.toJsonStr(invisibleAccountList), (Object)scpManType);
            usefulItemCodeList = invisibleAccountList.contains(scpManType) ? this.scpCateItemService.getVisibleAndSaleAndUpItemList(itemCodeList, paramVO.getStoreCode()) : this.scpCateItemService.getSaleAndUpItemList(itemCodeList, paramVO.getStoreCode());
        } else {
            usefulItemCodeList = this.scpCateItemService.getSaleAndUpItemList(itemCodeList, paramVO.getStoreCode());
        }
        log.info("\u5c0f\u7a0b\u5e8f\u53ef\u552e\u53ef\u89c1\u4e0a\u4e0b\u67b6\u5546\u54c1{}", (Object)JSONUtil.toJsonStr(usefulItemCodeList));
        return usefulItemCodeList;
    }

    @Override
    public PagingVO<AppItmItemPageVO> commonItemPage(CommonItemPageParamVO paramVO) {
        if (StrUtil.isBlank((CharSequence)paramVO.getBrand())) {
            return new PagingVO();
        }
        Long count = this.scpCateItemRepoProc.countCommonItemSpu(paramVO);
        if (count == 0L) {
            return new PagingVO();
        }
        List<AppItmItemPageVO> itemList = this.scpCateItemRepoProc.pageCommonItemSpu(paramVO);
        this.itemMessageImageAndDetailsQuery(itemList, null, null, null);
        return new PagingVO(count.longValue(), itemList);
    }

    @Override
    public void getPriceAndStock(String businessType, List<AppItmItemPageVO> itemList, String storeCode, String type) {
        this.processPriceAndStock(businessType, itemList, storeCode, type, null, false);
    }

    @Override
    public void getPurPriceAndStock(String businessType, List<AppItmItemPageVO> itemList, String storeCode, String type, AddressParamVO addressParam) {
        this.processPriceAndStock(businessType, itemList, storeCode, type, addressParam, true);
    }

    private void processPriceAndStock(String businessType, List<AppItmItemPageVO> itemList, String storeCode, String type, AddressParamVO addressParam, boolean isPurPrice) {
        List<AppItemActivityItemPriceParamVO> priceParams = this.buildPriceParams(itemList, storeCode);
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<Map<String, BigDecimal>>(new HashMap());
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(businessType, type);
        log.info("\u5c0f\u7a0b\u5e8f\u4e0a\u67b6\u7684\u5546\u54c1{}", (Object)JSONUtil.toJsonStr(priceParams));
        Map<String, AppItemPriceRespVO> priceMap = isPurPrice ? this.commonPriceService.getPurPriceAndStockDetails(priceParams, storeCode, orderSetting, type, stockMapRef, addressParam) : this.commonPriceService.getNewPriceAndStockDetails(priceParams, storeCode, orderSetting, type, stockMapRef);
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        log.info("\u5c0f\u7a0b\u5e8f\u4e0a\u67b6\u5546\u54c1\u5e93\u5b58{}", (Object)JSONUtil.toJsonStr(stockMap));
        this.setItemPriceAndStock(itemList, priceMap, stockMap);
    }

    private List<AppItemActivityItemPriceParamVO> buildPriceParams(List<AppItmItemPageVO> itemList, String storeCode) {
        ArrayList<AppItemActivityItemPriceParamVO> priceParams = new ArrayList<AppItemActivityItemPriceParamVO>();
        for (AppItmItemPageVO item : itemList) {
            List<AppItmItemPageVO> details = item.getDetails();
            if (CollUtil.isEmpty(details)) continue;
            for (AppItmItemPageVO detail : details) {
                AppItemActivityItemPriceParamVO param = new AppItemActivityItemPriceParamVO();
                param.setStoreCode(storeCode);
                param.setItemCode(detail.getItemCode());
                param.setItemCateCode(detail.getItemCateCode());
                param.setUom(detail.getUom());
                param.setDeliveryType(detail.getItemType2());
                param.setItemId(detail.getItemId());
                param.setItemType2(detail.getItemType2());
                param.setCombineItemFlag(detail.getCombineItemFlag());
                param.setCombineItemCode(detail.getCombineItemCode());
                param.setActivityCode(detail.getActivityCode());
                priceParams.add(param);
            }
        }
        return priceParams;
    }

    private void setItemPriceAndStock(List<AppItmItemPageVO> itemList, Map<String, AppItemPriceRespVO> priceMap, Map<String, BigDecimal> stockMap) {
        for (AppItmItemPageVO item : itemList) {
            List<AppItmItemPageVO> details = item.getDetails();
            if (CollUtil.isEmpty(details)) continue;
            for (AppItmItemPageVO detail : details) {
                BigDecimal stockQty;
                String itemKey = SysUtils.getItemKey(detail.getCombineItemCode(), detail.getItemCode());
                AppItemPriceRespVO priceResp = priceMap.get(itemKey);
                if (detail.getCombineItemFlag().booleanValue()) {
                    detail.setPrice(detail.getPrice());
                    detail.setSalePrice(detail.getPrice());
                    detail.setPurPrice(detail.getPurPrice());
                    detail.setCostPrice(detail.getPrice());
                }
                if (priceResp != null) {
                    detail.setPrice(priceResp.getPrice());
                    detail.setSuppId(priceResp.getSuppId());
                    detail.setSuppCode(priceResp.getSuppCode());
                    detail.setSuppName(priceResp.getSuppName());
                    detail.setCostPrice(priceResp.getCostPrice());
                    detail.setPurPrice(priceResp.getPurPrice());
                    detail.setIsProjFeeCharged(priceResp.getIsProjFeeCharged());
                    detail.setOefPrice(priceResp.getOefPrice());
                    detail.setMefPrice(priceResp.getMefPrice());
                    detail.setTefPrice(priceResp.getTefPrice());
                    detail.setSalePrice(priceResp.getSalePrice());
                    detail.setTefFeeOuCode(priceResp.getTefFeeOuCode());
                    detail.setTefFeeOuName(priceResp.getTefFeeOuName());
                    detail.setOefFeeOuCode(priceResp.getOefFeeOuCode());
                    detail.setOefFeeOuName(priceResp.getOefFeeOuName());
                    detail.setMefFeeOuCode(priceResp.getMefFeeOuCode());
                    detail.setMefFeeOuName(priceResp.getMefFeeOuName());
                }
                detail.setAvalQty((stockQty = stockMap.get(detail.getItemCode())) != null ? stockQty : BigDecimal.ZERO);
            }
        }
    }

    private static List<AppItmItemPageVO> mergeObjectsAndDetails(List<AppItmItemPageVO> outerList) {
        ArrayList<AppItmItemPageVO> mergedList = new ArrayList<AppItmItemPageVO>();
        for (AppItmItemPageVO outerObject : outerList) {
            mergedList.add(outerObject);
            List<AppItmItemPageVO> detailList = outerObject.getDetails();
            if (detailList == null) continue;
            for (AppItmItemPageVO detailObject : detailList) {
                mergedList.add(detailObject);
            }
        }
        return mergedList;
    }

    @Override
    public AppItmSpuRespVO findIdOne(AppItemSpecParamVO paramVO) {
        ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
        scpStoreItemParamVO.setSpuId(paramVO.getSpuId());
        scpStoreItemParamVO.setOuCode(paramVO.getOuCode());
        List<ScpStoreItemDO> itemDOS = this.scpCacheService.getItem(scpStoreItemParamVO);
        if (CollUtil.isEmpty(itemDOS)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5546\u54c1");
        }
        List<ItmItemAttachmentRpcDTO> skuAttachmentList = itemDOS.stream().filter(row -> CollUtil.isNotEmpty(row.getSkuAttachmentList())).flatMap(item -> item.getSkuAttachmentList().stream()).collect(Collectors.toList());
        AppItmSpuRespVO appItmSpuRespVO = ScpStoreItemConvert.INSTANCE.doToRespVo(itemDOS.get(0));
        appItmSpuRespVO.setSkuAttchmentList(skuAttachmentList);
        appItmSpuRespVO.setSpuAttchmentList(itemDOS.get(0).getSpuAttachmentList());
        Long currentUserId = UserService.currentUserId();
        appItmSpuRespVO.setCollectFlag(this.collectRedisUtil.existsSpuInUser(paramVO.getStoreCode(), currentUserId, paramVO.getItemCode()));
        return appItmSpuRespVO;
    }

    @Override
    public AppItemSpecRespVO specQuery(AppItemSpecParamVO paramVO) {
        ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
        scpStoreItemParamVO.setSpuId(paramVO.getSpuId());
        scpStoreItemParamVO.setOuCode(paramVO.getOuCode());
        List<ScpStoreItemDO> itemDOS = this.scpCacheService.getItem(scpStoreItemParamVO);
        if (CollUtil.isEmpty(itemDOS)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5546\u54c1");
        }
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByBusinessType(paramVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItemActivityItemPriceParamVO> priceParamVOS = itemDOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom());
            priceParamVO.setItemType2(row.getItemType2());
            return priceParamVO;
        }).collect(Collectors.toList());
        Long currentUserId = UserService.currentUserId();
        Map<String, AppItemPriceRespVO> priceMap = this.commonPriceService.getNewPriceAndStockDetails(priceParamVOS, paramVO.getStoreCode(), orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItmSkuRespVO> skuRespVOList = itemDOS.stream().map(row -> {
            ScpStoreCartDO storeCartItem;
            AppItmSkuRespVO appItmSkuRespVO = ScpStoreItemConvert.INSTANCE.doToSkuRespVo((ScpStoreItemDO)row);
            AppItemPriceRespVO priceRespVO = (AppItemPriceRespVO)priceMap.get(row.getItemCode());
            if (priceRespVO != null) {
                appItmSkuRespVO.setPrice(priceRespVO.getPrice());
                appItmSkuRespVO.setSuppId(priceRespVO.getSuppId());
                appItmSkuRespVO.setSuppCode(priceRespVO.getSuppCode());
                appItmSkuRespVO.setStoreCode(priceRespVO.getStoreCode());
                appItmSkuRespVO.setCostPrice(priceRespVO.getCostPrice());
                appItmSkuRespVO.setPurPrice(priceRespVO.getPurPrice());
                appItmSkuRespVO.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                appItmSkuRespVO.setTefPrice(priceRespVO.getTefPrice());
                appItmSkuRespVO.setMefPrice(priceRespVO.getMefPrice());
                appItmSkuRespVO.setOefPrice(priceRespVO.getOefPrice());
                appItmSkuRespVO.setSalePrice(priceRespVO.getSalePrice());
                appItmSkuRespVO.setTefFeeOuCode(priceRespVO.getTefFeeOuCode());
                appItmSkuRespVO.setTefFeeOuName(priceRespVO.getTefFeeOuName());
                appItmSkuRespVO.setOefFeeOuCode(priceRespVO.getOefFeeOuCode());
                appItmSkuRespVO.setOefFeeOuName(priceRespVO.getOefFeeOuName());
                appItmSkuRespVO.setMefFeeOuCode(priceRespVO.getMefFeeOuCode());
                appItmSkuRespVO.setMefFeeOuName(priceRespVO.getMefFeeOuName());
            }
            if ((storeCartItem = this.cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(null, row.getItemCode()), paramVO.getStoreCode(), paramVO.getDocType(), currentUserId)) != null) {
                appItmSkuRespVO.setQty(storeCartItem.getQty());
            } else {
                appItmSkuRespVO.setQty(BigDecimal.ZERO);
            }
            return appItmSkuRespVO;
        }).collect(Collectors.toList());
        AppItemSpecRespVO result = new AppItemSpecRespVO();
        result.setMaxPrice(skuRespVOList.stream().map(AppItmSkuRespVO::getPrice).filter(Objects::nonNull).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
        result.setMinPrice(skuRespVOList.stream().map(AppItmSkuRespVO::getPrice).filter(Objects::nonNull).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
        result.setSkuRespVOList(skuRespVOList);
        return result;
    }

    @Override
    public void itemMessageImageAndDetailsQuery(List<AppItmItemPageVO> collect, String storeCode, String cartType, String ouCode) {
        Long currentUserId = UserService.currentUserId();
        ArrayList<Long> spuIdList = new ArrayList<Long>();
        HashMap<String, String> itemCodeAndItemType2Map = new HashMap<String, String>();
        for (AppItmItemPageVO appItmItemPageVO : collect) {
            Optional.ofNullable(appItmItemPageVO.getSpuId()).ifPresent(spuIdList::add);
            itemCodeAndItemType2Map.put(appItmItemPageVO.getItemCode(), appItmItemPageVO.getItemType2());
        }
        List<String> itemCodeList = this.scpCateItemRepoProc.pageItemCodesByParam(spuIdList);
        ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
        param.setItemCodes(itemCodeList);
        param.setBusinessBuCode(ouCode);
        List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = this.rmiItemService.findItemScpBaseRpcDtoByParam(param);
        Map<Long, List<ItmItemScpBaseRpcDTO>> groupData = itemRpcDtoByParam.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getSpuId));
        Iterator<AppItmItemPageVO> iterator = collect.iterator();
        while (iterator.hasNext()) {
            AppItmItemPageVO t = iterator.next();
            List itemScpBaseRpcDTOS = groupData.get(t.getSpuId());
            ItmItemScpBaseRpcDTO itmItemRpcDTO = itemScpBaseRpcDTOS.get(0);
            String itemStatus2 = itmItemRpcDTO.getItemStatus2();
            if ("DISABLE".equals(itemStatus2)) {
                iterator.remove();
                continue;
            }
            t.setItemName(itmItemRpcDTO.getItemName());
            t.setUom(itmItemRpcDTO.getUom2());
            t.setUomName(itmItemRpcDTO.getUom2Name());
            t.setItemType(itmItemRpcDTO.getItemType());
            t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
            if (t.getItemType2() == null) {
                t.setItemType2(itmItemRpcDTO.getItemType2());
                t.setItemType2Name(itmItemRpcDTO.getItemType2Name());
            }
            t.setBrand(itmItemRpcDTO.getBrand());
            t.setBrandName(itmItemRpcDTO.getBrandName());
            t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
            t.setSpec(itmItemRpcDTO.getSpec());
            t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
            t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
            t.setSpuId(itmItemRpcDTO.getSpuId());
            t.setSpuCode(itmItemRpcDTO.getSpuCode());
            t.setSpuName(itmItemRpcDTO.getSpuName());
            t.setUom2(itmItemRpcDTO.getUom());
            t.setUom2Name(itmItemRpcDTO.getUomName());
            t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
            t.setUomRatio(itmItemRpcDTO.getUomRatio2());
            t.setItemAttrName(StrUtil.isBlank((CharSequence)itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
            t.setAnotherName(itmItemRpcDTO.getAnotherName());
            t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
            t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
            t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
            t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
            t.setDetails(this.getDetails(CollectionUtils.isNotEmpty((Collection)itmItemRpcDTO.getSubItems()) ? itmItemRpcDTO.getSubItems() : itemScpBaseRpcDTOS, storeCode, cartType, currentUserId, itmItemRpcDTO, itemCodeAndItemType2Map));
            t.setCombineItemFlag(CollectionUtils.isNotEmpty((Collection)itmItemRpcDTO.getSubItems()));
            if (Boolean.TRUE.equals(t.getCombineItemFlag())) {
                AppItmItemPageVO subItem = t.getDetails().get(0);
                if (subItem.getQty() != null && subItem.getCombineQty() != null) {
                    t.setQty(subItem.getQty().divide(subItem.getCombineQty(), 2, RoundingMode.HALF_UP));
                }
                t.setCollectFlag(this.collectRedisUtil.existsSkuInUser(storeCode, currentUserId, SysUtils.getItemKey(subItem.getCombineItemCode(), subItem.getItemCode()), subItem.getItemId()));
                continue;
            }
            t.setCollectFlag(this.collectRedisUtil.existsSkuInUser(storeCode, currentUserId, SysUtils.getItemKey(t.getCombineItemCode(), t.getItemCode()), t.getItemId()));
        }
    }

    @SysCodeProc
    private List<AppItmItemPageVO> getDetails(List<ItmItemScpBaseRpcDTO> source, String storeCode, String cartType, Long currentUserId, ItmItemScpBaseRpcDTO parentItem, Map<String, String> itemCodeAndItemType2Map) {
        return source.stream().map(itmItemRpcDTO -> {
            AppItmItemPageVO t = new AppItmItemPageVO();
            t.setItemName(itmItemRpcDTO.getItemName());
            t.setUom(itmItemRpcDTO.getUom2());
            t.setUomName(itmItemRpcDTO.getUom2Name());
            t.setItemType(itmItemRpcDTO.getItemType());
            t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
            String s = (String)itemCodeAndItemType2Map.get(itmItemRpcDTO.getItemCode());
            if (s != null) {
                t.setItemType2(s);
            } else {
                t.setItemType2(itmItemRpcDTO.getItemType2());
                t.setItemType2Name(itmItemRpcDTO.getItemType2Name());
            }
            t.setBrand(itmItemRpcDTO.getBrand());
            t.setBrandName(itmItemRpcDTO.getBrandName());
            t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
            t.setSpec(itmItemRpcDTO.getSpec());
            t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
            t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
            t.setSpuId(itmItemRpcDTO.getSpuId());
            t.setSpuCode(itmItemRpcDTO.getSpuCode());
            t.setSpuName(itmItemRpcDTO.getSpuName());
            if (StrUtil.isNotBlank((CharSequence)cartType)) {
                ScpStoreCartDO storeCartItem = itmItemRpcDTO.getBomPid() != null ? this.cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(parentItem.getItemCode(), itmItemRpcDTO.getItemCode()), storeCode, cartType, currentUserId) : this.cartRedisUtil.getStoreCartItem(itmItemRpcDTO.getItemCode(), storeCode, cartType, currentUserId);
                if (storeCartItem != null) {
                    t.setQty(storeCartItem.getQty());
                } else {
                    t.setQty(BigDecimal.ZERO);
                }
            }
            t.setItemAttrName(StrUtil.isBlank((CharSequence)itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
            t.setAnotherName(itmItemRpcDTO.getAnotherName());
            t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
            t.setItemId(itmItemRpcDTO.getId());
            t.setItemCode(itmItemRpcDTO.getItemCode());
            t.setUom2(itmItemRpcDTO.getUom());
            t.setUom2Name(itmItemRpcDTO.getUomName());
            t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
            t.setUomRatio(itmItemRpcDTO.getUomRatio2());
            t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
            t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
            t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
            t.setMoq(itmItemRpcDTO.getMoq());
            t.setPrice(itmItemRpcDTO.getPrice());
            t.setCombineQty(itmItemRpcDTO.getBomQty());
            if (itmItemRpcDTO.getBomPid() != null) {
                t.setCombineItemFlag(Boolean.TRUE);
                t.setCombineItemCode(parentItem.getItemCode());
                t.setCombineItemName(parentItem.getItemName());
            } else {
                t.setCombineItemFlag(Boolean.FALSE);
            }
            return t;
        }).collect(Collectors.toList());
    }

    public AppItemActivityrServiceImpl(RmiItemService rmiItemService, CartRedisUtil cartRedisUtil, CollectRedisUtil collectRedisUtil, ScpCateItemRepoProc scpCateItemRepoProc, ScpCacheService scpCacheService, CommonPriceService commonPriceService, ScpOrderSettingDomainService scpOrderSettingDomainService, ScpWhNetRelationService scpWhNetRelationService, ScpCateItemService scpCateItemService, ScpMinOrderSettingItemDomainService scpMinOrderSettingItemDomainService, ScpsmanInfoRepo scpsmanInfoRepo, RmiSysUDCService rmiSysUDCService, ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService, ScpPurLimitSettingItemDomainService scpPurLimitSettingItemDomainService, ScpDemandOrderRepoProc scpDemandOrderRepoProc, ScpAllocSettingItemDomainService scpAllocSettingItemDomainService, TaskExecutor taskExecutor) {
        this.rmiItemService = rmiItemService;
        this.cartRedisUtil = cartRedisUtil;
        this.collectRedisUtil = collectRedisUtil;
        this.scpCateItemRepoProc = scpCateItemRepoProc;
        this.scpCacheService = scpCacheService;
        this.commonPriceService = commonPriceService;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.scpWhNetRelationService = scpWhNetRelationService;
        this.scpCateItemService = scpCateItemService;
        this.scpMinOrderSettingItemDomainService = scpMinOrderSettingItemDomainService;
        this.scpsmanInfoRepo = scpsmanInfoRepo;
        this.rmiSysUDCService = rmiSysUDCService;
        this.storeDemandCalendarDomainService = storeDemandCalendarDomainService;
        this.scpPurLimitSettingItemDomainService = scpPurLimitSettingItemDomainService;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
        this.scpAllocSettingItemDomainService = scpAllocSettingItemDomainService;
        this.taskExecutor = taskExecutor;
    }
}

