/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.mrp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseParam;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseRefParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseRefExportVO;
import com.elitesland.scp.application.service.mrp.ScpThousandUseService;
import com.elitesland.scp.enums.MrpStoreTypeEnum;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ScpThousandUseImportServiceImpl
implements DataImport<ScpThousandUseRefExportVO> {
    private static final Logger log = LoggerFactory.getLogger(ScpThousandUseImportServiceImpl.class);
    private static final String LINE = "\n";
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u6821\u9a8c\u5f02\u5e38: {2}; ";
    private final TransactionTemplate transactionTemplate;
    private final ScpThousandUseService scpThousandUseService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiItemService rmiItemService;

    public Set<Integer> sheetNoList() {
        return Collections.singleton(1);
    }

    public Integer stepSize() {
        return 1000000;
    }

    public String getTmplCode() {
        return "yst_scp_mrp_thousand_use";
    }

    public List<String> executeImport(List<ScpThousandUseRefExportVO> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        try {
            List<String> errorMsg = this.checkAndSaveData(dataList, startRowIndex);
            if (CollectionUtil.isNotEmpty(errorMsg)) {
                log.info("\u5343\u5143\u7528\u91cf\u5bfc\u5165\u5b8c\u6210,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b:{}", (Object)JSONUtil.toJsonStr(errorMsg));
            } else {
                log.info("\u5343\u5143\u7528\u91cf\u5bfc\u5165\u5b8c\u6210,\u672a\u53d1\u751f\u9519\u8bef");
            }
            return errorMsg;
        }
        catch (Exception e) {
            for (ScpThousandUseRefExportVO entity : dataList) {
                errors.add(e.getMessage());
            }
            return errors;
        }
    }

    private List<String> checkAndSaveData(List<ScpThousandUseRefExportVO> dataList, int startRowIndex) {
        LinkedHashMap<Integer, String> errMsgMap = new LinkedHashMap<Integer, String>();
        Integer index = 0;
        for (ScpThousandUseRefExportVO entity : dataList) {
            entity.setRowNo(index);
            errMsgMap.put(index, null);
            Integer n = index;
            index = index + 1;
        }
        log.info("startRowIndex\u7684\u503c:{}", (Object)startRowIndex);
        HashSet<String> errorIdSet = new HashSet<String>();
        List<ScpThousandUseParam> dataToSave = this.prepareData(dataList, errMsgMap, errorIdSet);
        log.info("\u5343\u5143\u7528\u91cf\u5bfc\u5165\uff0c\u51c6\u5907\u597d\u7684\u6570\u636e:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(dataToSave), (Object)JSONUtil.toJsonStr(errMsgMap));
        this.transactionTemplate.setPropagationBehavior(3);
        for (ScpThousandUseParam vo : dataToSave) {
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    this.scpThousandUseService.save(vo);
                }
                catch (Exception e) {
                    log.error("MRP\u8ba1\u5212\u5bfc\u5165\u62a5\u9519\uff1a" + e);
                    transactionStatus.setRollbackOnly();
                }
                return null;
            });
        }
        log.info("\u5199\u5165\u81ea\u5b9a\u4e49\u63d0\u793a\u8bed:{}", (Object)"\u5bfc\u5165\u6210\u529f");
        HttpServletUtil.currentRequest().setAttribute("orderMsg", (Object)"\u5bfc\u5165\u6210\u529f");
        return new ArrayList<String>(errMsgMap.values());
    }

    private List<ScpThousandUseParam> prepareData(List<ScpThousandUseRefExportVO> dataList, Map<Integer, String> errMsgMap, Set<String> errorIdSet) {
        Map<String, List<ScpThousandUseRefExportVO>> exportMap = dataList.stream().collect(Collectors.groupingBy(s -> s.getStWhCode() + "," + s.getReferenceDataStart() + "," + s.getReferenceDataEnd() + "," + s.getValidDataStart() + "," + s.getValidDataEnd()));
        HashSet storeCodes = new HashSet();
        HashSet itemCodeList = new HashSet();
        dataList.stream().forEach(p -> {
            if (StringUtils.hasText((String)p.getStWhCode()) && StringUtils.hasText((String)p.getItemCode())) {
                storeCodes.add(p.getStWhCode());
                itemCodeList.add(p.getItemCode());
            }
        });
        log.info("\u95e8\u5e97\u7f16\u7801\u96c6\u5408:{}", (Object)JSONUtil.toJsonStr(storeCodes));
        List<OrgStoreDetailRpcDTO> queryByStoreCodes = this.rmiOrgStoreRpcService.queryByStoreCodes(new ArrayList<String>(storeCodes));
        Map storeMap = queryByStoreCodes.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, Function.identity()));
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(new ArrayList(itemCodeList));
        List<ItmItemRpcDTO> itemRpcDtoList = this.rmiItemService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        Map itemRpcDTOMap = itemRpcDtoList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, Function.identity()));
        ArrayList<ScpThousandUseParam> paramList = new ArrayList<ScpThousandUseParam>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        exportMap.forEach((k, v) -> {
            ScpThousandUseParam param = new ScpThousandUseParam();
            String[] split = k.split(",");
            if (StringUtils.hasText((String)split[0]) && storeMap.containsKey(split[0])) {
                OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = (OrgStoreDetailRpcDTO)storeMap.get(split[0]);
                param.setStWhId(orgStoreDetailRpcDTO.getId());
                param.setStWhCode(split[0]);
                param.setStWhName(orgStoreDetailRpcDTO.getStoreName());
                String storeType1 = ((ScpThousandUseRefExportVO)v.get(0)).getStWhType();
                if (StringUtils.hasText((String)storeType1) && StringUtils.hasText((String)storeType1.trim())) {
                    String storeType = "";
                    for (MrpStoreTypeEnum mrpStoreTypeEnum : MrpStoreTypeEnum.values()) {
                        if (!mrpStoreTypeEnum.getDesc().equals(storeType1.trim())) continue;
                        storeType = mrpStoreTypeEnum.getCode();
                    }
                    param.setStWhType(storeType);
                }
                try {
                    param.setReferenceDataStart(simpleDateFormat.parse(split[1]));
                    param.setReferenceDataEnd(simpleDateFormat.parse(split[2]));
                    param.setValidDataStart(simpleDateFormat.parse(split[3]));
                    param.setValidDataEnd(simpleDateFormat.parse(split[4]));
                }
                catch (ParseException e) {
                    return;
                }
                ArrayList<ScpThousandUseRefParam> refParams = new ArrayList<ScpThousandUseRefParam>();
                v.forEach(p -> {
                    if (itemRpcDTOMap.containsKey(p.getItemCode())) {
                        ItmItemRpcDTO itmItemRpcDTO = (ItmItemRpcDTO)itemRpcDTOMap.get(p.getItemCode());
                        ScpThousandUseRefParam refParam = new ScpThousandUseRefParam();
                        refParam.setItemId(itmItemRpcDTO.getId());
                        refParam.setUom2(itmItemRpcDTO.getUom2Name());
                        refParam.setItemName(itmItemRpcDTO.getItemName());
                        refParam.setItemAttr(itmItemRpcDTO.getSpec());
                        refParam.setItemType(itmItemRpcDTO.getItemCateFullName());
                        refParam.setItemCode(p.getItemCode());
                        refParam.setUom(itmItemRpcDTO.getUomName());
                        refParam.setAdjustThousNum(p.getAdjustThousNum());
                        refParam.setEstimateThousNum(p.getEstimateThousNum());
                        refParam.setExt1(itmItemRpcDTO.getBrandName());
                        refParams.add(refParam);
                    }
                });
                if (!CollectionUtils.isEmpty(refParams)) {
                    param.setScpThousandUseRefParamList(refParams);
                }
            }
            paramList.add(param);
        });
        return paramList;
    }

    public static void addErrMsg(Map<Integer, String> errMsgMap, Integer rowNo, String msg) {
        ScpThousandUseImportServiceImpl.addErrMsg(errMsgMap, Collections.singletonList(rowNo), msg);
    }

    public static void addErrMsg(Map<Integer, String> errMsgMap, List<Integer> rowNos, String msg) {
        for (Integer rowNo : rowNos) {
            if (errMsgMap.containsKey(rowNo) && errMsgMap.get(rowNo) != null) {
                String newMsg = errMsgMap.get(rowNo) + LINE + msg;
                errMsgMap.put(rowNo, newMsg);
                continue;
            }
            errMsgMap.put(rowNo, msg);
        }
    }

    public ScpThousandUseImportServiceImpl(TransactionTemplate transactionTemplate, ScpThousandUseService scpThousandUseService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiItemService rmiItemService) {
        this.transactionTemplate = transactionTemplate;
        this.scpThousandUseService = scpThousandUseService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiItemService = rmiItemService;
    }
}

