package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 17:11
 * @Description:
 */
@Data
@ApiModel(description = "采购车汇总信息入参")
public class CartDataSummaryParamVO implements Serializable {

    @ApiModelProperty(value = "门店编码",required = true)
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "采购车类型",required = true)
    @NotBlank(message = "采购车类型不能为空")
    private String cartType;

    @ApiModelProperty(value = "是否只统计勾选商品")
    private Boolean checkSelectedStatusFlag;
}
