
package com.elitesland.scp.application.web.supalloc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.supalloc.*;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDtoParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 供应商份额分配 前端控制器
 * </p>
 *
 * @author jeesie.jiang
 * @since 2024-03-25
 */
@Slf4j
@Api(tags = "供应商份额分配接口")
@RestController
@RequestMapping(value = "/supplyAlloc", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpSupplyAllocationController {

    private final ScpSupplyAllocationService scpSupplyAccountService;


    @PostMapping("/page")
    @ApiOperation("供应商份额分配-分页")
    public ApiResult<PagingVO<ScpSupplyAllocationPageVO>> search(@RequestBody ScpSupplyAllocationPageParamVO queryParam) {
        return ApiResult.ok(scpSupplyAccountService.page(queryParam));
    }

    @PostMapping("/save")
    @ApiOperation("供应商份额分配-新增/编辑")
    public ApiResult saveSupplyAllocation(@RequestBody ScpSupplyAllocatioSaveVO createParam) {
        return ApiResult.ok(scpSupplyAccountService.saveSupplyAllocation(createParam));
    }


    @PutMapping("/header")
    @ApiOperation("供应商份额分配-详情查询")
    public ApiResult<List<ScpSupplyAllocationRespVO>> findSupplyAllocationList(@Valid @RequestBody ScpSupplyAllocationParamVO param) {
        return ApiResult.ok(scpSupplyAccountService.findSupplyAllocationList(param));
    }

    @PutMapping("/delete")
    @ApiOperation("供应商份额分配-删除")
    public ApiResult deleteWhNetRelation(@RequestBody List<Long> ids) {
        scpSupplyAccountService.deleteWhNetRelation(ids);
        return ApiResult.ok();
    }

    @PostMapping("/findSupplyAllocationByParam")
    @ApiOperation("供应商份额分配条件查询")
    public ApiResult<List<ScpSupplyAllocationRpcDTO>> findSupplyAllocationByParam(@RequestBody ScpSupplyAllocationRpcDtoParam queryParam) {
        return ApiResult.ok(scpSupplyAccountService.findSupplyAllocationRpcByParam(queryParam));
    }

    @PostMapping("/scpmanAuthorityPage")
    @ApiOperation("供应商份额分配-计划员数据权限分页")
    public ApiResult<PagingVO<ScpSupplyAllocationPageVO>>scpmanAuthorityPage(@RequestBody ScpSupplyAllocationPageParamVO queryParam) {
        return ApiResult.ok(scpSupplyAccountService.scpmanAuthorityPage(queryParam));
    }

    @PutMapping("/batch/delete")
    @ApiOperation("供应商份额分配-批量删除")
    public ApiResult batchDelete(@RequestBody List<Long> ids) {
        scpSupplyAccountService.batchDelete(ids);
        return ApiResult.ok();
    }
}
