/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.calendar;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetImportDTO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetImportVO;
import com.elitesland.scp.application.service.calendar.ScpStoreCalendarSetService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ScpStoreCalendarSetImportImpl
implements DataImport<ScpStoreCalendarSetImportVO> {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreCalendarSetImportImpl.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private final ScpStoreCalendarSetService scpStoreCalendarSetService;
    private final RmiOrgStoreRpcService rmiOrgStoreService;
    private final TaskExecutor taskExecutor;

    public String getTmplCode() {
        return "scp_store_calendar_set_import";
    }

    public List<String> executeImport(List<ScpStoreCalendarSetImportVO> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        log.info("\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u5bfc\u5165\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(dataList));
        ArrayList<String> errors = new ArrayList<String>(dataList.size());
        try {
            return this.checkAndSaveData(dataList, startRowIndex);
        }
        catch (Exception e) {
            for (ScpStoreCalendarSetImportVO entity : dataList) {
                errors.add(e.getMessage());
            }
            return errors;
        }
    }

    private List<String> checkAndSaveData(List<ScpStoreCalendarSetImportVO> dataList, int startRowIndex) throws Exception {
        if (CollUtil.isEmpty(dataList)) {
            log.error("\u8ba1\u5212\u5458\u6743\u9650\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        CompletableFuture<List> completeOrgStoreDetailRpcDTOS = CompletableFuture.supplyAsync(() -> this.storeQuery(dataList), (Executor)this.taskExecutor);
        Map<String, List<ScpStoreCalendarSetImportVO>> scpMap = dataList.stream().collect(Collectors.groupingBy(t -> t.getType() + t.getStoreCode() + t.getDeliveryType() + t.getYear()));
        List orgStoreInfoList = completeOrgStoreDetailRpcDTOS.get();
        Map<Object, Object> orgStoreInfoMap = CollUtil.isNotEmpty((Collection)orgStoreInfoList) ? orgStoreInfoList.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, Function.identity(), (old, newValue) -> old)) : Collections.emptyMap();
        ArrayList<String> errorList = new ArrayList<String>();
        for (ScpStoreCalendarSetImportVO importVO : dataList) {
            Object errorLog = "";
            if (StringUtils.isBlank((CharSequence)importVO.getType())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u7c7b\u578b", "\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getStoreCode())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u95e8\u5e97\u7f16\u7801", "\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getDeliveryType())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u914d\u9001\u7c7b\u578b", "\u914d\u9001\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getYear())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u5e74\u4efd", "\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getMonday())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u661f\u671f\u4e00", "\u661f\u671f\u4e00\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getTuesday())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u661f\u671f\u4e8c", "\u661f\u671f\u4e8c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getWednesday())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u661f\u671f\u4e09", "\u661f\u671f\u4e09\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getThursday())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u661f\u671f\u56db", "\u661f\u671f\u56db\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getFriday())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u661f\u671f\u4e94", "\u661f\u671f\u4e94\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getSaturday())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u661f\u671f\u516d", "\u661f\u671f\u516d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getSunday())) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u661f\u671f\u65e5", "\u661f\u671f\u65e5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!orgStoreInfoMap.isEmpty() && StringUtils.isNotBlank((CharSequence)importVO.getStoreCode())) {
                Optional<OrgStoreDetailRpcDTO> store = Optional.ofNullable((OrgStoreDetailRpcDTO)orgStoreInfoMap.get(importVO.getStoreCode()));
                if (store.isPresent()) {
                    importVO.setStoreName(store.get().getStoreName());
                    importVO.setStoreId(store.get().getId());
                } else if (Objects.equals(importVO.getType(), "STORE")) {
                    errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u95e8\u5e97\u7f16\u7801", "\u95e8\u5e97\u4e0d\u5b58\u5728");
                }
            } else if (StringUtils.isNotBlank((CharSequence)importVO.getType()) && Objects.equals(importVO.getType(), "STORE")) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u95e8\u5e97\u7f16\u7801", "\u95e8\u5e97\u4e0d\u5b58\u5728");
            }
            String checkMessage = importVO.getType() + importVO.getStoreCode() + importVO.getDeliveryType() + importVO.getYear();
            if (MapUtils.isNotEmpty(scpMap) && scpMap.get(checkMessage) != null && scpMap.get(checkMessage).size() > 1) {
                errorLog = (String)errorLog + MessageFormat.format(ERROR_TEMPLATE, startRowIndex, "\u6570\u636e", "\u5b58\u5728\u591a\u884c\u91cd\u590d\u6570\u636e");
            }
            errorList.add((String)(StringUtils.isNotBlank((CharSequence)errorLog) ? errorLog : null));
            ++startRowIndex;
        }
        if (CollectionUtil.isNotEmpty(errorList) && !errorList.stream().allMatch(Objects::isNull)) {
            return errorList;
        }
        ArrayList<ScpStoreCalendarSetImportDTO> scpStoreCalendarSetDTOList = new ArrayList<ScpStoreCalendarSetImportDTO>();
        Map<String, List<ScpStoreCalendarSetImportVO>> stringListMap = dataList.stream().collect(Collectors.groupingBy(t -> t.getType() + t.getDeliveryType() + t.getYear()));
        stringListMap.forEach((k, v) -> {
            ScpStoreCalendarSetImportVO scpStoreCalendarSetImportVO = (ScpStoreCalendarSetImportVO)v.get(0);
            ScpStoreCalendarSetImportDTO scpStoreCalendarSetDTO = new ScpStoreCalendarSetImportDTO();
            scpStoreCalendarSetDTO.setDeliveryType(scpStoreCalendarSetImportVO.getDeliveryType());
            scpStoreCalendarSetDTO.setType(scpStoreCalendarSetImportVO.getType());
            int year = Integer.parseInt(scpStoreCalendarSetImportVO.getYear());
            scpStoreCalendarSetDTO.setStartYear(year);
            scpStoreCalendarSetDTO.setEndYear(year);
            List<String> storeCodeList = v.stream().map(ScpStoreCalendarSetImportVO::getStoreCode).toList();
            scpStoreCalendarSetDTO.setStoreRegionCodeList(storeCodeList);
            ArrayList<ScpStoreCalendarSetLineRespVO> monday = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> monday2 = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> tuesday = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> tuesday2 = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> wednesday = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> wednesday2 = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> thursday = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> thursday2 = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> friday = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> friday2 = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> saturday = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> saturday2 = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> sunday = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            ArrayList<ScpStoreCalendarSetLineRespVO> sunday2 = new ArrayList<ScpStoreCalendarSetLineRespVO>();
            for (ScpStoreCalendarSetImportVO storeCalendarSetImportVO : v) {
                this.setWeekInfo(storeCalendarSetImportVO, storeCalendarSetImportVO.getMonday(), monday, monday2);
                this.setWeekInfo(storeCalendarSetImportVO, storeCalendarSetImportVO.getTuesday(), tuesday, tuesday2);
                this.setWeekInfo(storeCalendarSetImportVO, storeCalendarSetImportVO.getWednesday(), wednesday, wednesday2);
                this.setWeekInfo(storeCalendarSetImportVO, storeCalendarSetImportVO.getThursday(), thursday, thursday2);
                this.setWeekInfo(storeCalendarSetImportVO, storeCalendarSetImportVO.getFriday(), friday, friday2);
                this.setWeekInfo(storeCalendarSetImportVO, storeCalendarSetImportVO.getSaturday(), saturday, saturday2);
                this.setWeekInfo(storeCalendarSetImportVO, storeCalendarSetImportVO.getSunday(), sunday, sunday2);
            }
            scpStoreCalendarSetDTO.setMonday(monday);
            scpStoreCalendarSetDTO.setMonday2(monday2);
            scpStoreCalendarSetDTO.setTuesday(tuesday);
            scpStoreCalendarSetDTO.setTuesday2(tuesday2);
            scpStoreCalendarSetDTO.setWednesday(wednesday);
            scpStoreCalendarSetDTO.setWednesday2(wednesday2);
            scpStoreCalendarSetDTO.setThursday(thursday);
            scpStoreCalendarSetDTO.setThursday2(thursday2);
            scpStoreCalendarSetDTO.setFriday(friday);
            scpStoreCalendarSetDTO.setFriday2(friday2);
            scpStoreCalendarSetDTO.setSaturday(saturday);
            scpStoreCalendarSetDTO.setSaturday2(saturday2);
            scpStoreCalendarSetDTO.setSunday(sunday);
            scpStoreCalendarSetDTO.setSunday2(sunday2);
            scpStoreCalendarSetDTOList.add(scpStoreCalendarSetDTO);
        });
        this.scpStoreCalendarSetService.executeImport(scpStoreCalendarSetDTOList);
        return null;
    }

    private void setWeekInfo(ScpStoreCalendarSetImportVO storeCalendarSetImportVO, String sunday1, List<ScpStoreCalendarSetLineRespVO> sunday, List<ScpStoreCalendarSetLineRespVO> sunday2) {
        ScpStoreCalendarSetLineRespVO scpStoreCalendarSetLineRespVO = new ScpStoreCalendarSetLineRespVO();
        scpStoreCalendarSetLineRespVO.setStoreId(storeCalendarSetImportVO.getStoreId());
        scpStoreCalendarSetLineRespVO.setStoreCode(storeCalendarSetImportVO.getStoreCode());
        scpStoreCalendarSetLineRespVO.setStoreName(storeCalendarSetImportVO.getStoreName());
        if (Objects.equals(sunday1, "W")) {
            sunday.add(scpStoreCalendarSetLineRespVO);
        } else if (Objects.equals(sunday1, "E")) {
            sunday2.add(scpStoreCalendarSetLineRespVO);
        }
    }

    private List<OrgStoreDetailRpcDTO> storeQuery(List<ScpStoreCalendarSetImportVO> dataList) {
        List<String> storeCodeList = dataList.stream().filter(t -> t.getType().equals("STORE")).map(ScpStoreCalendarSetImportVO::getStoreCode).distinct().toList();
        if (CollectionUtil.isEmpty(storeCodeList)) {
            return null;
        }
        return this.rmiOrgStoreService.queryByStoreCodes(storeCodeList);
    }

    public Integer stepSize() {
        return 1000;
    }

    public Set<Integer> sheetNoList() {
        return Set.of(Integer.valueOf(1));
    }

    public ScpStoreCalendarSetImportImpl(ScpStoreCalendarSetService scpStoreCalendarSetService, RmiOrgStoreRpcService rmiOrgStoreService, TaskExecutor taskExecutor) {
        this.scpStoreCalendarSetService = scpStoreCalendarSetService;
        this.rmiOrgStoreService = rmiOrgStoreService;
        this.taskExecutor = taskExecutor;
    }
}

