/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.whnet.OuInfo;
import com.elitesland.scp.application.facade.vo.whnet.OuInfoQueryParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationBaseParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationExportRespVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationImportVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationPageParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationPageVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationRespVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationResultVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.inv.ScpWhNetRelationConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.whnet.ScpWhNetRelationDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.whnet.ScpWhNetRelationDomainService;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.whnet.ScpWhNetRelationDTO;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepo;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.scp.param.ScpWhNetRelationParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.path.SupportTransactionPathRpcService;
import com.elitesland.support.provider.path.dto.SupportTransactionPathDRpcDTO;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpWhNetRelationServiceImpl
implements ScpWhNetRelationService {
    private static final Logger log = LoggerFactory.getLogger(ScpWhNetRelationServiceImpl.class);
    private final ScpWhNetRelationDomainService scpWhNetRelationDomainService;
    private final ScpWhNetRelationRepo scpWhNetRelationRepo;
    private final ItmItemRpcService itmItemRpcService;
    private final UdcProvider udcProvider;
    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;
    private final UdcProvider systemService;
    private final InvWhProvider whProvider;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final RmiInvStkRpcService rmiInvStkService;
    private final SupportTransactionPathRpcService supportTransactionPathRpcService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final OrgOuRpcService orgOuRpcService;

    @Override
    public PagingVO<ScpWhNetRelationPageVO> page(ScpWhNetRelationPageParamVO queryParam) {
        if (Boolean.TRUE.equals(queryParam.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> pagingVO = this.getAuthorityPageRespVOPagingVO();
            if (pagingVO.isEmpty()) {
                return new PagingVO();
            }
            this.extractedAuthorityParam(queryParam, pagingVO);
        }
        return this.scpWhNetRelationDomainService.page(queryParam);
    }

    @Override
    public OuInfo findOuInfo(OuInfoQueryParamVO queryParam) {
        OuInfo ouInfo = this.getOuInfoFromPathCode(queryParam.getSupplyWhCode(), queryParam.getDemandWhStCode(), queryParam.getType());
        log.info("\u4ed3\u7f51\u5173\u7cfb,\u67e5\u8be2\u9500\u552e\u516c\u53f8\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)ouInfo));
        return ouInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<?> saveWhNetRelation(ScpWhNetRelationSaveVO createParam) {
        List<ScpWhNetRelationSaveVO.ScpWhNetRelation> whNetRelationList = createParam.getScpWhNetRelations();
        Map<String, List<ScpWhNetRelationSaveVO.ScpWhNetRelation>> groupMap = whNetRelationList.stream().collect(Collectors.groupingBy(d -> d.getDemandWhStCode() + d.getDeliveryType() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())));
        Set<String> strings = groupMap.keySet();
        List<ScpWhNetRelationDO> existList = this.scpWhNetRelationDomainService.findByConcatKey(strings);
        Map<String, List<ScpWhNetRelationDO>> existMap = existList.stream().collect(Collectors.groupingBy(d -> d.getDemandWhStCode() + d.getDeliveryType() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())));
        HashSet<String> modifySet = new HashSet<String>();
        ScpWhNetRelationResultVO result = new ScpWhNetRelationResultVO();
        ArrayList failList = new ArrayList();
        ArrayList successList = new ArrayList();
        ArrayList<ScpWhNetRelationSaveVO.ScpWhNetRelation> saveInfo = new ArrayList<ScpWhNetRelationSaveVO.ScpWhNetRelation>();
        ArrayList updateTimeList = new ArrayList();
        for (Map.Entry<String, List<ScpWhNetRelationSaveVO.ScpWhNetRelation>> scpWhNetRelation : groupMap.entrySet()) {
            String relationKey = scpWhNetRelation.getKey();
            List<ScpWhNetRelationSaveVO.ScpWhNetRelation> whNetRelations = scpWhNetRelation.getValue();
            long count = whNetRelations.stream().filter(d -> d.getId() != null).count();
            List activateList = whNetRelations.stream().filter(d -> Boolean.TRUE.equals(d.getStatus())).collect(Collectors.toList());
            long count1 = activateList.stream().map(d -> d.getSupplyWhCode() + d.getDemandWhStCode() + d.getType() + d.getItemCateCode() + d.getItemCode() + d.getStatus()).count();
            long count2 = activateList.stream().map(d -> d.getSupplyWhCode() + d.getDemandWhStCode() + d.getType() + d.getItemCateCode() + d.getItemCode() + d.getStatus()).distinct().count();
            if (count2 != count1) {
                String errorMsg = String.format("\u9700\u6c42\u4ed3\u5e93-\u5546\u54c1\u54c1\u7c7b-\u5546\u54c1\u3010%s-%s-%s\u3011\u5b58\u5728\u76f8\u540c\u3010\u4f9b\u5e94\u5546\u4ed3-\u7c7b\u578b\u3011\u7ec4\u5408\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", whNetRelations.get(0).getDemandWhStCode(), whNetRelations.get(0).getItemCateCode(), whNetRelations.get(0).getItemCode());
                throw new BusinessException(ApiCode.FAIL, errorMsg);
            }
            if (!CollUtil.isNotEmpty(activateList)) continue;
            if (count == 0L && existMap.containsKey(relationKey)) {
                List<ScpWhNetRelationDO> existingRelations = existMap.get(relationKey);
                ArrayList<ScpWhNetRelationSaveVO.ScpWhNetRelation> newRelations = new ArrayList<ScpWhNetRelationSaveVO.ScpWhNetRelation>();
                if (existingRelations != null && !existingRelations.isEmpty()) {
                    for (ScpWhNetRelationDO existing : existingRelations) {
                        whNetRelations.forEach(newRel -> {
                            boolean b = !LocalDateTimeUtil.isOverlap((ChronoLocalDateTime)newRel.getStartTime(), (ChronoLocalDateTime)newRel.getEndTime(), (ChronoLocalDateTime)existing.getStartTime(), (ChronoLocalDateTime)existing.getEndTime());
                            log.info("\u4ed3\u7f51\u6709\u6548\u671f\u662f\u5426\u4ea4\u53c9\u5224\u65ad\u7ed3\u679c{},{},{},{},{}", new Object[]{b, newRel.getStartTime(), newRel.getEndTime(), existing.getStartTime(), existing.getEndTime()});
                            if (b) {
                                newRelations.add((ScpWhNetRelationSaveVO.ScpWhNetRelation)newRel);
                            } else if (newRel.getStartTime().isBefore(existing.getStartTime()) && newRel.getEndTime().isAfter(existing.getStartTime()) && newRel.getEndTime().isBefore(existing.getEndTime())) {
                                newRelations.add(this.getScpWhNetRelation((ScpWhNetRelationSaveVO.ScpWhNetRelation)newRel, newRel.getStartTime(), newRel.getEndTime()));
                                existing.setStartTime(newRel.getEndTime());
                                updateTimeList.add(existing);
                            } else if (newRel.getStartTime().isAfter(existing.getStartTime()) && newRel.getEndTime().isAfter(existing.getEndTime()) && newRel.getStartTime().isBefore(existing.getEndTime())) {
                                newRelations.add(this.getScpWhNetRelation((ScpWhNetRelationSaveVO.ScpWhNetRelation)newRel, newRel.getStartTime(), newRel.getEndTime()));
                                existing.setEndTime(newRel.getStartTime());
                                updateTimeList.add(existing);
                            } else if (newRel.getStartTime().isBefore(existing.getStartTime()) && newRel.getEndTime().isAfter(existing.getEndTime())) {
                                newRelations.add(this.getScpWhNetRelation((ScpWhNetRelationSaveVO.ScpWhNetRelation)newRel, newRel.getStartTime(), existing.getStartTime()));
                                newRelations.add(this.getScpWhNetRelation((ScpWhNetRelationSaveVO.ScpWhNetRelation)newRel, existing.getEndTime(), newRel.getEndTime()));
                                existing.setStartTime(newRel.getEndTime());
                                existing.setEndTime(newRel.getStartTime());
                                updateTimeList.add(existing);
                            } else if (existing.getStartTime().isBefore(newRel.getStartTime()) && existing.getEndTime().isAfter(newRel.getEndTime())) {
                                ScpWhNetRelationSaveVO.ScpWhNetRelation splitEntry3 = new ScpWhNetRelationSaveVO.ScpWhNetRelation();
                                BeanUtils.copyProperties((Object)existing, (Object)splitEntry3);
                                newRelations.add(this.getScpWhNetRelation(splitEntry3, existing.getStartTime(), newRel.getStartTime()));
                                newRelations.add(this.getScpWhNetRelation((ScpWhNetRelationSaveVO.ScpWhNetRelation)newRel, newRel.getStartTime(), newRel.getEndTime()));
                                existing.setStartTime(newRel.getEndTime());
                                updateTimeList.add(existing);
                            }
                        });
                    }
                } else {
                    newRelations.addAll(whNetRelations);
                }
                whNetRelations.clear();
                whNetRelations.addAll(newRelations);
            } else if (count > 0L && existMap.containsKey(relationKey)) {
                modifySet.add(relationKey);
            }
            saveInfo.addAll(whNetRelations);
        }
        if (CollUtil.isEmpty(failList)) {
            List<ScpWhNetRelationDTO> whNetRelationDOS = saveInfo.stream().map(ScpWhNetRelationConvert.INSTANCE::saveVoDto).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(modifySet)) {
                List<ScpWhNetRelationDO> modifyList = this.scpWhNetRelationDomainService.findByConcatKey(modifySet);
                List<Long> existIds = modifyList.stream().map(ScpWhNetRelationDO::getId).collect(Collectors.toList());
                this.scpWhNetRelationDomainService.deleteBatch(existIds);
            }
            this.checkTransactionPath(whNetRelationDOS, createParam.getSkipPathFlag());
            this.scpWhNetRelationDomainService.createBatch(whNetRelationDOS);
            if (CollUtil.isNotEmpty(updateTimeList)) {
                this.scpWhNetRelationRepo.saveAll(updateTimeList);
            }
            return ((ApiResult)((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().success(true)).code(200)).data((Object)result)).msg("\u64cd\u4f5c\u6210\u529f")).build();
        }
        return ((ApiResult)((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().success(false)).code(0)).data((Object)result)).msg("\u64cd\u4f5c\u5931\u8d25")).build();
    }

    private ScpWhNetRelationSaveVO.ScpWhNetRelation getScpWhNetRelation(ScpWhNetRelationSaveVO.ScpWhNetRelation newRel, LocalDateTime startTime, LocalDateTime endTime) {
        ScpWhNetRelationSaveVO.ScpWhNetRelation splitEntry = new ScpWhNetRelationSaveVO.ScpWhNetRelation();
        BeanUtils.copyProperties((Object)newRel, (Object)splitEntry);
        splitEntry.setId(null);
        splitEntry.setStartTime(startTime);
        splitEntry.setEndTime(endTime);
        return splitEntry;
    }

    private void checkTransactionPath(List<ScpWhNetRelationDTO> whNetRelationList, Boolean skipPathFlag) {
        List<String> whCodes = whNetRelationList.stream().map(ScpWhNetRelationDTO::getSupplyWhCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> whMap = this.buildInvWhMap(whCodes);
        List<String> demandWhCodes = whNetRelationList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(row.getType())).map(ScpWhNetRelationDTO::getDemandWhStCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> demandWhMap = this.buildInvWhMap(demandWhCodes);
        List<String> demandStoreCodes = whNetRelationList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).map(ScpWhNetRelationDTO::getDemandWhStCode).distinct().collect(Collectors.toList());
        Map<String, OrgStoreBaseRpcDTO> fStoreMap = this.getStoreMap(demandStoreCodes);
        ArrayList<SupportTransactionPathRpcParam> rpcParams = new ArrayList<SupportTransactionPathRpcParam>();
        whNetRelationList.forEach(row -> {
            Long whOuId;
            String demandWhStCode = row.getDemandWhStCode();
            String supplyWhCode = row.getSupplyWhCode();
            Long ouId = row.getDemandWhStOuId() != null ? row.getDemandWhStOuId() : (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? ((OrgStoreBaseRpcDTO)fStoreMap.get(demandWhStCode)).getOuId() : ((InvWhRpcSimpleDTO)demandWhMap.get(demandWhStCode)).getOuId());
            Long l = whOuId = row.getSupplyWhOuId() != null ? row.getSupplyWhOuId() : ((InvWhRpcSimpleDTO)whMap.get(supplyWhCode)).getOuId();
            if (!ouId.equals(whOuId)) {
                SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
                rpcParam.setCompanyIdStart(whOuId);
                rpcParam.setCompanyIdEnd(ouId);
                rpcParams.add(rpcParam);
            }
        });
        Map<String, List<SupportTransactionPathRpcDTO>> suppTransactionPathMap = this.checkTransactionPathAndBuild(rpcParams);
        ArrayList<ScpWhNetRelationDTO> result = new ArrayList<ScpWhNetRelationDTO>();
        whNetRelationList.forEach(row -> {
            String whOuCode;
            Long ouId;
            String demandWhStCode = row.getDemandWhStCode();
            String supplyWhCode = row.getSupplyWhCode();
            Long l = row.getDemandWhStOuId() != null ? row.getDemandWhStOuId() : (ouId = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? ((OrgStoreBaseRpcDTO)fStoreMap.get(demandWhStCode)).getOuId() : ((InvWhRpcSimpleDTO)demandWhMap.get(demandWhStCode)).getOuId());
            String ouCode = StringUtils.isNotEmpty((String)row.getDemandWhStOuCode()) ? row.getDemandWhStOuCode() : (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? ((OrgStoreBaseRpcDTO)fStoreMap.get(demandWhStCode)).getOuCode() : ((InvWhRpcSimpleDTO)demandWhMap.get(demandWhStCode)).getOuCode());
            Long whOuId = row.getSupplyWhOuId() != null ? row.getSupplyWhOuId() : ((InvWhRpcSimpleDTO)whMap.get(supplyWhCode)).getOuId();
            String string = whOuCode = StringUtils.isNotEmpty((String)row.getSupplyWhOuCode()) ? row.getSupplyWhOuCode() : ((InvWhRpcSimpleDTO)whMap.get(supplyWhCode)).getOuCode();
            if (!ouId.equals(whOuId)) {
                List pathList = (List)suppTransactionPathMap.get(whOuId + "@" + ouId);
                if (CollUtil.isEmpty((Collection)pathList) || StrUtil.isBlank((CharSequence)((SupportTransactionPathRpcDTO)pathList.get(0)).getPathCode())) {
                    log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)whOuId, (Object)ouId);
                    if (Boolean.TRUE.equals(skipPathFlag)) {
                        throw new BusinessException("\u4ece\u516c\u53f8\u3010" + whOuCode + "\u3011\u81f3\u516c\u53f8\u3010" + ouCode + "\u3011\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
                    }
                } else {
                    result.add((ScpWhNetRelationDTO)row);
                }
                List detailList = ((SupportTransactionPathRpcDTO)pathList.get(0)).getDetailList();
                int size = detailList.size();
                SupportTransactionPathDRpcDTO dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
                row.setCustCode(dto.getCompanyCodeStart());
                row.setOuCode(dto.getCompanyCodeStart());
                row.setOuName(dto.getCompanyNameStart());
                row.setCustCode(dto.getCustCodeEnd());
            } else {
                result.add((ScpWhNetRelationDTO)row);
            }
        });
        whNetRelationList = result;
    }

    private Map<String, OrgStoreBaseRpcDTO> getStoreMap(List<String> demandStoreCodes) {
        List<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOS = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandStoreCodes);
        if (CollUtil.isEmpty(orgStoreBaseRpcDTOS)) {
            return new HashMap<String, OrgStoreBaseRpcDTO>();
        }
        return orgStoreBaseRpcDTOS.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, List<SupportTransactionPathRpcDTO>> checkTransactionPathAndBuild(List<SupportTransactionPathRpcParam> rpcParams) {
        log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84,\u53c2\u6570:{}", (Object)JSONObject.toJSONString(rpcParams));
        List data = (List)this.supportTransactionPathRpcService.queryListByParam(rpcParams).getData();
        log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84\u7ed3\u675f,\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)data));
        if (CollUtil.isEmpty((Collection)data)) {
            return new HashMap<String, List<SupportTransactionPathRpcDTO>>();
        }
        return data.stream().collect(Collectors.groupingBy(row -> row.getCompanyIdStart() + "@" + row.getCompanyIdEnd()));
    }

    private Map<String, InvWhRpcSimpleDTO> buildInvWhMap(List<String> demandWhCodes) {
        if (CollUtil.isEmpty(demandWhCodes)) {
            return new HashMap<String, InvWhRpcSimpleDTO>();
        }
        return this.rmiInvStkService.findInvWhBaseMapByCode(demandWhCodes);
    }

    private Map<String, OrgStoreBaseRpcDTO> getStoreInfoBy(List<String> demandStCodes) {
        log.info("\u6279\u91cf\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5165\u53c2{}", (Object)JSONUtil.toJsonStr(demandStCodes));
        List<OrgStoreBaseRpcDTO> resultList = this.rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandStCodes);
        log.info("\u6279\u91cf\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u7ed3\u679c{}", (Object)JSONUtil.toJsonStr(resultList));
        Map<String, OrgStoreBaseRpcDTO> resultMap = resultList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity()));
        log.info("\u6279\u91cf\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u7ed3\u679c\u5b57\u5178{}", (Object)JSONUtil.toJsonStr(resultMap));
        return resultMap;
    }

    private OuInfo getOuInfoFromPathCode(String fromWhCode, String toWhStCode, String type) {
        Long toOuId;
        String toOuCode;
        log.info("\u83b7\u53d6\u7ed3\u7b97\u8def\u5f84\u53c2\u6570,\u4ece\u4ed3\u5e93\u7f16\u7801:{},\u81f3\u4ed3\u5e93/\u95e8\u5e97\u7f16\u7801:{}", (Object)fromWhCode, (Object)toWhStCode);
        InvWhRpcSimpleDTO invWhMap = this.rmiInvStkService.findSimpleWhByCode(fromWhCode);
        Long fromOuId = invWhMap.getOuId();
        String fromOuCode = invWhMap.getOuCode();
        if ("1".equals(type)) {
            InvWhRpcSimpleDTO simpleDTO = this.rmiInvStkService.findSimpleWhByCode(toWhStCode);
            toOuCode = simpleDTO.getOuCode();
            toOuId = simpleDTO.getOuId();
        } else {
            OrgStoreBaseRpcDTO orgStore = this.getOuIdByStoreCode(toWhStCode);
            toOuCode = orgStore.getOuCode();
            toOuId = orgStore.getOuId();
        }
        log.info("fromOuId\u7684\u503c:{},toOuId\u7684\u503c:{}", (Object)fromOuId, (Object)toOuId);
        if (fromOuId == null || toOuId == null) {
            return null;
        }
        SupportTransactionPathRpcDTO pathCodeResult = this.getPathCodeResult(fromOuId, toOuId);
        if (pathCodeResult == null) {
            throw new BusinessException("\u4ece\u516c\u53f8\u3010" + fromOuCode + "\u3011\u81f3\u516c\u53f8\u3010" + toOuCode + "\u3011\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
        }
        log.info("\u83b7\u53d6\u5230\u7ed3\u7b97\u8def\u5f84\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)pathCodeResult));
        List detailList = pathCodeResult.getDetailList();
        int size = detailList.size();
        SupportTransactionPathDRpcDTO dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
        OuInfo ouInfo = new OuInfo();
        ouInfo.setOuCode(dto.getCompanyCodeStart());
        ouInfo.setOuName(dto.getCompanyNameStart());
        ouInfo.setOuId(dto.getCompanyIdStart());
        log.info("\u6839\u636e\u7ed3\u7b97\u8def\u5f84\u83b7\u53d6\u5230\u9500\u552e\u516c\u53f8\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)ouInfo));
        return ouInfo;
    }

    private OrgStoreBaseRpcDTO getOuIdByStoreCode(String storeCode) {
        Map<String, OrgStoreBaseRpcDTO> storeInfoBy = this.getStoreInfoBy(Arrays.asList(storeCode));
        if (!storeInfoBy.containsKey(storeCode)) {
            throw new BusinessException("\u95e8\u5e97\u7f16\u7801:" + storeCode + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        return storeInfoBy.get(storeCode);
    }

    private SupportTransactionPathRpcDTO getPathCodeResult(Long from, Long to) {
        log.info("\u67e5\u8be2\u7ed3\u7b97\u8def\u5f84\u53c2\u6570,from:{},to:{}", (Object)from, (Object)to);
        SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
        rpcParam.setCompanyIdStart(from);
        rpcParam.setCompanyIdEnd(to);
        SupportTransactionPathRpcDTO result = (SupportTransactionPathRpcDTO)this.supportTransactionPathRpcService.queryByParam(rpcParam).getData();
        log.info("\u67e5\u8be2\u7ed3\u7b97\u8def\u5f84\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)result));
        return result;
    }

    public String setEmptyStringStr(String str) {
        return str == null ? "" : str;
    }

    private List<ScpWhNetRelationResultVO.ResultVO> getResultVOS(List<ScpWhNetRelationSaveVO.ScpWhNetRelation> whNetRelations) {
        return whNetRelations.stream().map(w -> {
            ScpWhNetRelationResultVO.ResultVO resultVO = new ScpWhNetRelationResultVO.ResultVO();
            resultVO.setSupplyWhId(w.getId());
            resultVO.setSupplyWhCode(w.getSupplyWhCode());
            resultVO.setSupplyWhName(w.getSupplyWhName());
            resultVO.setDemandWhStCode(w.getDemandWhStCode());
            resultVO.setDemandWhStId(w.getDemandWhStId());
            resultVO.setDemandWhStName(w.getDemandWhStName());
            resultVO.setType(w.getType());
            resultVO.setItemCode(w.getItemCode());
            resultVO.setItemId(w.getItemId());
            resultVO.setItemName(w.getItemName());
            resultVO.setItemCateCode(w.getItemCateCode());
            if (StringUtils.isNotEmpty((String)w.getItemCateName())) {
                String itemCateName = w.getItemCateName().replace(",", ">");
                resultVO.setItemCateName(itemCateName);
            }
            resultVO.setSupplyPercentage(w.getSupplyPercentage());
            resultVO.setLineNo(w.getLineNo());
            return resultVO;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ScpWhNetRelationRespVO> findWhNetList(ScpWhNetRelationBaseParamVO param) {
        List<ScpWhNetRelationDO> relationDOS = this.scpWhNetRelationDomainService.findByBusinessKey(param.getDemandWhStCode(), param.getDeliveryType(), param.getItemCateCode(), param.getItemCode());
        List<ScpWhNetRelationRespVO> relationRespVOList = relationDOS.stream().map(ScpWhNetRelationConvert.INSTANCE::doToRespVO).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(relationRespVOList)) {
            Map typeMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", Set.of("DEMAND_SET_TYPE"));
            Map itemType2 = this.udcProvider.getValueMapByUdcCode("yst-supp", "ITEM_TYPE2");
            relationRespVOList.forEach(d -> {
                d.setTypeName((String)((Map)typeMap.getOrDefault("DEMAND_SET_TYPE", new HashMap())).get(d.getType()));
                if (StringUtils.isNotEmpty((String)d.getItemCateCode())) {
                    List itemCatePath = this.itmItemRpcService.findItemCatePath(d.getItemCateCode());
                    d.setItemCatePath(itemCatePath);
                }
                if (StringUtils.isNotEmpty((String)d.getDeliveryType()) && itemType2 != null) {
                    d.setDeliveryTypeName((String)itemType2.get(d.getDeliveryType()));
                }
            });
        }
        return relationRespVOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteWhNetRelation(List<Long> ids) {
        this.scpWhNetRelationDomainService.deleteBatch(ids);
    }

    @Override
    public List<ScpWhNetRelationRpcDTO> findWhNetRelationRpcDtoByParam(ScpWhNetRelationRpcDtoParam queryParam) {
        if (StringUtils.isNotEmpty((String)queryParam.getItemCode()) && StringUtils.isEmpty((String)queryParam.getItemCateCode())) {
            ItmItemBaseRpcParam itemRpcDtoParam = new ItmItemBaseRpcParam();
            itemRpcDtoParam.setItemCodes(List.of(queryParam.getItemCode()));
            List itemRpcDtoByParam = this.itmItemRpcService.findItemBaseRpcDtoByParam(itemRpcDtoParam);
            queryParam.setItemCateCode(((ItmItemBaseRpcDTO)itemRpcDtoByParam.get(0)).getItemCateCode());
        }
        log.info("ScpWhNetRelationRpcDtoParam:{} ", (Object)JSON.toJSONString((Object)queryParam));
        List<ScpWhNetRelationRpcDTO> relationRpcDTOS = this.scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(queryParam);
        if (CollUtil.isEmpty(relationRpcDTOS)) {
            return new ArrayList<ScpWhNetRelationRpcDTO>();
        }
        return relationRpcDTOS;
    }

    @Override
    public PagingVO<ScpWhNetRelationExportRespVO> exportSearch(ScpWhNetRelationPageParamVO queryParam) {
        if (Boolean.TRUE.equals(queryParam.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> pagingVO = this.getAuthorityPageRespVOPagingVO();
            if (pagingVO.isEmpty()) {
                return new PagingVO();
            }
            this.extractedAuthorityParam(queryParam, pagingVO);
        }
        return this.scpWhNetRelationDomainService.exportSearch(queryParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> executeImport(List<ScpWhNetRelationImportVO> dataList, int startRowIndex) {
        List simpleOuDto1;
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<String> errorList = new ArrayList<String>();
        this.checkImportParam(dataList, errorList);
        List<String> result = this.validResult(errorList);
        List<Integer> successDocGroup = this.getSuccessDocGroup(result, dataList);
        if (successDocGroup.isEmpty()) {
            return result;
        }
        List whCodeList = dataList.stream().map(ScpWhNetRelationImportVO::getSupplyWhCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        InvWhRpcDtoParam whRpcDtoParam = new InvWhRpcDtoParam();
        whRpcDtoParam.setWhCodes(whCodeList);
        ApiResult whList = this.whProvider.findWhDTOByParam(whRpcDtoParam);
        Map<Object, Object> whMap = whList.isSuccess() && whList.getData() != null ? ((List)whList.getData()).stream().collect(Collectors.toMap(InvWhRpcDTO::getWhCode, i -> i, (o, n) -> n)) : new HashMap();
        Map<Object, Object> storeMap = new HashMap();
        List storeCodes = dataList.stream().filter(d -> UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(d.getType())).map(ScpWhNetRelationImportVO::getDemandWhStCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(storeCodes)) {
            OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
            orgStoreBaseRpcParam.setStoreCodeList(storeCodes);
            List storeList = (List)this.orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam).getData();
            if (storeList != null) {
                storeMap = storeList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, i -> i, (o, n) -> n));
            }
        }
        List demandWhCodes = dataList.stream().filter(d -> UdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(d.getType())).map(ScpWhNetRelationImportVO::getDemandWhStCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> demandWhMap = new HashMap();
        if (CollUtil.isNotEmpty(demandWhCodes)) {
            InvWhRpcDtoParam whRpcDtoParam2 = new InvWhRpcDtoParam();
            whRpcDtoParam2.setWhCodes(demandWhCodes);
            ApiResult demandWhList = this.whProvider.findWhDTOByParam(whRpcDtoParam2);
            if (demandWhList.isSuccess() && demandWhList.getData() != null) {
                demandWhMap = ((List)demandWhList.getData()).stream().collect(Collectors.toMap(InvWhRpcDTO::getWhCode, i -> i, (o, n) -> n));
            }
        }
        List ouCodes = dataList.stream().flatMap(importVO -> Stream.of(importVO.getSaleOuCode(), importVO.getPurOuCode())).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> ouMap = new HashMap();
        if (CollUtil.isNotEmpty(ouCodes) && CollUtil.isNotEmpty((Collection)(simpleOuDto1 = this.orgOuRpcService.findSimpleByOuCodes(ouCodes)))) {
            ouMap = simpleOuDto1.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, i -> i, (o, n) -> n));
        }
        List itemCodes = dataList.stream().map(ScpWhNetRelationImportVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> itemMap = new HashMap();
        if (CollUtil.isNotEmpty(itemCodes)) {
            ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
            itemRpcDtoParam.setItemCodes(itemCodes);
            List itemRpcDtoByParam = this.itmItemRpcService.findItemRpcDtoByParam(itemRpcDtoParam);
            itemMap = itemRpcDtoByParam.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, i -> i, (o, e) -> e));
        }
        HashMap errorMap = new HashMap();
        ArrayList<ScpWhNetRelationDTO> scpWhNetRelationDTOS = new ArrayList<ScpWhNetRelationDTO>();
        for (ScpWhNetRelationImportVO importEntity : dataList) {
            OrgOuRpcSimpleDTO ouDTO;
            if (!successDocGroup.contains(importEntity.getLineNo())) continue;
            errorMap.put(importEntity.getLineNo(), new ArrayList());
            ScpWhNetRelationDTO scpWhNetRelationDTO = new ScpWhNetRelationDTO();
            scpWhNetRelationDTO.setType(importEntity.getType());
            scpWhNetRelationDTO.setSupplyWhCode(importEntity.getSupplyWhCode());
            InvWhRpcDTO supplyWhRpcDTO = (InvWhRpcDTO)whMap.get(importEntity.getSupplyWhCode());
            if (supplyWhRpcDTO == null) {
                ((List)errorMap.get(importEntity.getLineNo())).add("\u4f9b\u5e94\u4ed3\u5e93\u7f16\u7801" + importEntity.getSupplyWhCode() + " \u4e0d\u5b58\u5728");
            } else {
                scpWhNetRelationDTO.setSupplyWhId(supplyWhRpcDTO.getId());
                scpWhNetRelationDTO.setSupplyWhName(supplyWhRpcDTO.getWhName());
            }
            if (UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(importEntity.getType())) {
                OrgStoreBaseRpcDTO storeDetailRpcDTO = (OrgStoreBaseRpcDTO)storeMap.get(importEntity.getDemandWhStCode());
                if (storeDetailRpcDTO == null) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u9700\u6c42\u4ed3\u5e93\u7f16\u7801/\u95e8\u5e97\u7f16\u7801" + importEntity.getDemandWhStCode() + " \u4e0d\u5b58\u5728");
                } else {
                    scpWhNetRelationDTO.setDemandWhStId(storeDetailRpcDTO.getId());
                    scpWhNetRelationDTO.setDemandWhStCode(importEntity.getDemandWhStCode());
                    scpWhNetRelationDTO.setDemandWhStName(storeDetailRpcDTO.getStoreName());
                }
                if (storeDetailRpcDTO != null && supplyWhRpcDTO != null && !Objects.equals(storeDetailRpcDTO.getOuId(), supplyWhRpcDTO.getOuId())) {
                    pathRpcParam = new SupportTransactionPathRpcParam();
                    pathRpcParam.setCompanyIdStart(supplyWhRpcDTO.getOuId());
                    pathRpcParam.setCompanyIdEnd(storeDetailRpcDTO.getOuId());
                    data = (SupportTransactionPathRpcDTO)this.supportTransactionPathRpcService.queryByParam(pathRpcParam).getData();
                    log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84\u7ed3\u675f,\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)data));
                    if (data == null || StrUtil.isBlank((CharSequence)data.getPathCode())) {
                        log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)supplyWhRpcDTO.getOuId(), (Object)storeDetailRpcDTO.getOuId());
                        ((List)errorMap.get(importEntity.getLineNo())).add("\u4ece\u516c\u53f8:" + supplyWhRpcDTO.getOuCode() + "\u5230\u516c\u53f8:" + storeDetailRpcDTO.getOuCode() + "\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
                    }
                    if (data != null) {
                        detailList = data.getDetailList();
                        size = detailList.size();
                        dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
                        scpWhNetRelationDTO.setCustCode(dto.getCompanyCodeStart());
                        scpWhNetRelationDTO.setOuCode(dto.getCompanyCodeStart());
                        scpWhNetRelationDTO.setOuName(dto.getCompanyNameStart());
                        scpWhNetRelationDTO.setCustCode(dto.getCustCodeEnd());
                    }
                }
            } else {
                InvWhRpcDTO demandWhDto = (InvWhRpcDTO)demandWhMap.get(importEntity.getDemandWhStCode());
                if (demandWhDto == null) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u9700\u6c42\u4ed3\u5e93\u7f16\u7801/\u95e8\u5e97\u7f16\u7801" + importEntity.getDemandWhStCode() + " \u4e0d\u5b58\u5728");
                } else {
                    scpWhNetRelationDTO.setDemandWhStId(demandWhDto.getId());
                    scpWhNetRelationDTO.setDemandWhStCode(importEntity.getDemandWhStCode());
                    scpWhNetRelationDTO.setDemandWhStName(demandWhDto.getWhName());
                }
                if (demandWhDto != null && supplyWhRpcDTO != null && !Objects.equals(demandWhDto.getOuId(), supplyWhRpcDTO.getOuId())) {
                    pathRpcParam = new SupportTransactionPathRpcParam();
                    pathRpcParam.setCompanyIdStart(supplyWhRpcDTO.getOuId());
                    pathRpcParam.setCompanyIdEnd(demandWhDto.getOuId());
                    data = (SupportTransactionPathRpcDTO)this.supportTransactionPathRpcService.queryByParam(pathRpcParam).getData();
                    log.info("\u67e5\u8be2\u542f\u7528\u72b6\u6001\u7684\u7ed3\u7b97\u8def\u5f84\u7ed3\u675f,\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)data));
                    if (data == null || StrUtil.isBlank((CharSequence)data.getPathCode())) {
                        log.info("\u4ece\u516c\u53f8 {}\u5230\u516c\u53f8 {}\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4", (Object)supplyWhRpcDTO.getOuId(), (Object)demandWhDto.getOuId());
                        ((List)errorMap.get(importEntity.getLineNo())).add("\u4ece\u516c\u53f8:" + supplyWhRpcDTO.getOuCode() + "\u5230\u516c\u53f8:" + demandWhDto.getOuCode() + "\u7684\u7ed3\u7b97\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
                    }
                    if (data != null) {
                        detailList = data.getDetailList();
                        size = detailList.size();
                        dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
                        scpWhNetRelationDTO.setCustCode(dto.getCompanyCodeStart());
                        scpWhNetRelationDTO.setOuCode(dto.getCompanyCodeStart());
                        scpWhNetRelationDTO.setOuName(dto.getCompanyNameStart());
                        scpWhNetRelationDTO.setCustCode(dto.getCustCodeEnd());
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)importEntity.getPurOuCode())) {
                ouDTO = (OrgOuRpcSimpleDTO)ouMap.get(importEntity.getPurOuCode());
                if (ouDTO == null) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u91c7\u8d2d\u516c\u53f8" + importEntity.getPurOuCode() + " \u4e0d\u5b58\u5728");
                } else {
                    scpWhNetRelationDTO.setPurCompanyCode(importEntity.getPurOuCode());
                    scpWhNetRelationDTO.setPurCompanyName(ouDTO.getOuName());
                }
            } else if (ScpConstant.PUR_TRN_DELIVERY_TYPES.contains(importEntity.getDeliveryType())) {
                ((List)errorMap.get(importEntity.getLineNo())).add("\u91c7\u8d2d\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotEmpty((String)importEntity.getSaleOuCode())) {
                ouDTO = (OrgOuRpcSimpleDTO)ouMap.get(importEntity.getSaleOuCode());
                if (ouDTO == null) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u9500\u552e\u516c\u53f8" + importEntity.getSaleOuCode() + " \u4e0d\u5b58\u5728");
                } else {
                    scpWhNetRelationDTO.setOuCode(importEntity.getSaleOuCode());
                    scpWhNetRelationDTO.setOuName(ouDTO.getOuName());
                }
            }
            if (StringUtils.isNotEmpty((String)importEntity.getItemCode())) {
                ItmItemRpcDTO itmItemRpcDTO = (ItmItemRpcDTO)itemMap.get(importEntity.getItemCode());
                if (itmItemRpcDTO == null) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u5546\u54c1\u7f16\u7801" + importEntity.getItemCode() + " \u4e0d\u5b58\u5728");
                } else {
                    scpWhNetRelationDTO.setItemCode(importEntity.getItemCode());
                    scpWhNetRelationDTO.setItemId(itmItemRpcDTO.getId());
                    scpWhNetRelationDTO.setItemName(itmItemRpcDTO.getItemName());
                }
            }
            scpWhNetRelationDTO.setSupplyPercentage(new BigDecimal("100"));
            scpWhNetRelationDTO.setStatus(Boolean.TRUE);
            scpWhNetRelationDTO.setLineNo(importEntity.getLineNo());
            scpWhNetRelationDTO.setDeliveryType(importEntity.getDeliveryType());
            scpWhNetRelationDTO.setStartTime(importEntity.getStartTime());
            scpWhNetRelationDTO.setEndTime(importEntity.getEndTime());
            scpWhNetRelationDTOS.add(scpWhNetRelationDTO);
        }
        for (Object line : errorMap.keySet()) {
            if (((List)errorMap.get(line)).isEmpty()) continue;
            if (Objects.equals(errorList.get((Integer)line - 1), "-")) {
                errorList.set((Integer)line - 1, String.join((CharSequence)",", (Iterable)errorMap.get(line)));
                continue;
            }
            errorList.set((Integer)line - 1, (String)errorList.get((Integer)line - 1) + String.join((CharSequence)",", (Iterable)errorMap.get(line)));
        }
        successDocGroup = this.getSuccessDocGroup(errorList, dataList);
        ArrayList<ScpWhNetRelationDTO> ddos = new ArrayList<ScpWhNetRelationDTO>();
        if (!successDocGroup.isEmpty()) {
            for (ScpWhNetRelationDTO scpWhNetRelationDTO : scpWhNetRelationDTOS) {
                if (!successDocGroup.contains(scpWhNetRelationDTO.getLineNo())) continue;
                ddos.add(scpWhNetRelationDTO);
            }
            List<ScpWhNetRelationDO> oldList = this.scpWhNetRelationDomainService.findByConcatKey(ddos.stream().map(ScpWhNetRelationDTO::getConcatKey).collect(Collectors.toSet()));
            Map oldMap = oldList.stream().collect(Collectors.toMap(v -> this.setEmptyStringStr(v.getDemandWhStName()) + this.setEmptyStringStr(v.getDeliveryType()) + this.setEmptyStringStr(v.getItemCateCode()) + this.setEmptyStringStr(v.getItemCode()), Function.identity(), (t1, t2) -> t1));
            ArrayList<ScpWhNetRelationDO> saveList = new ArrayList<ScpWhNetRelationDO>();
            for (ScpWhNetRelationDTO ddo : ddos) {
                ScpWhNetRelationDO old = (ScpWhNetRelationDO)oldMap.get(ddo.getConcatKey());
                if (old != null) {
                    old.setSupplyWhId(ddo.getSupplyWhId());
                    old.setSupplyWhCode(ddo.getSupplyWhCode());
                    old.setSupplyWhName(ddo.getSupplyWhName());
                    old.setType(ddo.getType());
                    old.setDemandWhStId(ddo.getDemandWhStId());
                    old.setDemandWhStCode(ddo.getDemandWhStCode());
                    old.setDemandWhStName(ddo.getDemandWhStName());
                    old.setItemId(ddo.getItemId());
                    old.setItemCode(ddo.getItemCode());
                    old.setItemName(ddo.getItemName());
                    old.setSupplyPercentage(ddo.getSupplyPercentage());
                    old.setStartTime(ddo.getStartTime());
                    old.setEndTime(ddo.getEndTime());
                    old.setStatus(ddo.getStatus());
                    old.setOuCode(ddo.getOuCode());
                    old.setOuName(ddo.getOuName());
                    old.setDeliveryType(ddo.getDeliveryType());
                    old.setPurCompanyCode(ddo.getPurCompanyCode());
                    old.setPurCompanyName(ddo.getPurCompanyName());
                    continue;
                }
                ScpWhNetRelationDO scpWhNetRelationDO = ScpWhNetRelationConvert.INSTANCE.dtoToDo(ddo);
                saveList.add(scpWhNetRelationDO);
            }
            if (CollUtil.isNotEmpty(saveList)) {
                this.scpWhNetRelationRepo.saveAll(saveList);
            }
        }
        ArrayList<String> newResult = new ArrayList<String>();
        for (int i2 = 0; i2 < errorList.size(); ++i2) {
            String error = (String)errorList.get(i2);
            Integer importDocGroup = dataList.get(i2).getLineNo();
            if (!successDocGroup.contains(importDocGroup)) {
                if (Objects.equals(error, "-")) {
                    newResult.add("-");
                    continue;
                }
                newResult.add(error);
                continue;
            }
            newResult.add(null);
        }
        return newResult;
    }

    @Override
    public PagingVO<ScpWhNetRelationPageVO> scpmanAuthorityPage(ScpWhNetRelationPageParamVO queryParam) {
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.getAuthorityPageRespVOPagingVO();
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return new PagingVO();
        }
        this.extractedAuthorityParam(queryParam, scpManAuthorityPageRespVOPagingVO);
        return this.page(queryParam);
    }

    @Override
    public Map<String, List<ScpWhNetRelationRpcDTO>> findWhNetByParam(String demandWhStCode, String type, List<ScpStoreCartDO> storeCartDOS) {
        HashMap<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap = new HashMap<String, List<ScpWhNetRelationRpcDTO>>();
        ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam = new ScpWhNetRelationRpcDtoParam();
        scpWhNetRelationRpcDtoParam.setType(type);
        scpWhNetRelationRpcDtoParam.setDemandWhStCode(demandWhStCode);
        scpWhNetRelationRpcDtoParam.setValidDate(LocalDateTime.now());
        List<ScpWhNetRelationRpcDTO> relationList = this.scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(scpWhNetRelationRpcDtoParam);
        for (ScpStoreCartDO cartDO : storeCartDOS) {
            List itemCodeResults = relationList.stream().filter(row -> Objects.equals(cartDO.getItemCode(), row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCodeResults)) {
                whNetRelationMap.put(cartDO.getItemCode(), itemCodeResults);
                continue;
            }
            List itemCateCodeResults = relationList.stream().filter(row -> Objects.equals(cartDO.getItemCateCode(), row.getItemCateCode()) && StrUtil.isBlank((CharSequence)row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCateCodeResults)) {
                whNetRelationMap.put(cartDO.getItemCode(), itemCateCodeResults);
                continue;
            }
            List deliveryTypeResult = relationList.stream().filter(row -> StrUtil.isBlank((CharSequence)row.getItemCateCode()) && StrUtil.isBlank((CharSequence)row.getItemCode()) && Objects.equals(cartDO.getDeliveryType(), row.getDeliveryType())).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(deliveryTypeResult)) continue;
            whNetRelationMap.put(cartDO.getItemCode(), deliveryTypeResult);
        }
        return whNetRelationMap;
    }

    @Override
    public Map<String, List<ScpWhNetRelationRpcDTO>> findNewWhNetByParam(String demandWhStCode, String type, List<ScpStoreCartDO> storeCartDOS) {
        HashMap<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap = new HashMap<String, List<ScpWhNetRelationRpcDTO>>();
        ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam = new ScpWhNetRelationRpcDtoParam();
        scpWhNetRelationRpcDtoParam.setType(type);
        scpWhNetRelationRpcDtoParam.setDemandWhStCode(demandWhStCode);
        scpWhNetRelationRpcDtoParam.setValidDate(LocalDateTime.now());
        List<ScpWhNetRelationRpcDTO> relationList = this.scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(scpWhNetRelationRpcDtoParam);
        log.info("\u4ed3\u7f51\u5173\u7cfbrelationList:{}", relationList);
        for (ScpStoreCartDO cartDO : storeCartDOS) {
            List itemCodeResults = relationList.stream().filter(row -> cartDO.getItemCode().equals(row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCodeResults)) {
                if (itemCodeResults.size() > 1) {
                    itemCodeResults = itemCodeResults.subList(0, 1);
                }
                whNetRelationMap.put(cartDO.getItemCode(), itemCodeResults);
                continue;
            }
            List resultList = relationList.stream().filter(row -> StringUtils.isBlank((String)row.getItemCode()) && Objects.equals(cartDO.getItemType2(), row.getDeliveryType())).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(resultList)) continue;
            if (resultList.size() > 1) {
                resultList = resultList.subList(0, 1);
            }
            whNetRelationMap.put(cartDO.getItemCode(), resultList);
        }
        return whNetRelationMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return;
        }
        this.scpWhNetRelationDomainService.deleteBatch(ids);
    }

    @Override
    public List<String> findSaleOuInfo(String storeCode) {
        return this.scpWhNetRelationRepoProc.findSaleOuInfo(storeCode);
    }

    @Override
    public List<ScpWhNetRelationRespVO> findValidWhNetRelationByParam(List<Long> itemIds, String storeCode, LocalDateTime dateTime) {
        return this.scpWhNetRelationRepoProc.findValidWhNetRelationByParam(itemIds, storeCode, dateTime);
    }

    @Override
    public List<ScpWhNetRelationRespVO> findValidWhNetRelationByParam2(String itemType, String storeCode, LocalDateTime dateTime) {
        return this.scpWhNetRelationRepoProc.findValidWhNetRelationByParam2(itemType, storeCode, dateTime);
    }

    @Override
    public List<ScpWhNetRelationRpcDTO> outFindWhNetRelationRpcDtoByParam(ScpWhNetRelationParam whNetRelationParam) {
        log.info("outFindWhNetRelationRpcDtoByParam:{} ", (Object)JSON.toJSONString((Object)whNetRelationParam));
        List<ScpWhNetRelationRpcDTO> relationRpcDTOS = this.scpWhNetRelationRepoProc.outFindWhNetRelationRpcDtoByParam(whNetRelationParam);
        if (CollUtil.isEmpty(relationRpcDTOS)) {
            return new ArrayList<ScpWhNetRelationRpcDTO>();
        }
        return relationRpcDTOS;
    }

    private void extractedAuthorityParam(ScpWhNetRelationPageParamVO queryParam, PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO) {
        List records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List<Long> whIds = records.stream().filter(v -> 1 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> storeIds = records.stream().filter(v -> 0 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhId).filter(Objects::nonNull).collect(Collectors.toList());
        queryParam.setWhIds(whIds);
        queryParam.setStoreIds(storeIds);
    }

    private PagingVO<ScpManAuthorityPageRespVO> getAuthorityPageRespVOPagingVO() {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setTypes(List.of(Integer.valueOf(1), Integer.valueOf(0)));
        scpManAuthorityParam.setEnableStatus(Boolean.TRUE);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        return scpManAuthorityPageRespVOPagingVO;
    }

    private List<String> validResult(List<String> errorList) {
        errorList.replaceAll(new UnaryOperator<String>(){

            @Override
            public String apply(String s) {
                if (StringUtils.isEmpty((String)s)) {
                    return "-";
                }
                return s;
            }
        });
        return errorList;
    }

    private List<Integer> getSuccessDocGroup(List<String> errorList, List<ScpWhNetRelationImportVO> dataList) {
        List<Integer> docGroupNo = dataList.stream().map(ScpWhNetRelationImportVO::getLineNo).distinct().collect(Collectors.toList());
        for (int i = 0; i < dataList.size(); ++i) {
            ScpWhNetRelationImportVO entity = dataList.get(i);
            if (Objects.equals("-", errorList.get(i))) continue;
            docGroupNo.remove(entity.getLineNo());
        }
        return docGroupNo;
    }

    private void checkImportParam(List<ScpWhNetRelationImportVO> dataList, List<String> errorList) {
        HashMap errorMap = new HashMap();
        Map typeMap = MapUtil.reverse((Map)this.systemService.getValueMapByUdcCode("yst-suplan", "DEMAND_SET_TYPE"));
        Map deliveryTypeMap = MapUtil.reverse((Map)this.systemService.getValueMapByUdcCode("yst-supp", "ITEM_TYPE2"));
        HashMap<CallSite, Integer> dumpMap = new HashMap<CallSite, Integer>();
        for (int i = 0; i < dataList.size(); ++i) {
            ScpWhNetRelationImportVO importEntity = dataList.get(i);
            int line = i + 1;
            importEntity.setLineNo(line);
            errorMap.put(importEntity.getLineNo(), new ArrayList());
            if (StringUtils.isEmpty((String)importEntity.getTypeName())) {
                ((List)errorMap.get(line)).add("\u5217[\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                String lineType = (String)typeMap.get(importEntity.getTypeName());
                if (StringUtils.isEmpty((String)lineType)) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u5217[\u7c7b\u578b\u540d]" + importEntity.getTypeName() + " \u4e0d\u5b58\u5728");
                } else {
                    importEntity.setType(lineType);
                }
            }
            if (StringUtils.isEmpty((String)importEntity.getDeliveryTypeName())) {
                ((List)errorMap.get(line)).add("\u5217[\u914d\u9001\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                String code = (String)deliveryTypeMap.get(importEntity.getDeliveryTypeName());
                if (StringUtils.isEmpty((String)code)) {
                    ((List)errorMap.get(importEntity.getLineNo())).add("\u5217[\u914d\u9001\u7c7b\u578b]" + importEntity.getDeliveryTypeName() + " \u4e0d\u5b58\u5728");
                } else {
                    importEntity.setDeliveryType(code);
                }
            }
            if (StringUtils.isEmpty((String)importEntity.getDemandWhStCode())) {
                ((List)errorMap.get(line)).add("\u5217[\u9700\u6c42\u4ed3\u5e93/\u95e8\u5e97\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)importEntity.getSupplyWhCode())) {
                ((List)errorMap.get(line)).add("\u5217[\u4f9b\u5e94\u4ed3\u5e93\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)importEntity.getStartTimeStr())) {
                ((List)errorMap.get(line)).add("\u5217[\u6709\u6548\u65e5\u671f\u4ece]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)importEntity.getEndTimeStr())) {
                ((List)errorMap.get(line)).add("\u5217[\u6709\u6548\u65e5\u671f\u81f3]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotEmpty((String)importEntity.getStartTimeStr()) && StringUtils.isNotEmpty((String)importEntity.getEndTimeStr())) {
                LocalDateTime startTime = null;
                try {
                    LocalDate date = LocalDate.parse(importEntity.getStartTimeStr());
                    startTime = date.atStartOfDay();
                }
                catch (Exception e) {
                    ((List)errorMap.get(line)).add("\u5217[\u6709\u6548\u65e5\u671f\u81f3]\u683c\u5f0f\u9519\u8bef");
                }
                LocalDateTime endTime = null;
                if (importEntity.getEndTimeStr().equals("\u957f\u671f\u6709\u6548")) {
                    endTime = LocalDateTime.of(9999, 12, 31, 23, 59, 59);
                } else {
                    try {
                        LocalDate date = LocalDate.parse(importEntity.getEndTimeStr());
                        endTime = date.atTime(23, 59, 59);
                    }
                    catch (Exception e) {
                        ((List)errorMap.get(line)).add("\u5217[\u6709\u6548\u65e5\u671f\u81f3]\u683c\u5f0f\u9519\u8bef");
                    }
                }
                if (startTime != null && endTime != null) {
                    if (startTime.isAfter(endTime)) {
                        ((List)errorMap.get(line)).add("\u5217[\u6709\u6548\u65e5\u671f\u4ece]\u4e0d\u80fd\u5927\u4e8e[\u6709\u6548\u65e5\u671f\u81f3]");
                    } else {
                        importEntity.setStartTime(startTime);
                        importEntity.setEndTime(endTime);
                    }
                }
            }
            if (!StringUtils.isNotEmpty((String)importEntity.getDemandWhStCode()) || !StringUtils.isNotEmpty((String)importEntity.getDeliveryType())) continue;
            String key = importEntity.getDeliveryType() + importEntity.getDemandWhStCode() + this.setEmptyStringStr(importEntity.getItemCode());
            if (dumpMap.get(key) == null) {
                dumpMap.put((CallSite)((Object)key), line);
                continue;
            }
            ((List)errorMap.get(line)).add("\u7b2c " + importEntity.getLineNo() + "\u884c\uff0c\u6570\u636e\u91cd\u590d\uff0c\u914d\u9001\u7c7b\u578b-\u95e8\u5e97\u7f16\u7801-\u5546\u54c1 \u5b58\u5728\u76f8\u540c\u7ec4\u5408\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        for (Integer line : errorMap.keySet()) {
            errorList.add(String.join((CharSequence)",", (Iterable)errorMap.get(line)));
        }
    }

    public ScpWhNetRelationServiceImpl(ScpWhNetRelationDomainService scpWhNetRelationDomainService, ScpWhNetRelationRepo scpWhNetRelationRepo, ItmItemRpcService itmItemRpcService, UdcProvider udcProvider, ScpWhNetRelationRepoProc scpWhNetRelationRepoProc, UdcProvider systemService, InvWhProvider whProvider, OrgStoreRpcService orgStoreRpcService, ScpDemandAuthorityService scpDemandAuthorityService, RmiInvStkRpcService rmiInvStkService, SupportTransactionPathRpcService supportTransactionPathRpcService, RmiOrgStoreRpcService rmiOrgStoreRpcService, OrgOuRpcService orgOuRpcService) {
        this.scpWhNetRelationDomainService = scpWhNetRelationDomainService;
        this.scpWhNetRelationRepo = scpWhNetRelationRepo;
        this.itmItemRpcService = itmItemRpcService;
        this.udcProvider = udcProvider;
        this.scpWhNetRelationRepoProc = scpWhNetRelationRepoProc;
        this.systemService = systemService;
        this.whProvider = whProvider;
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.rmiInvStkService = rmiInvStkService;
        this.supportTransactionPathRpcService = supportTransactionPathRpcService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.orgOuRpcService = orgOuRpcService;
    }
}

