/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.survey;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.domain.entity.survey.QSurveyAnswerDO;
import com.elitesland.scp.domain.entity.survey.QSurveyDO;
import com.elitesland.scp.domain.entity.survey.QSurveyOptionDO;
import com.elitesland.scp.domain.entity.survey.QSurveyPublishDO;
import com.elitesland.scp.domain.entity.survey.QSurveyQuestionDO;
import com.elitesland.scp.domain.entity.survey.SurveyDO;
import com.elitesland.scp.domain.vo.survey.SurveyAnswerParam;
import com.elitesland.scp.domain.vo.survey.SurveyAnswerRespVO;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class SurveyAnswerRepoProc
extends BaseRepoProc<SurveyDO> {
    private static final QSurveyDO surveyDO = QSurveyDO.surveyDO;
    private static final QSurveyPublishDO surveyPublishDO = QSurveyPublishDO.surveyPublishDO;
    private static final QSurveyAnswerDO surveyAnswerDO = QSurveyAnswerDO.surveyAnswerDO;
    private static final QSurveyQuestionDO surveyQuestionDO = QSurveyQuestionDO.surveyQuestionDO;
    private static final QSurveyOptionDO surveyOptionDO = QSurveyOptionDO.surveyOptionDO;

    protected SurveyAnswerRepoProc() {
        super((EntityPathBase)surveyDO);
    }

    public static StringTemplate DATE_FORMAT(Object arg1) {
        return Expressions.stringTemplate((String)"DATE_FORMAT({0}, '%Y-%m-%d %H:%i:%s')", (Object[])new Object[]{arg1});
    }

    public static StringTemplate concat(Object arg1, Object arg2) {
        return Expressions.stringTemplate((String)"concat({0}, {0})", (Object[])new Object[]{arg1, arg2});
    }

    public PagingVO<SurveyAnswerRespVO> search(SurveyPagingParam queryVO) {
        JPAQuery jpaCountQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Expressions.numberTemplate(Long.class, (String)"count(distinct concat({0}, {1}))", (Object[])new Object[]{SurveyAnswerRepoProc.surveyAnswerDO.suvId, SurveyAnswerRepoProc.surveyAnswerDO.ouCode})).from((EntityPath)surveyAnswerDO)).where(this.where(queryVO));
        long count = (Long)jpaCountQuery.fetchOne();
        if (count <= 0L) {
            return PagingVO.builder().total(count).records(new ArrayList()).build();
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(SurveyAnswerRespVO.class, (Expression[])new Expression[]{SurveyAnswerRepoProc.surveyAnswerDO.suvId, SurveyAnswerRepoProc.DATE_FORMAT(SurveyAnswerRepoProc.surveyAnswerDO.createTime).as("fillTimeStr"), SurveyAnswerRepoProc.surveyAnswerDO.creator, SurveyAnswerRepoProc.surveyAnswerDO.ouCode, SurveyAnswerRepoProc.surveyAnswerDO.username, SurveyAnswerRepoProc.surveyPublishDO.ouId, SurveyAnswerRepoProc.surveyPublishDO.ouName})).from((EntityPath)surveyAnswerDO)).leftJoin((EntityPath)surveyPublishDO)).on((Predicate)SurveyAnswerRepoProc.surveyAnswerDO.suvId.eq(SurveyAnswerRepoProc.surveyPublishDO.suvId).and((Predicate)SurveyAnswerRepoProc.surveyPublishDO.ouCode.eq((Expression)SurveyAnswerRepoProc.surveyAnswerDO.ouCode)))).where(this.where(queryVO))).orderBy(SurveyAnswerRepoProc.DATE_FORMAT(SurveyAnswerRepoProc.surveyAnswerDO.createTime).desc());
        queryVO.setPaging(jpaQuery);
        return PagingVO.builder().total(count).records(jpaQuery.fetch()).build();
    }

    private Predicate where(SurveyPagingParam param) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (param.getSuvId() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyAnswerRepoProc.surveyAnswerDO.suvId.eq((Object)param.getSuvId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getUsername())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyAnswerRepoProc.surveyAnswerDO.username.eq((Object)param.getUsername()));
        }
        return predicate;
    }

    public List<SurveyAnswerRespVO> findAnswer(SurveyAnswerParam queryVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SurveyAnswerRespVO.class, (Expression[])new Expression[]{SurveyAnswerRepoProc.surveyAnswerDO.id, SurveyAnswerRepoProc.surveyAnswerDO.suvId, SurveyAnswerRepoProc.surveyAnswerDO.qusId, SurveyAnswerRepoProc.surveyAnswerDO.ouCode, SurveyAnswerRepoProc.surveyAnswerDO.userId, SurveyAnswerRepoProc.surveyAnswerDO.username, SurveyAnswerRepoProc.surveyAnswerDO.createTime, SurveyAnswerRepoProc.surveyQuestionDO.qusType, SurveyAnswerRepoProc.surveyQuestionDO.qusTitle, SurveyAnswerRepoProc.surveyQuestionDO.sortNo, SurveyAnswerRepoProc.surveyAnswerDO.optId, SurveyAnswerRepoProc.surveyAnswerDO.optContent, SurveyAnswerRepoProc.surveyOptionDO.sortNo.as("opSortNo"), SurveyAnswerRepoProc.surveyOptionDO.opContent, SurveyAnswerRepoProc.surveyPublishDO.ouName})).from((EntityPath)surveyAnswerDO)).leftJoin((EntityPath)surveyQuestionDO)).on((Predicate)SurveyAnswerRepoProc.surveyAnswerDO.qusId.eq(SurveyAnswerRepoProc.surveyQuestionDO.id))).leftJoin((EntityPath)surveyOptionDO)).on((Predicate)SurveyAnswerRepoProc.surveyAnswerDO.optId.eq(SurveyAnswerRepoProc.surveyOptionDO.id))).leftJoin((EntityPath)surveyPublishDO)).on((Predicate)SurveyAnswerRepoProc.surveyAnswerDO.suvId.eq(SurveyAnswerRepoProc.surveyPublishDO.suvId).and((Predicate)SurveyAnswerRepoProc.surveyPublishDO.ouCode.eq((Expression)SurveyAnswerRepoProc.surveyAnswerDO.ouCode)))).where(this.whereAnswer(queryVO))).orderBy(SurveyAnswerRepoProc.surveyQuestionDO.sortNo.asc());
        return jpaQuery.fetch();
    }

    private Predicate whereAnswer(SurveyAnswerParam param) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (param.getSuvId() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyAnswerRepoProc.surveyAnswerDO.suvId.eq((Object)param.getSuvId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getCreator())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyAnswerRepoProc.surveyAnswerDO.creator.eq((Object)param.getCreator()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getUsername())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyAnswerRepoProc.surveyAnswerDO.username.eq((Object)param.getUsername()));
        }
        if (CollectionUtils.isNotEmpty(param.getOuCodeList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyAnswerRepoProc.surveyAnswerDO.ouCode.in(param.getOuCodeList()));
        }
        return predicate;
    }
}

