package com.elitesland.scp.common;

import com.elitescloud.boot.task.delay.common.DelayTaskSender;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPayTimeoutMqParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

@Component
@Slf4j
@AllArgsConstructor
public class OrderStatusCountdownService {

    private final DelayTaskSender delayTaskSender;

    /**
     * 启动倒计时任务
     *
     * @param orderId      订单ID
     * @param delaySeconds 延迟秒数
     * @param targetStatus 目标状态
     */
    public void startCountdown(Long orderId, long delaySeconds, String targetStatus, LocalDateTime startTime) {
        try {
            //写入mq队列,进行收货确认
            ScpDemandOrderPayTimeoutMqParam orderSubmitMqParam = new ScpDemandOrderPayTimeoutMqParam();
            orderSubmitMqParam.setDocId(orderId);
            orderSubmitMqParam.setTargetStatus(targetStatus);
            orderSubmitMqParam.setBusinessKey(ScpDemandOrderPayTimeoutMqParam.SCP_ORDER_PAY_TIMEOUT_CHANNEL);
            // 通过当前时间加上delaySeconds的秒数计算具体时间
            LocalDateTime delayTime = startTime.plusSeconds(delaySeconds);
            log.info("订单 {} 倒计时开始，倒计时结束时间：{}", orderId, delayTime);
            delayTaskSender.send(ScpDemandOrderPayTimeoutMqParam.SCP_ORDER_PAY_TIMEOUT_CHANNEL, orderId.toString(), orderSubmitMqParam, delayTime);
        } catch (Exception e) {
            log.info("启动支付倒计时：{},发送mq消息失败：{}", orderId, e.toString());
        }
        log.info("订单 {} 启动倒计时，{} 秒后更新状态为 {}", orderId, delaySeconds, targetStatus);
    }

//    /**
//     * 处理倒计时到期事件
//     */
//    private void processCountdown(Long orderId, String targetStatus) {
//        try {
//            String countdownKey = ORDER_TIMEOUT_COUNTDOWN + orderId;
//            // 检查倒计时键是否存在（防止重复处理）
//            if (redisTemplate.hasKey(countdownKey)) {
//                Optional<ScpDemandOrderDO> demandOrderDO = scpDemandOrderRepo.findById(orderId);
//                if (demandOrderDO.isEmpty()) {
//                    log.info("订单 {} 不存在，无需处理倒计时", orderId);
//                    return;
//                }
//
//                ScpDemandOrderDO scpDemandOrderDO = demandOrderDO.get();
//                String payStatus = scpDemandOrderDO.getPayStatus();
//
//                // 如果已支付，则无需处理
//                if (payStatus != null && payStatus.equals(ScpUdcEnum.PAY_STATUS_PAYED.getValueCode())){
//                    // 删除倒计时键
//                    redisTemplate.delete(countdownKey);
//                    return;
//                }
//
//                // 执行状态更新
//                scpDemandOrderRepoProc.updateOrderStatusById(orderId, targetStatus, null);
//
//                // 删除倒计时键
//                redisTemplate.delete(countdownKey);
//
//                log.info("订单 {} 倒计时结束，状态已更新为 {}", orderId, targetStatus);
//
//                // 发布状态更新事件
//                eventPublisher.publishEvent(new OrderStatusUpdateEvent(orderId, targetStatus));
//            }
//        } catch (Exception e) {
//            log.error("处理订单 {} 倒计时失败", orderId, e);
//        }
//    }
//
//    /**
//     * 取消倒计时
//     */
//    public void cancelCountdown(Long orderId) {
//        String countdownKey = ORDER_TIMEOUT_COUNTDOWN + orderId;
//        redisTemplate.delete(countdownKey);
//        log.info("订单 {} 倒计时已取消", orderId);
//    }
//
//    /**
//     * 查询倒计时状态
//     */
//    public OrderCountdownInfo getCountdownInfo(Long orderId) {
//        String countdownKey = ORDER_TIMEOUT_COUNTDOWN + orderId;
//        String jsonStr = (String) redisTemplate.opsForValue().get(countdownKey);
//
//        if (jsonStr != null) {
//            JSONObject jsonObject = JSONUtil.parseObj(jsonStr);
//            OrderCountdownInfo info = new OrderCountdownInfo();
//            info.setOrderId(jsonObject.getLong("orderId"));
//            info.setTargetStatus(jsonObject.getStr("targetStatus"));
//            info.setExpireTime(jsonObject.getLong("expireTime"));
//            info.setRemainingSeconds(Math.max(0, (info.getExpireTime() - System.currentTimeMillis()) / 1000));
//            return info;
//        }
//        return null;
//    }
}



