package com.elitesland.scp.infr.repo.scpsman;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.scp.application.facade.vo.scpsman.*;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.dto.scpsman.SalesmanUpdateDTO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:52
 * @Description:
 */
@Repository
public class ScpsmanInfoRepoProc extends BaseRepoProc<ScpsmanInfoDO> {
    @Autowired
    private ScpsmanInfoRepo scpsmanInfoRepo;

    private static final QScpsmanInfoDO Q_SALESMAN_INFO_DO = QScpsmanInfoDO.scpsmanInfoDO;

    protected ScpsmanInfoRepoProc() {
        super(Q_SALESMAN_INFO_DO);
    }


    public JPAQuery<SalesmanInfoRespVO> findSalesmanInfo(SalesmanInfoQueryVO salesmanInfoQueryVO){
        JPAQuery<SalesmanInfoRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(SalesmanInfoRespVO.class,
                Q_SALESMAN_INFO_DO.id,
                Q_SALESMAN_INFO_DO.scpsmanNo,
                Q_SALESMAN_INFO_DO.scpsmanType,
                Q_SALESMAN_INFO_DO.ouCode,
                Q_SALESMAN_INFO_DO.ouName,
                Q_SALESMAN_INFO_DO.name,
                Q_SALESMAN_INFO_DO.enableStatus,
                Q_SALESMAN_INFO_DO.source,
                Q_SALESMAN_INFO_DO.businessType,
                Q_SALESMAN_INFO_DO.creator,
                Q_SALESMAN_INFO_DO.createTime,
                Q_SALESMAN_INFO_DO.updater,
                Q_SALESMAN_INFO_DO.modifyTime,
                Q_SALESMAN_INFO_DO.jurisdictionAll
                ))
                .from(Q_SALESMAN_INFO_DO);

        List<Predicate> predicates = new ArrayList<>();
        where(salesmanInfoQueryVO, predicates);
        jpaQuery.where(ExpressionUtils.allOf(predicates)).orderBy(Q_SALESMAN_INFO_DO.createTime.desc());
//        salesmanInfoQueryVO.fillOrders(jpaQuery);

        return jpaQuery;
    }

    public JPAQuery<SalesmanSimpleInfoRespVO> findAllSalesmanCode(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        JPAQuery<SalesmanSimpleInfoRespVO> jpaQuery =
                jpaQueryFactory.select(Projections.bean(SalesmanSimpleInfoRespVO.class,
                        Q_SALESMAN_INFO_DO.scpsmanNo))
                        .from(Q_SALESMAN_INFO_DO);

        List<Predicate> predicates = new ArrayList<>();
        where(salesmanInfoQueryVO, predicates);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        salesmanInfoQueryVO.fillOrders(jpaQuery, Q_SALESMAN_INFO_DO);
        return jpaQuery;
    }

    public JPAQuery<SalesmanSimpleInfoRespVO> findAllSalesmanCode() {
        JPAQuery<SalesmanSimpleInfoRespVO> jpaQuery =
                jpaQueryFactory.select(Projections.bean(SalesmanSimpleInfoRespVO.class,
                        Q_SALESMAN_INFO_DO.scpsmanNo))
                        .from(Q_SALESMAN_INFO_DO);
        return jpaQuery;
    }


    public JPAQuery<SalesmanDetailInfoRespVO> findSalesmanInfoDetail(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        JPAQuery<SalesmanDetailInfoRespVO> jpaQuery =
                jpaQueryFactory.select(Projections.bean(SalesmanDetailInfoRespVO.class,
                        Q_SALESMAN_INFO_DO.id,
                        Q_SALESMAN_INFO_DO.scpsmanNo,
                        Q_SALESMAN_INFO_DO.ouName,
                        Q_SALESMAN_INFO_DO.scpsmanType,
                        Q_SALESMAN_INFO_DO.enableStatus))
                        .from(Q_SALESMAN_INFO_DO);

        List<Predicate> predicates = new ArrayList<>();

        where(salesmanInfoQueryVO, predicates);

        jpaQuery.where(ExpressionUtils.allOf(predicates));

        salesmanInfoQueryVO.fillOrders(jpaQuery, Q_SALESMAN_INFO_DO);
        salesmanInfoQueryVO.setPaging(jpaQuery);

        return jpaQuery;
    }

    public List<SalesmanInfoSimpleRespVO> simpleQuery(SalesmanInfoSimpleQueryVO param){
        Predicate expression = Expressions.ONE.eq(Expressions.ONE);
        if (param.getEnableStatus() != null){
            expression =  ExpressionUtils.and(expression, Q_SALESMAN_INFO_DO.enableStatus.eq(param.getEnableStatus()));
        }
        if (CollUtil.isNotEmpty(param.getCodes())){
            expression =  ExpressionUtils.and(expression, Q_SALESMAN_INFO_DO.scpsmanNo.in(param.getCodes()));
        }
        if (CollUtil.isNotEmpty(param.getIds())){
            expression =  ExpressionUtils.and(expression, Q_SALESMAN_INFO_DO.id.in(param.getIds()));
        }

        return jpaQueryFactory.select(Projections.bean(SalesmanInfoSimpleRespVO.class,
                Q_SALESMAN_INFO_DO.scpsmanNo,
                Q_SALESMAN_INFO_DO.id,
                Q_SALESMAN_INFO_DO.enableStatus,
                Q_SALESMAN_INFO_DO.scpsmanType))
                .from(Q_SALESMAN_INFO_DO)
                .where(expression).fetch();
    }

    public List<ScpsmanInfoDO> getSalesmanByCodes(Set<String> salesmanCodes){
        BooleanExpression e = Q_SALESMAN_INFO_DO.scpsmanNo.in(salesmanCodes).and(Q_SALESMAN_INFO_DO.deleteFlag.eq(0));
        Iterable<ScpsmanInfoDO> iterable = scpsmanInfoRepo.findAll(e);
        if(IterUtil.isEmpty(iterable)){
            return new ArrayList<>();
        }
        return Lists.newArrayList(iterable);
    }

    public List<ScpsmanInfoDO> findSalesmanAllInfo(SalesmanInfoQueryVO salesmanInfoQueryVO){
        List<ScpsmanInfoDO> scpsmanInfoDOS = jpaQueryFactory.select(Q_SALESMAN_INFO_DO)
                .from(Q_SALESMAN_INFO_DO).fetch();

        List<Predicate> predicates = new ArrayList<>();
        where(salesmanInfoQueryVO, predicates);
        return scpsmanInfoDOS;
    }

    private static void where(SalesmanInfoQueryVO salesmanInfoQueryVO, List<Predicate> predicates) {

        if(StringUtils.isNotBlank(salesmanInfoQueryVO.getScpsman())){
            predicates.add(Q_SALESMAN_INFO_DO.scpsmanNo.contains(salesmanInfoQueryVO.getScpsman()).or(Q_SALESMAN_INFO_DO.name.contains(salesmanInfoQueryVO.getScpsman())));
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getOuCode())) {
            predicates.add(Q_SALESMAN_INFO_DO.ouCode.eq(salesmanInfoQueryVO.getOuCode()));
        }
        if (salesmanInfoQueryVO.getEnableStatus() != null) {
            predicates.add(Q_SALESMAN_INFO_DO.enableStatus.eq(salesmanInfoQueryVO.getEnableStatus()));
        }

        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getScpsmanType())){
            predicates.add(Q_SALESMAN_INFO_DO.scpsmanType.eq(salesmanInfoQueryVO.getScpsmanType()));
        }
        if (CollUtil.isNotEmpty(salesmanInfoQueryVO.getCodes())){
            predicates.add(Q_SALESMAN_INFO_DO.scpsmanNo.in(salesmanInfoQueryVO.getCodes()));
        }
        if (StrUtil.isNotBlank(salesmanInfoQueryVO.getLoginAccount())) {
            predicates.add(Q_SALESMAN_INFO_DO.loginAccount.eq(salesmanInfoQueryVO.getLoginAccount()));
        }
        if (StrUtil.isNotBlank(salesmanInfoQueryVO.getBusinessType())) {
            predicates.add(Q_SALESMAN_INFO_DO.businessType.eq(salesmanInfoQueryVO.getBusinessType()));
        }
        if (CollUtil.isNotEmpty(salesmanInfoQueryVO.getBusinessTypeList())) {
            List<String> businessTypes = salesmanInfoQueryVO.getBusinessTypeList();
            BooleanExpression condition = Expressions.asBoolean(false).isTrue();

            for (String type : businessTypes) {
                String pattern = "%," + type + ",%";
                BooleanExpression match = Q_SALESMAN_INFO_DO.businessType
                        .startsWith(type + ",")
                        .or(Q_SALESMAN_INFO_DO.businessType.endsWith("," + type))
                        .or(Q_SALESMAN_INFO_DO.businessType.eq(type))
                        .or(Q_SALESMAN_INFO_DO.businessType.like(pattern));
                condition = condition.or(match);
            }

            predicates.add(condition);
        }
    }

    public void changeEnableStatus(Long id, Integer enableStatus){

        jpaQueryFactory.update(Q_SALESMAN_INFO_DO)
                .set(Q_SALESMAN_INFO_DO.enableStatus, enableStatus)
                .where(Q_SALESMAN_INFO_DO.id.eq(id))
                .execute();
    }

    public JPAQuery<SalesmanSuperiorRespVO> findByscpsmanType (SalesmanSuperiorQueryVO param){
        JPAQuery<SalesmanSuperiorRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(SalesmanSuperiorRespVO.class
                , Q_SALESMAN_INFO_DO.id
                , Q_SALESMAN_INFO_DO.scpsmanNo
                , Q_SALESMAN_INFO_DO.scpsmanType.as("type")))
                .from(Q_SALESMAN_INFO_DO);

        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(param.getUdc())) {
            predicates.add(Q_SALESMAN_INFO_DO.scpsmanType.eq(param.getUdc()));
        }
        if(StringUtils.isNotBlank(param.getScpsmanNo())){
            String like = "%" + param.getScpsmanNo() + "%";
            predicates.add(Q_SALESMAN_INFO_DO.scpsmanNo.like(like));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery,Q_SALESMAN_INFO_DO);


        return jpaQuery;
    }

    public JPAQuery<SalesmanInfoRespVO> findByRelateCode(List<String> codes, SalesmanInfoQueryVO salesmanInfoQueryVO){
        JPAQuery<SalesmanInfoRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(SalesmanInfoRespVO.class,
                Q_SALESMAN_INFO_DO.id,
                Q_SALESMAN_INFO_DO.scpsmanType,
                Q_SALESMAN_INFO_DO.ouName,
                Q_SALESMAN_INFO_DO.ouCode,
                Q_SALESMAN_INFO_DO.scpsmanNo,
                Q_SALESMAN_INFO_DO.enableStatus))
                .from(Q_SALESMAN_INFO_DO)
                .where(Q_SALESMAN_INFO_DO.scpsmanNo.in(codes));

        salesmanInfoQueryVO.fillOrders(jpaQuery, Q_SALESMAN_INFO_DO);
        salesmanInfoQueryVO.setPaging(jpaQuery);
        return jpaQuery;
    }

    public JPAQuery<SalesmanInfoRespVO> findByRelateCode(List<String> codes, SalesmanSubordinateQueryVO salesmanSubordinateQueryVO){
        JPAQuery<SalesmanInfoRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(SalesmanInfoRespVO.class,
                Q_SALESMAN_INFO_DO.id,
                Q_SALESMAN_INFO_DO.scpsmanType,
                Q_SALESMAN_INFO_DO.ouName,
                Q_SALESMAN_INFO_DO.scpsmanNo,
                Q_SALESMAN_INFO_DO.enableStatus))
                .from(Q_SALESMAN_INFO_DO)
                .where(Q_SALESMAN_INFO_DO.scpsmanNo.in(codes));

        salesmanSubordinateQueryVO.fillOrders(jpaQuery, Q_SALESMAN_INFO_DO);
        salesmanSubordinateQueryVO.setPaging(jpaQuery);
        return jpaQuery;
    }

    public Long updateSalesmanInfo(SalesmanUpdateDTO salesmanUpdateDTO){
        return jpaQueryFactory.update(Q_SALESMAN_INFO_DO)
                .set(Q_SALESMAN_INFO_DO.fileCode, salesmanUpdateDTO.getFileCode())
                .where(Q_SALESMAN_INFO_DO.id.eq(salesmanUpdateDTO.getSalesmanId()))
                .execute();
    }


    public List<ScpsmanInfoDO> getByIdByCodeOrNames(List<String> empCodes, List<String> names, List<String> salemans){
        BooleanExpression expression = Q_SALESMAN_INFO_DO.isNotNull();
        if(CollUtil.isNotEmpty(salemans)){
            expression = expression.and(Q_SALESMAN_INFO_DO.scpsmanNo.in(salemans).or(Q_SALESMAN_INFO_DO.name.in(salemans)));
        }
        if(CollUtil.isNotEmpty(empCodes)){
            expression = expression.and(Q_SALESMAN_INFO_DO.scpsmanNo.in(empCodes));
        }
        if(CollUtil.isNotEmpty(names)){
            expression = expression.and(Q_SALESMAN_INFO_DO.name.in(names));
        }
        Iterable<ScpsmanInfoDO> iterable = scpsmanInfoRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterable)){
            return Lists.newArrayList(iterable);
        }
        return new ArrayList<>();
    }
    public List<ScpsmanInfoDO> getByIdByCodes(List<String> empCodes){
        BooleanExpression expression = Q_SALESMAN_INFO_DO.scpsmanNo.in(empCodes);
        Iterable<ScpsmanInfoDO> iterable = scpsmanInfoRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterable)){
            return Lists.newArrayList(iterable);
        }
        return new ArrayList<>();
    }

    public List<ScpsmanInfoDO> getByIds(List<Long> ids){
        BooleanExpression expression = Q_SALESMAN_INFO_DO.id.in(ids).and(Q_SALESMAN_INFO_DO.deleteFlag.eq(0));
        Iterable<ScpsmanInfoDO> iterable = scpsmanInfoRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterable)){
            return Lists.newArrayList(iterable);
        }
        return new ArrayList<>();
    }

    public Boolean existsSalesman(String code){
        return super.exists(Q_SALESMAN_INFO_DO.scpsmanNo, code);
    }
    public ScpsmanInfoDO getByCode(String code){
        BooleanExpression e = Q_SALESMAN_INFO_DO.scpsmanNo.eq(code).and(Q_SALESMAN_INFO_DO.deleteFlag.eq(0));
        Iterable<ScpsmanInfoDO> optional = scpsmanInfoRepo.findAll(e);
        if(IterUtil.isEmpty(optional)){
            return null;
        }
        return Lists.newArrayList(optional).get(0);
    }

    public Long getIdByCode(@NotBlank String code) {
        return super.getIdByValue(Q_SALESMAN_INFO_DO.scpsmanNo, code);
    }

    public List<ScpsmanInfoDO> getByCodes(List<String> codes){
        BooleanExpression e = Q_SALESMAN_INFO_DO.scpsmanNo.in(codes).and(Q_SALESMAN_INFO_DO.deleteFlag.eq(0));
        Iterable<ScpsmanInfoDO> optional = scpsmanInfoRepo.findAll(e);
        if(IterUtil.isEmpty(optional)){
            return null;
        }
        return Lists.newArrayList(optional);
    }

    public List<ScpsmanInfoDO> getByLoginAccount(String loginAccount){
        BooleanExpression expression = Q_SALESMAN_INFO_DO.loginAccount.in(loginAccount).and(Q_SALESMAN_INFO_DO.deleteFlag.eq(0));
        Iterable<ScpsmanInfoDO> iterable = scpsmanInfoRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterable)){
            return Lists.newArrayList(iterable);
        }
        return new ArrayList<>();
    }
    public List<ScpsmanInfoDO> getSalesmansContainsName(String agent){
        BooleanExpression e = Q_SALESMAN_INFO_DO.scpsmanNo.contains(agent).or(Q_SALESMAN_INFO_DO.name.contains(agent));
        Iterable<ScpsmanInfoDO> iterables = scpsmanInfoRepo.findAll(e);
        if(IterUtil.isEmpty(iterables)){
            return null;
        }
        return Lists.newArrayList(iterables);
    }

    public ScpsmanInfoDO getByScpsmanNo(String scpsmanNo){
        return super.getOneByValue(Q_SALESMAN_INFO_DO.loginAccount, scpsmanNo);
    }
}
