package com.elitesland.scp.infr.repo.template;

import com.elitesland.scp.domain.entity.template.QScpTemplateOrderDO;
import com.elitesland.scp.domain.entity.template.QScpTemplateSetDO;
import com.elitesland.scp.domain.entity.template.ScpTemplateOrder;
import com.elitesland.scp.domain.entity.template.ScpTemplateOrderDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/4/25 10:34
 * @Description:
 */
@Component
@RequiredArgsConstructor
public class ScpDemandOrderTemplateRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpTemplateOrderDO scpTemplateOrderDO = QScpTemplateOrderDO.scpTemplateOrderDO;
    private final QScpTemplateSetDO scpTemplateSetDO = QScpTemplateSetDO.scpTemplateSetDO;

    public void deleteByMasId(Long masId) {
        jpaQueryFactory.update(scpTemplateOrderDO)
                .set(scpTemplateOrderDO.deleteFlag, 1)
                .where(scpTemplateOrderDO.masId.eq(masId))
                .execute();
    }


    public List<ScpTemplateOrderDO> findByMasId(Long masId) {
        return jpaQueryFactory.selectFrom(scpTemplateOrderDO)
                .where(scpTemplateOrderDO.masId.eq(masId))
                .fetch();
    }

    public List<ScpTemplateOrder> findMasIdsByWhStZoIds(List<Long> storeIds, List<Long> whIds) {
        JPAQuery<ScpTemplateOrder> jpaQuery = jpaQueryFactory.selectDistinct(Projections.bean(
                ScpTemplateOrder.class,
                scpTemplateOrderDO.masId
        )).from(scpTemplateOrderDO);
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (CollectionUtils.isNotEmpty(storeIds) && CollectionUtils.isNotEmpty(whIds)) {
            Predicate predicate1 = ExpressionUtils.or(
                    scpTemplateOrderDO.type.eq(1).and(scpTemplateOrderDO.whStZoId.in(whIds)),
                    scpTemplateOrderDO.type.eq(0).and(scpTemplateOrderDO.whStZoId.in(storeIds))
            );
            Predicate predicate2 = ExpressionUtils.and(predicate, scpTemplateOrderDO.type.eq(2));
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(predicate1, predicate2));
        } else if (CollectionUtils.isNotEmpty(storeIds)) {
            predicate = ExpressionUtils.or(
                    scpTemplateOrderDO.type.eq(2),
                    scpTemplateOrderDO.type.eq(0).and(scpTemplateOrderDO.whStZoId.in(storeIds)));
        } else if (CollectionUtils.isNotEmpty(whIds)) {
            predicate = ExpressionUtils.or(
                    scpTemplateOrderDO.type.eq(2),
                    scpTemplateOrderDO.type.eq(1).and(scpTemplateOrderDO.whStZoId.in(whIds))
            );
        }
        jpaQuery.where(predicate);
        return jpaQuery.fetch();
    }


    public List<ScpTemplateOrderDO> findByMasIdIn(List<Long> masIds) {
        return jpaQueryFactory.selectFrom(scpTemplateOrderDO)
                .where(scpTemplateOrderDO.masId.in(masIds))
                .fetch();
    }

    public List<ScpTemplateOrderDO> findALL() {
        return jpaQueryFactory.selectFrom(scpTemplateOrderDO)
                .where(scpTemplateOrderDO.deleteFlag.eq(0).and(scpTemplateOrderDO.masId.in(JPAExpressions.select(scpTemplateSetDO.id).from(scpTemplateSetDO).where(scpTemplateSetDO.deleteFlag.eq(0)))))
                .fetch();
    }

    @Transactional(rollbackFor = Exception.class)
    public long updateStoreNameByStoreId(Long storeId, String storeName) {
        return jpaQueryFactory.update(scpTemplateOrderDO)
                .set(scpTemplateOrderDO.whStZoName, storeName)
                .where(scpTemplateOrderDO.whStZoId.eq(storeId))
                .execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public Long updateItemNameByItemId(Long itemId, String itemName) {
        return jpaQueryFactory.update(scpTemplateOrderDO)
                .set(scpTemplateOrderDO.itemName, itemName)
                .where(scpTemplateOrderDO.itemId.eq(itemId))
                .execute();
    }
}
