package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.boh.StoreReceiveSendParam;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 门店收货单发货回写
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class StoreReceiveCancelListener implements MessageQueueListener<StoreReceiveSendParam> {

    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final ScpDemandOrderRepo scpDemandOrderRepo;
    private final StoreReceiveRepo storeReceiveRepo;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{StoreReceiveSendParam.CANCEL_CHANNEL};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveSendParam storeReceiveSendParam) {
        log.info("调拨订单取消：{}", JSON.toJSONString(storeReceiveSendParam));
        if ("TRO_AUTO_CLOSE".equals(storeReceiveSendParam.getDocType())) {
            log.info("调拨订单自动关闭不做业务处理");
            return;
        }
        List<Long> dIds = storeReceiveSendParam.getItems().stream().map(StoreReceiveSendParam.OrderItem::getOrderDid).collect(Collectors.toList());
        List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
        if (CollUtil.isNotEmpty(receiveDOS) && "T".equals(receiveDOS.get(0).getRtType())) {
            StoreReceiveDO storeReceiveDO = receiveDOS.get(0);
            storeReceiveRepo.updateStatusById(storeReceiveDO.getId(), "CL");
        } else {
            // 取消现有明细行（以及相关单据行）
            scpDemandOrderDDomainService.cancelOrderByDIds(dIds);
            // 判断是否所有明细行都被取消
            List<ScpDemandOrderDDO> byMasIdAndStatus = scpDemandOrderDRepoProc.findByMasIdAndStatusNotAndProjectFeeFlag(storeReceiveSendParam.getOrderId(),
                    ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode(),
                    false);
            if (CollUtil.isEmpty(byMasIdAndStatus)) {
                // 明细行已经全部取消，则更新主表状态为已取消
                scpDemandOrderRepo.updateDocStatusById(storeReceiveSendParam.getOrderId(), ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode());
            }
        }
    }

}
