package com.elitesland.scp.application.facade.vo.stock;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-01-21
* @Version 1.0
**/

@Data
@ApiModel("预测目标库存安全库存列表")
public class ScpPredictStStockRespVO extends BaseViewModel implements Serializable {

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "预测批次")
    private String predLotNo;

    @ApiModelProperty(value = "标准安全目标库存ID")
    private Long stId;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "仓库ID")
    private Long whId;

    @ApiModelProperty(value = "仓库编码")
    private String whCode;

    @ApiModelProperty(value = "仓库名称")
    private String whName;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "安全库存")
    private BigDecimal safetyQty;

    @ApiModelProperty(value = "安全库存")
    private BigDecimal targetQty;

    @ApiModelProperty(value = "计划单位")
    private String planUom;
    private String planUomName;

    @ApiModelProperty(value = "商品类型2")
    private String itemType2;

    @ApiModelProperty(value = "商品类型2")
    private String itemCateCode;

    @ApiModelProperty(value = "品牌")
    private String brand;

    @ApiModelProperty(value = "预测安全库存")
    private BigDecimal predSafetyQty;

    @ApiModelProperty(value = "预测安全库存")
    private BigDecimal predTargetQty;

    private String businessId;

    @ApiModelProperty(value = "是否生成MRP计划")
    private Boolean mrpFlag;

    @ApiModelProperty(value = "月销量")
    private BigDecimal saleQty;

    @ApiModelProperty(value = "库存统计数量")
    private BigDecimal ioQty;

    private BigDecimal uomRatio;

}