package com.elitesland.scp.domain.vo.survey;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(description = "问卷管理查询入参")
public class SurveyAnswerParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -5469973862376913771L;

    @ApiModelProperty("问卷ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suvId;

    @ApiModelProperty(value = "填写人")
    private String creator;

    @ApiModelProperty(value = "填写人")
    private String username;

    @ApiModelProperty(value = "公司")
    private List<String> ouCodeList;

}
