/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.msg.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.SysNoticeRpcService;
import com.elitescloud.cloudt.system.provider.dto.save.SysNoticeSaveDTO;
import com.elitesland.scp.application.facade.vo.query.msg.ScpMessagePageMngQueryVO;
import com.elitesland.scp.application.facade.vo.resp.msg.BaseScpMessageListRespVO;
import com.elitesland.scp.application.facade.vo.resp.msg.ScpMessageEditRespVO;
import com.elitesland.scp.application.facade.vo.resp.msg.ScpMessagePageRespVO;
import com.elitesland.scp.application.facade.vo.save.msg.ScpMessageSaveVO;
import com.elitesland.scp.common.ScpMessageChannel;
import com.elitesland.scp.common.ScpMessageReceiverType;
import com.elitesland.scp.domain.convert.msg.ScpMessageConvert;
import com.elitesland.scp.domain.entity.msg.ScpMessageChannelDO;
import com.elitesland.scp.domain.entity.msg.ScpMessageDO;
import com.elitesland.scp.domain.entity.msg.ScpMessageReceiverDO;
import com.elitesland.scp.domain.entity.msg.ScpMessageTxtDO;
import com.elitesland.scp.domain.service.msg.ScpMessageMngService;
import com.elitesland.scp.domain.service.msg.impl.BaseScpMessageService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class ScpMessageMngServiceImpl
extends BaseScpMessageService
implements ScpMessageMngService {
    private static final Logger logger = LoggerFactory.getLogger(ScpMessageMngServiceImpl.class);
    @Autowired
    private SysNoticeRpcService noticeRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(ScpMessageSaveVO saveVO) {
        ScpMessageDO messageDO = this.upsert(saveVO);
        return ApiResult.ok((Object)messageDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Set<Long>> delete(Set<Long> ids, Boolean real) {
        if (ids != null) {
            ids = ids.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail((String)"\u6d88\u606fID\u4e3a\u7a7a");
        }
        this.messageAdapter(ids, t -> {
            ArrayList<String> idsOfSys;
            Set<Long> idsOfHasWeb = this.filterChannelOfWeb((Collection<Long>)t);
            ArrayList<String> arrayList = idsOfSys = idsOfHasWeb.isEmpty() ? Collections.emptyList() : new ArrayList<String>(this.channelRepoProc.getPublishedId(idsOfHasWeb, ScpMessageChannel.WEB.name()).values());
            if (real == null || Boolean.TRUE.equals(real)) {
                this.repoProc.delete((Collection)t);
                this.txtRepoProc.deleteByMessageId((Collection<Long>)t);
                this.channelRepoProc.deleteByMessageId((Collection<Long>)t);
                this.receiverRepoProc.deleteByMessageId((Collection<Long>)t);
            } else {
                this.repoProc.updateDeleteFlag((Collection)t);
            }
            this.revokeFromSys(idsOfHasWeb, idsOfSys);
        });
        return ApiResult.ok(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Set<Long>> execPublish(Set<Long> ids) {
        if (ids != null) {
            ids = ids.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail((String)"\u6d88\u606fID\u4e3a\u7a7a");
        }
        this.messageAdapter(ids, t -> {
            this.repoProc.updatePublish((Collection<Long>)t);
            this.repoProc.updatePublish((Collection<Long>)t, LocalDateTime.now());
            this.publishToSys((Collection<Long>)t);
        });
        return ApiResult.ok(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Set<Long>> execRevoke(Set<Long> ids) {
        if (ids != null) {
            ids = ids.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail((String)"\u6d88\u606fID\u4e3a\u7a7a");
        }
        this.messageAdapter(ids, t -> {
            this.repoProc.updateRevoke((Collection<Long>)t);
            Set<Long> idsOfHasWeb = this.filterChannelOfWeb((Collection<Long>)t);
            ArrayList<String> idsOfSys = idsOfHasWeb.isEmpty() ? Collections.emptyList() : new ArrayList<String>(this.channelRepoProc.getPublishedId(idsOfHasWeb, ScpMessageChannel.WEB.name()).values());
            this.revokeFromSys(idsOfHasWeb, (Collection<String>)idsOfSys);
        });
        return ApiResult.ok(ids);
    }

    @Override
    public ApiResult<ScpMessageEditRespVO> getEditVO(Long id) {
        Assert.notNull((Object)id, (String)"\u6d88\u606fID\u4e3a\u7a7a");
        ScpMessageEditRespVO messageVO = this.get(id);
        return ApiResult.ok((Object)messageVO);
    }

    @Override
    public ApiResult<PagingVO<ScpMessagePageRespVO>> pageMng(ScpMessagePageMngQueryVO queryVO) {
        PagingVO<ScpMessagePageRespVO> pageData = this.queryByPage(queryVO);
        return ApiResult.ok(pageData);
    }

    private void publishToSys(Collection<Long> ids) {
        Set<Long> idsOfHasWeb = this.filterChannelOfWeb(ids);
        if (idsOfHasWeb.isEmpty()) {
            return;
        }
        List messageList = this.repoProc.get(idsOfHasWeb);
        if (messageList.isEmpty()) {
            return;
        }
        Set messageTxtIds = messageList.stream().map(ScpMessageDO::getTxtId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map messageTxtMap = messageTxtIds.isEmpty() ? Collections.emptyMap() : this.txtRepoProc.get(messageTxtIds).stream().collect(Collectors.toMap(ScpMessageTxtDO::getMessageId, Function.identity(), (t1, t2) -> t1));
        List noticeList = messageList.stream().map(t -> {
            SysNoticeSaveDTO noticeSaveDTO = ScpMessageConvert.INSTANCE.convert2NoticeSaveDTO((ScpMessageDO)((Object)t));
            noticeSaveDTO.setSys(Boolean.valueOf(false));
            ScpMessageTxtDO txt = (ScpMessageTxtDO)((Object)((Object)messageTxtMap.get(t.getId())));
            if (txt != null) {
                noticeSaveDTO.setTxt(txt.getTxt());
            }
            return noticeSaveDTO;
        }).collect(Collectors.toList());
        List publishedIds = (List)this.noticeRpcService.publish(noticeList).computeData();
        int i = 0;
        for (ScpMessageDO messageDO : messageList) {
            Long publishId = publishedIds.size() > i ? (Long)publishedIds.get(i) : null;
            this.channelRepoProc.updatePublishedId(messageDO.getId(), ScpMessageChannel.WEB.name(), publishId == null ? null : publishId.toString());
            ++i;
        }
    }

    private void revokeFromSys(Collection<Long> messageId, Collection<String> publishIds) {
        if (publishIds.isEmpty()) {
            return;
        }
        this.channelRepoProc.deletePublishedId(messageId, ScpMessageChannel.WEB.name());
        Set noticeIds = publishIds.stream().map(Long::parseLong).collect(Collectors.toSet());
        this.noticeRpcService.revokeBatch(noticeIds);
    }

    private Set<Long> filterChannelOfWeb(Collection<Long> ids) {
        Map<Long, List<String>> channelsMap = this.channelRepoProc.getChannels(ids);
        if (channelsMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> filterIds = new HashSet<Long>(ids.size());
        for (Map.Entry<Long, List<String>> entry : channelsMap.entrySet()) {
            if (!entry.getValue().contains(ScpMessageChannel.WEB.name())) continue;
            filterIds.add(entry.getKey());
        }
        return filterIds;
    }

    private void messageAdapter(Collection<Long> ids, Consumer<Collection<Long>> consumer) {
        List normalIds = this.repoProc.exists(ids);
        if (!normalIds.isEmpty()) {
            consumer.accept(normalIds);
            if (normalIds.size() == ids.size()) {
                return;
            }
        }
    }

    private ScpMessageEditRespVO get(long id) {
        Map<String, OrgStoreBaseRpcDTO> storeList;
        List<String> storeCodes;
        ScpMessageDO messageDO = (ScpMessageDO)((Object)this.repoProc.get(id));
        if (messageDO == null) {
            return null;
        }
        ScpMessageEditRespVO messageEditRespVO = ScpMessageConvert.INSTANCE.convert2EditVO(messageDO);
        messageEditRespVO.setPublished(this.hasPublished(messageDO));
        super.fillDetailInfo(messageDO, messageEditRespVO);
        List<String> channels = this.channelRepoProc.getChannels(id);
        messageEditRespVO.setPushApplet(channels.contains(ScpMessageChannel.APPLET.name()));
        messageEditRespVO.setOrgStoreCodes(new ArrayList<String>(8));
        messageEditRespVO.setOrgStores(new ArrayList<CodeNameParam>(32));
        if (Boolean.TRUE.equals(messageEditRespVO.getPushApplet()) && !(storeCodes = this.receiverRepoProc.getReceivers(id, ScpMessageReceiverType.STORE.name())).isEmpty() && CollUtil.isNotEmpty(storeList = this.orgStoreRpcService.getOrgStoreBaseMap(storeCodes))) {
            for (OrgStoreBaseRpcDTO value : storeList.values()) {
                messageEditRespVO.getOrgStoreCodes().add(value.getStoreCode());
                messageEditRespVO.getOrgStores().add(new CodeNameParam(value.getStoreCode(), value.getStoreName()));
            }
        }
        return messageEditRespVO;
    }

    private ScpMessageDO upsert(ScpMessageSaveVO saveVO) {
        ScpMessageDO messageDO = this.checkAndConvert(saveVO);
        this.repoProc.save((Serializable)((Object)messageDO));
        ScpMessageTxtDO messageTxtDO = this.saveTxt(saveVO, messageDO);
        this.repoProc.updateTxtId(messageDO.getId(), messageTxtDO.getId());
        this.saveChannels(saveVO, messageDO);
        this.saveReceivers(saveVO, messageDO);
        return messageDO;
    }

    private PagingVO<ScpMessagePageRespVO> queryByPage(ScpMessagePageMngQueryVO queryVO) {
        PagingVO pageData;
        if (queryVO.getStoreCode() != null) {
            List<ScpMessageReceiverDO> allByReceiverTypeAndReceiverId = this.receiverRepo.findAllByReceiverTypeAndReceiverId(ScpMessageReceiverType.STORE.name(), queryVO.getStoreCode());
            if (allByReceiverTypeAndReceiverId.isEmpty()) {
                return PagingVO.empty();
            }
            Set collect = allByReceiverTypeAndReceiverId.stream().map(ScpMessageReceiverDO::getMessageId).collect(Collectors.toSet());
            queryVO.setIdSet(new LinkedHashSet(collect));
        }
        if ((pageData = this.repoProc.pageMng(queryVO).map(t -> {
            ScpMessagePageRespVO respVO = ScpMessageConvert.INSTANCE.convert2PageVO((ScpMessageDO)((Object)t));
            respVO.setPublished(this.hasPublished((ScpMessageDO)((Object)t)));
            return respVO;
        })).isEmpty()) {
            return pageData;
        }
        super.fillListInfo(pageData.getRecords());
        Set<Long> ids = pageData.stream().map(BaseScpMessageListRespVO::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, List<String>> channelsMap = this.channelRepoProc.getChannels(ids);
        Map<Long, List<IdCodeNameParam>> receiversMap = this.receiverRepoProc.getReceivers(ids);
        List<String> storeCodes = receiversMap.values().stream().flatMap(t -> t.stream().filter(tt -> ScpMessageReceiverType.STORE.name().equals(tt.getName())).map(IdCodeNameParam::getCode)).collect(Collectors.toList());
        Map storeMap = storeCodes.isEmpty() ? Collections.emptyMap() : this.orgStoreRpcService.getOrgStoreBaseMap(storeCodes);
        pageData.each(t -> {
            List channels = (List)channelsMap.get(t.getId());
            if (channels != null && channels.contains(ScpMessageChannel.APPLET.name())) {
                t.setPushApplet(true);
                t.setOrgStoreCodes(new ArrayList<String>(8));
                t.setOrgStores(new ArrayList<CodeNameParam>(8));
                List receivers = (List)receiversMap.get(t.getId());
                for (IdCodeNameParam receiver : receivers) {
                    OrgStoreBaseRpcDTO store;
                    if (!ScpMessageReceiverType.STORE.name().equals(receiver.getName()) || (store = (OrgStoreBaseRpcDTO)storeMap.get(receiver.getCode())) == null) continue;
                    t.getOrgStoreCodes().add(store.getStoreCode());
                    t.getOrgStores().add(new CodeNameParam(store.getStoreCode(), store.getStoreName()));
                }
            } else {
                t.setPushApplet(false);
            }
        });
        return pageData;
    }

    private boolean hasPublished(ScpMessageDO messageDO) {
        if (Boolean.FALSE.equals(messageDO.getPublished())) {
            return false;
        }
        return messageDO.getPublishTime() != null && messageDO.getPublishTime().isBefore(LocalDateTime.now());
    }

    private ScpMessageDO checkAndConvert(ScpMessageSaveVO saveVO) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        ScpMessageDO messageDO = null;
        if (saveVO.getId() == null) {
            messageDO = new ScpMessageDO();
        } else {
            messageDO = (ScpMessageDO)((Object)this.repoProc.get(saveVO.getId()));
            Assert.notNull((Object)((Object)messageDO), (String)"\u6d88\u606f\u4e0d\u5b58\u5728");
            if (this.hasPublished(messageDO)) {
                throw new BusinessException("\u6d88\u606f\u5df2\u53d1\u5e03\uff0c\u4e0d\u53ef\u4fee\u6539");
            }
        }
        Assert.hasText((String)saveVO.getTitle(), (String)"\u6807\u9898\u4e3a\u7a7a");
        Assert.hasText((String)saveVO.getTxt(), (String)"\u5185\u5bb9\u4e3a\u7a7a");
        ObjUtil.ifNull((Object)saveVO.getAuthorId(), (Object)currentUser.getUserId(), saveVO::setAuthorId);
        ObjUtil.ifNull((Object)saveVO.getTop(), (Object)false, saveVO::setTop);
        ObjUtil.ifNull((Object)saveVO.getPushApplet(), (Object)false, saveVO::setPushApplet);
        if (Boolean.TRUE.equals(saveVO.getPushApplet()) && CollUtil.isEmpty(saveVO.getOrgStoreCodes())) {
            throw new BusinessException("\u63a8\u9001\u5c0f\u7a0b\u5e8f\u65f6\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ScpMessageConvert.INSTANCE.convert2DO(saveVO, messageDO);
        messageDO.setPublished(saveVO.getPublishTime() != null);
        messageDO.setChangeTime(LocalDateTime.now());
        if (CollUtil.isNotEmpty(saveVO.getFileCodes())) {
            messageDO.setFileCodesStr(String.join((CharSequence)",", saveVO.getFileCodes()));
        } else {
            messageDO.setFileCodesStr(null);
        }
        messageDO.setSuvId(saveVO.getSuvId());
        return messageDO;
    }

    private ScpMessageTxtDO saveTxt(ScpMessageSaveVO saveVO, ScpMessageDO messageDO) {
        ScpMessageTxtDO messageTxtDO = messageDO.getTxtId() == null ? new ScpMessageTxtDO() : (ScpMessageTxtDO)((Object)this.txtRepoProc.get(messageDO.getTxtId()));
        messageTxtDO.setTxt(saveVO.getTxt());
        messageTxtDO.setMessageId(messageDO.getId());
        if (CollUtil.isNotEmpty(saveVO.getTxtFileCodes())) {
            messageTxtDO.setFileCodesStr(String.join((CharSequence)",", saveVO.getTxtFileCodes()));
        } else {
            messageTxtDO.setFileCodesStr(null);
        }
        messageTxtDO.setExtAttr(CollUtil.isEmpty(saveVO.getTxtExtAttr()) ? null : saveVO.getTxtExtAttr());
        this.txtRepoProc.save((Serializable)((Object)messageTxtDO));
        return messageTxtDO;
    }

    private void saveChannels(ScpMessageSaveVO saveVO, ScpMessageDO messageDO) {
        List channelDoList;
        List<String> toDelChannels;
        ArrayList<String> channels = new ArrayList<String>();
        if (Boolean.TRUE.equals(saveVO.getPushApplet())) {
            channels.add(ScpMessageChannel.APPLET.name());
        } else {
            channels.add(ScpMessageChannel.WEB.name());
        }
        List<String> currentChannels = this.channelRepoProc.getChannels(messageDO.getId());
        if (!currentChannels.isEmpty() && !(toDelChannels = currentChannels.stream().filter(t -> !channels.contains(t)).collect(Collectors.toList())).isEmpty()) {
            this.channelRepoProc.deleteChannels(messageDO.getId(), toDelChannels);
        }
        if (!(channelDoList = channels.stream().filter(t -> !currentChannels.contains(t)).map(t -> {
            ScpMessageChannelDO channelDO = new ScpMessageChannelDO();
            channelDO.setMessageId(messageDO.getId());
            channelDO.setChannel((String)t);
            return channelDO;
        }).collect(Collectors.toList())).isEmpty()) {
            this.channelRepoProc.save(channelDoList);
        }
    }

    private void saveReceivers(ScpMessageSaveVO saveVO, ScpMessageDO messageDO) {
        List receiverDoList;
        List<String> toDelReceivers;
        List<String> currentReceivers;
        ArrayList receivers = new ArrayList();
        if (CollUtil.isNotEmpty(saveVO.getOrgStoreCodes())) {
            receivers.addAll(saveVO.getOrgStoreCodes().stream().filter(StringUtils::hasText).collect(Collectors.toList()));
        }
        if (!(currentReceivers = this.receiverRepoProc.getReceivers(messageDO.getId(), ScpMessageReceiverType.STORE.name())).isEmpty() && !(toDelReceivers = currentReceivers.stream().filter(t -> !receivers.contains(t)).collect(Collectors.toList())).isEmpty()) {
            this.receiverRepoProc.deleteReceivers(messageDO.getId(), ScpMessageReceiverType.STORE.name(), toDelReceivers);
        }
        if (!(receiverDoList = receivers.stream().filter(t -> !currentReceivers.contains(t)).map(t -> {
            ScpMessageReceiverDO receiverDO = new ScpMessageReceiverDO();
            receiverDO.setMessageId(messageDO.getId());
            receiverDO.setReceiverType(ScpMessageReceiverType.STORE.name());
            receiverDO.setReceiverId((String)t);
            receiverDO.setViewed(false);
            return receiverDO;
        }).collect(Collectors.toList())).isEmpty()) {
            this.receiverRepoProc.save(receiverDoList);
        }
    }
}

