package com.elitesland.scp.application.facade.vo.calendar;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 29日 15:10
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpStoreDemandCalendarPageVO", description = "门店日历分页")
public class ScpStoreDemandCalendarPageVO extends BaseViewModel implements Serializable {

    @ApiModelProperty(value = "类型")
    @SysCode(sys = "yst-suplan", mod = "CALENDAR_CONFIG_METHOD")
    private String type;

    @ApiModelProperty(value = "类型名")
    private String typeName;

    @ApiModelProperty(value = "门店id")
    private Long storeId;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty(value = "年")
    private String year;

    @ApiModelProperty(value = "月")
    private String month;

    @ApiModelProperty(value = "配送类型")
    private String deliveryType;
    private String deliveryTypeName;

    @ApiModelProperty(value = "日历工作日明细")
    private List<CalendarDayDetail> dayDetails;


    @Data
    public static class CalendarDayDetail extends BaseViewModel implements Serializable {

        @ApiModelProperty(value = "日")
        private String day;

        @ApiModelProperty(value = "工作状态")
        private String workStatus;

    }

}
