package com.elitesland.scp.application.facade.vo.serviceconfig;


import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author chaofeng.xia
 * @since 2025/5/23
 */
@Data
@ApiModel("仓网关系返回")
public class ScpServiceConfigRespVO extends BaseViewModel implements Serializable {

    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("费用归属类型")
    @SysCode(sys = "yst-suplan", mod = "SC_FEE_TYPE")
    private String feeType;
    private String feeTypeName;

    @ApiModelProperty("费用归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("费用归属公司编码")
    private String ouCode;

    @ApiModelProperty("费用归属公司名称")
    private String ouName;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "SERVICE_CONFIG_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("区域id/门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long regionStoreId;

    @ApiModelProperty("区域编码/门店编码")
    private String regionStoreCode;

    @ApiModelProperty("区域名称/门店名称")
    private String regionStoreName;

    @ApiModelProperty("适用门店等级")
    private String storeLevel;
    private String storeLevelName;

    @ApiModelProperty("费用比例")
    private BigDecimal feePercentage;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;


}
