package com.elitesland.scp.application.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.enums.ScpUdcEnum;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthorityDSaveVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthoritySaveVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoSaveVO;
import com.elitesland.scp.application.facade.vo.scpsman.ScpsmanRegionSaveVO;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityService;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.domain.bo.ScpsmanRegionBO;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityDConvert;
import com.elitesland.scp.domain.convert.scpsman.SalesmanInfoConvert;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanRegionDO;
import com.elitesland.scp.dto.scpsman.SalesmanInfoRpcSaveVo;
import com.elitesland.scp.dto.scpsman.ScpsmanGrantedRegionDTO;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanRegionRepoProc;
import com.elitesland.scp.service.scpsman.ScpsmanRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author chaofeng.xia
 * @since 2025/8/4
 */
@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(ScpApplication.URI_PREFIX + ScpsmanRpcService.PATH)
public class ScpsmanRpcServiceImpl implements ScpsmanRpcService {

    private final ScpsmanInfoService scpsmanInfoService;

    private final ScpsmanInfoRepoProc scpsmanInfoRepoProc;

    private final ScpsmanRegionRepoProc scpsmanRegionRepoProc;

    private final ScpDemandAuthorityDRepoProc scpDemandAuthorityDRepoProc;

    private final ScpsmanAuthorityService scpsmanAuthorityService;

    private final UserRpcService userRpcService;

    @Override
    @Transactional(rollbackFor = BusinessException.class)
    public ApiResult<Long> saveAndAuthority(SalesmanInfoRpcSaveVo saveVo) {
        log.info("计划员信息保存RPC接口调用开始：{}", JSONObject.toJSONString(saveVo));
        SalesmanInfoSaveVO salesmanInfoSaveVO = SalesmanInfoConvert.INSTANCE.rpc2saveVO(saveVo);
        if (StringUtils.hasText(salesmanInfoSaveVO.getPhone())) {
            UserQueryDTO userQueryDTO = new UserQueryDTO();
            userQueryDTO.setMobiles(Set.of(salesmanInfoSaveVO.getPhone()));
            ApiResult<List<SysUserBasicDTO>> userResult = userRpcService.queryUser(userQueryDTO);
            if (userResult.isSuccess() && CollectionUtil.isNotEmpty(userResult.getData())) {
                SysUserBasicDTO user = userResult.getData().get(0);
                salesmanInfoSaveVO.setSource("EMP");
                salesmanInfoSaveVO.setUserId(user.getId());
//                salesmanInfoSaveVO.setLoginAccount(user.getUsername());
            }
        }
        ApiResult<ScpsmanInfoDO> scpsmanInfoDOApiResult = scpsmanInfoService.save(salesmanInfoSaveVO);
        if (scpsmanInfoDOApiResult.isFailed() || scpsmanInfoDOApiResult.getData() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "订货账号保存失败");
        }
        ScpsmanInfoDO scpsmanInfoDO = scpsmanInfoDOApiResult.getData();

        if (CollUtil.isNotEmpty(saveVo.getScpManAuthorityDSaveVOS())) {
            // 授权区域
            ScpsmanRegionSaveVO regionSaveVO = new ScpsmanRegionSaveVO();
            regionSaveVO.setScpsmanId(scpsmanInfoDO.getId());
            regionSaveVO.setRegionType(ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode());
            regionSaveVO.setRegionCodes(Set.of(saveVo.getScpManAuthorityDSaveVOS().get(0).getStWhCode()));
            scpsmanInfoService.addRegion(regionSaveVO);

//            ScpManAuthoritySaveVO scpManAuthoritySaveVO = new ScpManAuthoritySaveVO();
//            scpManAuthoritySaveVO.setScpsmanId(scpsmanInfoDO.getId());
//            scpManAuthoritySaveVO.setScpsmanNo(scpsmanInfoDO.getScpsmanNo());
//            scpManAuthoritySaveVO.setScpsmanName(scpsmanInfoDO.getName());
//            scpManAuthoritySaveVO.setOuId(scpsmanInfoDO.getOuId());
//            scpManAuthoritySaveVO.setOuCode(scpsmanInfoDO.getOuCode());
//            scpManAuthoritySaveVO.setOuName(scpsmanInfoDO.getOuName());
//            scpManAuthoritySaveVO.setEnableStatus(Boolean.TRUE);
//
//            List<ScpManAuthorityDSaveVO> scpManAuthorityDSaveVOS = ScpDemandAuthorityDConvert.INSTANCE.rpc2SaveVo(saveVo.getScpManAuthorityDSaveVOS());
//            scpManAuthoritySaveVO.setScpManAuthorityDSaveVOS(scpManAuthorityDSaveVOS);
//            // 保存计划员权限
//            log.info("计划员权限信息保存RPC接口调用开始：{}", JSONObject.toJSONString(scpManAuthoritySaveVO));
//            scpsmanAuthorityService.saveScpAuthority(scpManAuthoritySaveVO);
        }
        log.info("计划员信息保存RPC接口调用结束：{}", JSONObject.toJSONString(scpsmanInfoDO));
        return ApiResult.ok(scpsmanInfoDO.getId());
    }

    @Override
    public ApiResult<ScpsmanGrantedRegionDTO> getGrantedRegion(String scpsmanNo) {
        if (StrUtil.isBlank(scpsmanNo)) {
            return ApiResult.fail("计划员编号为空");
        }

        // 获取计划员信息
        var scpsman = scpsmanInfoRepoProc.getByScpsmanNo(scpsmanNo);
        if (scpsman == null) {
            return ApiResult.ok();
        }

        ScpsmanGrantedRegionDTO dto = new ScpsmanGrantedRegionDTO();
        dto.setScpsmanNo(scpsmanNo);
        // 授权区域
        dto.setJurisdictionAll(Boolean.TRUE.equals(scpsman.getJurisdictionAll()));
        if (dto.getJurisdictionAll()) {
            // 授权所有
            dto.setRegionCodes(Collections.emptySet());
            dto.setStoreCodes(Collections.emptySet());
            return ApiResult.ok(dto);
        }

        var regionMap = scpsmanRegionRepoProc.listBoByMasId(scpsman.getId())
                .stream()
                .collect(Collectors.groupingBy(ScpsmanRegionBO::getRegionType, Collectors.mapping(ScpsmanRegionBO::getRegionCode, Collectors.toSet())));

        dto.setRegionCodes(regionMap.getOrDefault(ScpUdcEnum.SCPSMAN_REGION_TYPE_REGION.getValueCode(), Collections.emptySet()));
        dto.setStoreCodes(regionMap.getOrDefault(ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode(), Collections.emptySet()));
        return ApiResult.ok(dto);
    }
}
