package com.elitesland.scp.domain.service.minOrder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingRegionRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingRegionSaveVO;

import java.util.List;

public interface ScpMinOrderSettingRegionDomainService {

    /**
     * 订货强配活动区域查询
     *
     * @param masId
     * @return
     */
    List<ScpMinOrderSettingRegionRespVO> findByMasId(Long masId);

    /**
     * 订货强配活动配置保存
     *
     * @param saveVOS 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    void batchSaveSettingRegion(List<ScpMinOrderSettingRegionSaveVO> saveVOS);

    /**
     * 删除订货强配活动区域
     *
     * @param masId
     */
    void deleteByMasId(Long masId);

    /**
     * 删除订货强配活动区域
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 区域分页查询
     * @param paramVO
     * @return
     */
    PagingVO<ScpMinOrderSettingRegionRespVO> page(ScpMinOrderSettingRegionPageParamVO paramVO);

    /**
     * 根据区域编码查询
     * @param regionCode
     * @return
     */
    List<Long> findMasIdByRegionCode(String regionCode);
}
