package com.elitesland.scp.domain.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderReplyPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderReplyPageRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderReplySaveVO;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderReplyConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderReplyDO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderReplyDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderReplyRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderReplyRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpDemandOrderReplyDomainServiceImpl implements ScpDemandOrderReplyDomainService {
    private final ScpDemandOrderReplyRepo scpDemandOrderReplyRepo;
    private final ScpDemandOrderReplyRepoProc scpDemandOrderReplyRepoProc;

    @Override
    public Long save(ScpDemandOrderReplySaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpDemandOrderReplyDO replyDO = ScpDemandOrderReplyConvert.INSTANCE.saveVoToDO(saveVO);
            return scpDemandOrderReplyRepo.save(replyDO).getId();
        } else {
            Optional<ScpDemandOrderReplyDO> option = scpDemandOrderReplyRepo.findById(saveVO.getId());
            if (option.isEmpty()) {
                throw new BusinessException("订单评价ID：" + saveVO.getId() + "不存在");
            }
            ScpDemandOrderReplyConvert.INSTANCE.copySaveParamToDo(saveVO, option.get());
            Long masId = scpDemandOrderReplyRepo.save(option.get()).getId();
            return masId;
        }
    }

    @Override
    public Optional<ScpDemandOrderReplyDTO> findReplyByOrderId(Long orderId) {
        List<ScpDemandOrderReplyDO> orderReplyDOS = scpDemandOrderReplyRepo.findByOrderId(orderId);
        if (CollUtil.isEmpty(orderReplyDOS)) {
            throw new BusinessException("订单评价ID：" + orderId + "不存在");
        }
        return Optional.of(orderReplyDOS.get(0)).map(ScpDemandOrderReplyConvert.INSTANCE::doToDto);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpDemandOrderReplyPageRespVO> page(ScpDemandOrderReplyPageParamVO paramVO) {
        long count = scpDemandOrderReplyRepoProc.countOrderReply(paramVO);
        if (count > 0) {
            var demandOrder = scpDemandOrderReplyRepoProc.queryOrderReply(paramVO);
            demandOrder.forEach(row -> {
                row.setPicList(StrUtil.split(row.getPics(), ";"));
                String orderScoreStr = row.getOrderScore() == null ? "" : row.getOrderScore().toString() + "/5";
                String expressScoreStr = row.getExpressScore() == null ? "" : row.getExpressScore().toString() + "/5";
                row.setOrderScoreStr(orderScoreStr);
                row.setExpressScoreStr(expressScoreStr);
            });
            return new PagingVO<>(count, demandOrder);
        }
        return new PagingVO<>();
    }
}
