package com.elitesland.scp.application.facade.vo.param.app;

import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "商品橱窗查询入参")
public class AppItemActivityParamVO implements Serializable {
    private static final long serialVersionUID = -8387700128516698775L;

    @ApiModelProperty(value = "门店编码",required = true)
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "商品品类编码集合")
    private List<String> itemCateCodes;

    @ApiModelProperty(name = "开始时间")
    private LocalDateTime fromdate;

    @ApiModelProperty(name = "结束时间")
    private LocalDateTime todate;

    @ApiModelProperty(name = "倒序/正序")
    private String asc;

    @ApiModelProperty(name = "排序字段")
    private String column;

    @ApiModelProperty(name = "商品编码")
    private List<String> itemCodes;

    @ApiModelProperty(name = "关键词")
    private String keyword;





}
