package com.elitesland.scp.application.facade.vo.stock;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 01月 17日 10:40
 * @version: 1.0
 */
@Data
@ExcelIgnoreUnannotated
@ApiModel(value = "SafetyTargetStockExport", description = "安全库存目标库存配置导出")
public class ScpSafetyTargetStockDownloadVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "公司编码")
    @ExcelProperty(value = "公司编码",index = 0)
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    @ExcelProperty(value = "公司名称", index = 1)
    private String ouName;

    @ApiModelProperty(value = "仓库编码")
    @ExcelProperty(value = "仓库编码",index =2)
    private String whCode;

    @ApiModelProperty(value = "仓库名称")
    @ExcelProperty(value = "仓库名称",index = 3)
    private String whName;

    @ApiModelProperty(value = "商品编码")
    @ExcelProperty(value = "商品编码",index = 4)
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    @ExcelProperty(value = "商品名称",index = 5)
    private String itemName;

    @ApiModelProperty(value = "安全库存")
    @ExcelProperty(value = "安全库存",index = 6)
    private BigDecimal safetyQty;

    @ApiModelProperty(value = "目标库存")
    @ExcelProperty(value = "目标库存",index = 7)
    private BigDecimal targetQty;

    @ApiModelProperty(value = "计划单位")
    @ExcelProperty(value = "计划单位",index = 8)
    private String planUom;

    @ApiModelProperty(value = "计划单位名称")
    @ExcelProperty(value = "计划单位名称",index = 9)
    private String planUomName;

    @ApiModelProperty(value = "基本单位")
    private String uom;




}
