package com.elitesland.scp.application.service.stock;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockSaveVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockUpdateParam;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockSaveVO;
import com.elitesland.scp.domain.convert.stock.ScpPredictStStockConvert;
import com.elitesland.scp.domain.entity.stock.ScpPredictStStockDO;
import com.elitesland.scp.domain.entity.stock.ScpSafetyTargetStockDO;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockRepo;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockRepoProc;
import com.elitesland.scp.infr.repo.stock.ScpSafetyTargetStockRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-01-21
* @Version 1.0
**/
@RequiredArgsConstructor
@Service
@Slf4j
public class ScpPredictStStockServiceImpl  implements ScpPredictStStockService {

    private final ScpPredictStStockRepoProc scpPredictStStockRepoProc;

    private final ScpPredictStStockRepo scpPredictStStockRepo;

    private final ScpSafetyTargetStockRepo scpSafetyTargetStockRepo;


    @Override
    @Transactional
    public void saveBatch(List<ScpPredictStStockSaveVO> param) {
        long count = param.stream().map(d -> d.getOuId().toString() + d.getWhId().toString() + d.getItemId().toString())
                .distinct()
                .count();
        if(count != param.size()){
            throw new RuntimeException("公司仓库商品不能重复");
        }
        long stCount = param.stream().map(ScpPredictStStockSaveVO::getStId)
                .distinct()
                .count();
        if(stCount != param.size()){
            throw new RuntimeException("请选择同一批次数据");
        }
        List<ScpPredictStStockSaveVO> updateList = param.stream().filter(d -> d.getId() != null).collect(Collectors.toList());
        List<ScpPredictStStockSaveVO> createList = param.stream().filter(d -> d.getId() == null).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(createList)){
            List<String> businessIds = createList.stream().map(ScpPredictStStockSaveVO::getBusinessId).collect(Collectors.toList());
            List<ScpSafetyTargetStockDO> targetStockDOS = scpSafetyTargetStockRepo.findAllByBusinessIdIn(businessIds);
            Map<String, ScpSafetyTargetStockDO> stockDOMap;
            if(CollectionUtils.isNotEmpty(targetStockDOS)){
                stockDOMap = targetStockDOS.stream().collect(Collectors.toMap(ScpSafetyTargetStockDO::getBusinessId, v -> v, (e1, e2) -> e1));
            }else {
                stockDOMap = new HashMap<>();
            }
            List<Long> stIds = createList.stream().map(ScpPredictStStockSaveVO::getStId).collect(Collectors.toList());
            List<ScpPredictStStockDO> stStockDOS = createList.stream().map(d -> {
                if(stockDOMap.get(d.getBusinessId()) != null){
                    d.setSafetyQty(stockDOMap.get(d.getBusinessId()).getSafetyQty());
                    d.setTargetQty(stockDOMap.get(d.getBusinessId()).getTargetQty());
                }else{
                    d.setSafetyQty(BigDecimal.ZERO);
                    d.setTargetQty(BigDecimal.ZERO);
                }
                ScpPredictStStockDO scpPredictStStockDO = new ScpPredictStStockDO();
                ScpPredictStStockConvert.INSTANCE.copySaveVoToDo(d, scpPredictStStockDO);
                return scpPredictStStockDO;
            }).collect(Collectors.toList());
            List<ScpPredictStStockDO> predictStStockDOS = scpPredictStStockRepo.findAllByStIdInAndBusinessIdIn(stIds, businessIds);
            if(CollectionUtils.isNotEmpty(predictStStockDOS)){
                List<Long> ids = predictStStockDOS.stream().map(ScpPredictStStockDO::getId).collect(Collectors.toList());
                scpPredictStStockRepo.deleteAllById(ids);
            }
            scpPredictStStockRepo.saveAll(stStockDOS);
        }
        if(CollectionUtils.isNotEmpty(updateList)){
            List<Long> ids = updateList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            Map<Long, ScpPredictStStockSaveVO> stockSaveVOMap = updateList.stream().collect(Collectors.toMap(BaseViewModel::getId, v -> v));
            List<ScpPredictStStockDO> predictStStockDOS = scpPredictStStockRepo.findAllById(ids);
            predictStStockDOS.forEach(d ->{
                d.setPredSafetyQty(stockSaveVOMap.get(d.getId()).getPredSafetyQty());
                d.setPredTargetQty(stockSaveVOMap.get(d.getId()).getPredTargetQty());
            });
            scpPredictStStockRepo.saveAll(predictStStockDOS);
        }
    }

    @Override
    @Transactional
    public String update(List<ScpPredictStStockSaveVO> param) {
        long count = param.stream().filter(d -> d.getId() == null).count();
        if(count > 0){
            throw new RuntimeException("请选择需要更新的数据");
        }
        saveBatch(param);
        return "success";
    }

    @Override
    @Transactional
    public void delete(List<Long> ids) {
       scpPredictStStockRepo.deleteAllById(ids);
    }
}