package com.elitesland.scp.application.web.order;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDelParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDMgmtRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDMgmtSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDPriceSaveVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.utils.ValidatedList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Slf4j
@Api(tags = "订货订单明细接口")
@RestController
@RequestMapping(value = "/order/detail", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpDemandOrderDController {

    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDService scpDemandOrderDService;

    @ApiOperation("订货订单明细 - 查询订货订单明细")
    @GetMapping("/findIdOne/{masId}")
    public ApiResult<List<ScpDemandOrderDMgmtRespVO>> findIdOne(@PathVariable Long masId) {
        log.info("[SCP-DEMAND-ORDERD] findIdOne, masId ={}", masId);
        return ApiResult.ok(scpDemandOrderDService.findDemandOrderDByMasId(masId));
    }

    @PostMapping("/bath/save")
    @ApiOperation("订货订单明细 - 保存")
    public ApiResult<Long> batchSaveDemandOrderD(@RequestParam("masId") Long masId, @RequestBody @Validated ValidatedList<ScpDemandOrderDMgmtSaveVO> saveVOS) {
        log.info("[SCP-DEMAND-ORDERD] batchSaveDemandOrderD  saveVO ={}", JSONUtil.toJsonStr(saveVOS));
        ScpDemandOrderRespVO demandOrder = scpDemandOrderService.findDemandOrderById(masId).orElseThrow(new BusinessException("订货单数据不存在"));
        scpDemandOrderDService.batchSaveDemandOrderDMgmt(masId, demandOrder.getDemandWhStCode(), saveVOS, "PC");
//        scpDemandOrderService.autoPush(masId);
        return ApiResult.ok();
    }

    @PostMapping("/updatePrice")
    @ApiOperation("订货订单明细改价")
    public ApiResult<ScpDemandOrderDPriceRespVO> updatePrice(@RequestBody @Validated ScpDemandOrderDPriceSaveVO scpDemandOrderDPriceSaveVO) {
        log.info("[SCP-DEMAND-ORDERD] updatePrice saveVO ={}", JSONUtil.toJsonStr(scpDemandOrderDPriceSaveVO));
        ScpDemandOrderDPriceRespVO scpDemandOrderDPriceRespVO = scpDemandOrderDService.updatePrice(scpDemandOrderDPriceSaveVO);
        return ApiResult.ok(scpDemandOrderDPriceRespVO);
    }

    @ApiOperation("订货订单明细 - 删除订单明细")
    @PostMapping("/delete")
    public ApiResult<Object> deleteDetail(@RequestBody @Validated ScpDemandOrderDelParamVO paramVO) {
        log.info("[SCP-DEMAND-ORDERD] deleteDetail paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpDemandOrderDService.deleteByParam(paramVO);
        return ApiResult.ok();
    }

}
