package com.elitesland.scp.application.web.wqf;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyPageParam;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyPageVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountPageParam;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountPageVO;
import com.elitesland.scp.application.service.wqf.ScpWqfEntAccountService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 02月 28日 09:19
 * @version: 1.0
 */
@Slf4j
@Api(tags = "微企付账号")
@RestController
@RequestMapping("/wqf/ent-account")
@AllArgsConstructor
public class ScpWqfEntAccountController {

    private final ScpWqfEntAccountService scpWqfEntAccountService;


    @ApiOperation(value = "微企付-分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpWqfEntAccountPageVO>> page(@RequestBody ScpWqfEntAccountPageParam paramVO) {
        return ApiResult.ok(scpWqfEntAccountService.page(paramVO));
    }


    @PostMapping("/enable")
    @ApiOperation("启用")
    public ApiResult<Object> enable(@RequestBody List<Long> idList) {
        return ApiResult.ok(scpWqfEntAccountService.enable(idList));
    }

    @PostMapping("/disable")
    @ApiOperation("禁用")
    public ApiResult<Object> disable(@RequestBody List<Long> idList) {
        return ApiResult.ok(scpWqfEntAccountService.disable(idList));
    }


}
