package com.elitesland.scp.domain.entity.item;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("SCP商品价格")
public class ScpItemPriceDO implements Serializable {

    private static final long serialVersionUID = -6697939650444719776L;

    @ApiModelProperty("价格唯一标识ID")
    private Long id;

    @ApiModelProperty("查询结果标识，与入参的uuid对应")
    private String uuid;

    @ApiModelProperty(value = "价格类型")
    private String priceType;

    @ApiModelProperty(value = "价格类别")
    private String priceCls;

    @ApiModelProperty(value = "含税 价格")
    private BigDecimal price;

    @ApiModelProperty(value = "未税 价格")
    private BigDecimal netPrice;

    @ApiModelProperty(value = "商品编码")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品类型")
    private String itemType2;

    @ApiModelProperty(value = "基本计量单位")
    private String uom;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "货币码")
    private String currCode;

    @ApiModelProperty(value = "货币名称")
    private String currName;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime effectiveDatetime;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime expiryDatetime;

    @ApiModelProperty(value = "价格状态")
    private String priceStatus;

    /**
     * 市场价
     */
    @ApiModelProperty(value = "市场价")
    private BigDecimal price1;

    /**
     * B端指导价
     */
    @ApiModelProperty(value = "B端毛利控制率")
    private BigDecimal price2;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty("公司编号")
    private String ouCode;

}
