package com.elitesland.scp.domain.service.purLimit;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.purLimit.ScpPurLimitSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.purLimit.ScpPurLimitSettingStoreSaveVO;
import com.elitesland.scp.domain.convert.purLimit.ScpPurLimitSettingStoreConvert;
import com.elitesland.scp.domain.entity.purLimit.ScpPurLimitSettingStoreDO;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingStoreRepo;
import com.elitesland.scp.infr.repo.purLimit.ScpPurLimitSettingStoreRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpPurLimitSettingStoreDomainServiceImpl implements ScpPurLimitSettingStoreDomainService {
    private final EntityManager entityManager;
    private final ScpPurLimitSettingStoreRepo scpPurLimitSettingStoreRepo;
    private final ScpPurLimitSettingStoreRepoProc scpPurLimitSettingStoreRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpPurLimitSettingStoreRespVO> page(ScpPurLimitSettingStorePageParamVO paramVO) {
        long count = scpPurLimitSettingStoreRepoProc.countPurLimitSettingStore(paramVO);
        if (count > 0) {
            List<ScpPurLimitSettingStoreRespVO> storeRespVOList = scpPurLimitSettingStoreRepoProc.queryPurLimitSettingStore(paramVO);
            return new PagingVO<>(count, storeRespVOList);
        }
        return new PagingVO<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSavePurLimitSettingStore(List<ScpPurLimitSettingStoreSaveVO> saveVOS, int batchSize) {
        this.batchInsert(ScpPurLimitSettingStoreConvert.INSTANCE.saveVosDOS(saveVOS), batchSize);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        scpPurLimitSettingStoreRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpPurLimitSettingStoreRepo.deleteByIds(ids);
    }

    @Override
    public List<Long> findMasIdByStoreCode(String storeCode) {
        return scpPurLimitSettingStoreRepoProc.findMasIdByStoreCode(storeCode);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updatePurLimitNumByParam(List<Long> masIds, String storeCode) {
        scpPurLimitSettingStoreRepo.updateActiveNumByParam(masIds, storeCode);
    }

    @Override
    public List<ScpPurLimitSettingStoreRespVO> findByParam(ScpPurLimitSettingStoreParamVO paramVO) {
        return scpPurLimitSettingStoreRepoProc.findByParam(paramVO);
    }

    @Override
    public Long updatePurLimitSettingStore(ScpPurLimitSettingStoreSaveVO saveVO) {
        Optional<ScpPurLimitSettingStoreDO> option = scpPurLimitSettingStoreRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("订货强配门店ID：" + saveVO.getId() + "不存在");
        }
        ScpPurLimitSettingStoreDO scpPurLimitSettingDO = option.get();
        ScpPurLimitSettingStoreConvert.INSTANCE.copySaveParamToDo(saveVO, scpPurLimitSettingDO);
        return scpPurLimitSettingStoreRepo.save(scpPurLimitSettingDO).getId();
    }

    @Override
    @SysCodeProc
    public List<ScpPurLimitSettingStoreRespVO> findByMasId(Long masId) {
        List<ScpPurLimitSettingStoreDO> settingStoreDOS = scpPurLimitSettingStoreRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingStoreDOS)) {
            return ScpPurLimitSettingStoreConvert.INSTANCE.dosToRespVOS(settingStoreDOS);
        }
        return new ArrayList<>();
    }

    @Override
    public List<ScpPurLimitSettingStoreRespVO> findEnabledByParam(ScpPurLimitSettingStoreParamVO paramVO) {
        return scpPurLimitSettingStoreRepoProc.findEnabledByParam(paramVO);
    }

    public void batchInsert(List<ScpPurLimitSettingStoreDO> dataList, int batchSize) {
        int index = 0;
        for (ScpPurLimitSettingStoreDO data : dataList) {
            entityManager.persist(data);
            if (batchSize > 1) {
                // 开启批量
                index++;
                if (index % batchSize == 0) {
                    entityManager.flush();
                    entityManager.clear();
                }
            }
        }
        if (!dataList.isEmpty()) {
            entityManager.flush();
        }
    }
}
