package com.elitesland.scp.infr.repo.calendar;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.*;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.domain.entity.calendar.QScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.val;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: jeesie.jiang
 * @create: 2024-03-28
 * @Version 1.0
 **/
@Component
public class ScpStoreDemandCalendarRepoProc extends BaseRepoProc<ScpStoreDemandCalendarDO> {

    private static final QScpStoreDemandCalendarDO jpaQDo = QScpStoreDemandCalendarDO.scpStoreDemandCalendarDO;

    public ScpStoreDemandCalendarRepoProc() {
        super(jpaQDo);
    }

    private final QBean<ScpStoreDemandCalendarDTO> demandCalendarList = Projections.bean(
            ScpStoreDemandCalendarDTO.class,
            jpaQDo.id,
            jpaQDo.type,
            jpaQDo.year,
            jpaQDo.month,
            jpaQDo.day,
            jpaQDo.workStatus,
            jpaQDo.storeId,
            jpaQDo.storeCode,
            jpaQDo.storeName,
            jpaQDo.deliveryType
    );


    public PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO param) {
        JPAQuery<ScpStoreDemandCalendarPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreDemandCalendarPageVO.class,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.storeId,
                jpaQDo.year,
                jpaQDo.month,
                jpaQDo.type,
                jpaQDo.deliveryType
        )).distinct().from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.orderBy(jpaQDo.year.desc(), jpaQDo.month.desc());
        param.setPaging(jpaQuery);
        return PagingVO.<ScpStoreDemandCalendarPageVO>builder()
                .total(getCount(param))
                .records(jpaQuery.fetch())
                .build();
    }


    private Long getCount(ScpStoreDemandCalendarPageParamVO param) {
        val jpaQuery = jpaQueryFactory.selectDistinct(
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.storeId,
                jpaQDo.year,
                jpaQDo.month,
                jpaQDo.type,
                jpaQDo.deliveryType
        ).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return Long.valueOf(jpaQuery.fetch().size());
    }

    public Predicate where(ScpStoreDemandCalendarPageParamVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (StringUtils.isNotEmpty(param.getType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.type.eq(param.getType()));
        }
        if (StringUtils.isNotEmpty(param.getStoreCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeCode.eq(param.getStoreCode()));
        }
        if (Objects.nonNull(param.getStoreId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeId.eq(param.getStoreId()));
        }
        if (!CollectionUtils.isEmpty(param.getStoreIdList())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeId.in(param.getStoreIdList()));
        }
        if (!CollectionUtils.isEmpty(param.getDeliveryTypes())) {
            Predicate deliveryTypePredicate = Expressions.ONE.ne(Expressions.ONE);
            for (String deliveryType : param.getDeliveryTypes()) {
                deliveryTypePredicate = ExpressionUtils.or(deliveryTypePredicate, jpaQDo.deliveryType.like("%" + deliveryType + "%"));
            }
            predicate = ExpressionUtils.and(predicate, deliveryTypePredicate);
        }
        if (param.getStartDate() != null) {
            String year = String.valueOf(param.getStartDate().getYear());

            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getStartDate().format(formatter);
//            String day = String.valueOf(param.getStartDate().getDayOfMonth());
            predicate = ExpressionUtils.and(predicate, jpaQDo.year.goe(year)
                    .and(jpaQDo.month.goe(month)));

        }
        if (param.getEndDate() != null) {
            String year = String.valueOf(param.getEndDate().getYear());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getEndDate().format(formatter);
//            String day = String.valueOf(param.getEndDate().getDayOfMonth());
            predicate = ExpressionUtils.and(predicate, jpaQDo.year.loe(year)
                    .and(jpaQDo.month.loe(month)));
        }
        if (Boolean.TRUE.equals(param.getScpmanAuthority())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeCode.in(param.getStores()));
        }
        if (param.getFilterDate() != null) {
            String year = String.valueOf(param.getFilterDate().getYear());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getFilterDate().format(formatter);
            predicate = ExpressionUtils.and(predicate, jpaQDo.year.eq(year).and(jpaQDo.month.eq(month)));
        }
        return predicate;
    }

    public List<ScpStoreDemandCalendarDTO> findStoreCalendarByParam(ScpStoreDemandCalendarParamVO param) {
        JPAQuery<ScpStoreDemandCalendarDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpStoreDemandCalendarDTO.class,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.storeId,
                jpaQDo.year,
                jpaQDo.month,
                jpaQDo.type,
                jpaQDo.day,
                jpaQDo.id,
                jpaQDo.workStatus,
                jpaQDo.createTime,
                jpaQDo.modifyTime,
                jpaQDo.deliveryType
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.orderBy(jpaQDo.year.desc(), jpaQDo.month.desc(), jpaQDo.day.asc());
        return jpaQuery.fetch();
    }

    public Predicate where(ScpStoreDemandCalendarParamVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (StringUtils.isNotEmpty(param.getType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.type.eq(param.getType()));
        }
        if (StringUtils.isNotEmpty(param.getStoreCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeCode.eq(param.getStoreCode()));
        }
        if (StringUtils.isNotEmpty(param.getYear())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.year.eq(param.getYear()));
        }
        if (StringUtils.isNotEmpty(param.getMonth())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.month.eq(param.getMonth()));
        }
        if (StringUtils.isNotEmpty(param.getDeliveryType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deliveryType.eq(param.getDeliveryType()));
        }
        return predicate;
    }


    public List<ScpStoreDemandCalendarDTO> findDemandCalendarByParam(ScpStoreDemandCalendarParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(demandCalendarList)
                .from(jpaQDo);
        jpaQuery.where(this.whereDemandCalendar(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereDemandCalendar(ScpStoreDemandCalendarParam paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(jpaQDo.type.eq(paramVO.getType()));
        }
        if (Objects.nonNull(paramVO.getStoreCode())) {
            predicates.add(jpaQDo.storeCode.eq(paramVO.getStoreCode()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getStoreCodeList())) {
            predicates.add(jpaQDo.storeCode.in(paramVO.getStoreCodeList()));
        }
        if (Objects.nonNull(paramVO.getWorkStatus())) {
            predicates.add(jpaQDo.workStatus.eq(paramVO.getWorkStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getYear())) {
            predicates.add(jpaQDo.year.eq(paramVO.getYear()));
        }
        if (StrUtil.isNotBlank(paramVO.getMonth())) {
            predicates.add(jpaQDo.month.eq(paramVO.getMonth()));
        }
        if (StrUtil.isNotBlank(paramVO.getDay())) {
            predicates.add(jpaQDo.day.eq(paramVO.getDay()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScpCalendarStoreRespVO> listStoreByQueryParam(ScpCalendarStoreQueryParamVO param) {
        JPAQuery<ScpCalendarStoreRespVO> jpaQuery = jpaQueryFactory.selectDistinct(Projections.bean(ScpCalendarStoreRespVO.class,
                jpaQDo.storeCode,
                jpaQDo.storeName,
                jpaQDo.storeId,
                jpaQDo.type
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(whereDemandCalendar(param));
        }
        return jpaQuery.fetch();
    }

    private Predicate whereDemandCalendar(ScpCalendarStoreQueryParamVO param) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(Expressions.ONE.eq(Expressions.ONE));
        if (StringUtils.isNotEmpty(param.getWorkStatus())) {
            predicates.add(jpaQDo.workStatus.eq(param.getWorkStatus()));
        }
        if (param.getFindDate() != null) {
            String year = String.valueOf(param.getFindDate().getYear());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getFindDate().format(formatter);
            DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("d");
            String day = param.getFindDate().format(dayFormatter);
            predicates.add(jpaQDo.year.eq(year).and(jpaQDo.month.eq(month)).and(jpaQDo.day.eq(day)));
        }
        return ExpressionUtils.allOf(predicates);
    }
    public void deleteByStoreAndYear(String type, List<String> storeCodes, String year) {
        jpaQueryFactory.delete(jpaQDo)
                .where(jpaQDo.storeCode.in(storeCodes)
                        .and(jpaQDo.year.eq(year))
                        .and(jpaQDo.type.eq(type))
                ).execute();
    }
    public void deleteByStoreAndYearAndDeliveryType(String type, List<String> storeCodes, String year, String deliveryType) {
        String []deliveryTypeList = deliveryType.split(",");
        jpaQueryFactory.delete(jpaQDo)
                .where(jpaQDo.storeCode.in(storeCodes)
                        .and(jpaQDo.year.eq(year))
                        .and(jpaQDo.type.eq(type))
                        .and(jpaQDo.deliveryType.in(deliveryTypeList))
                ).execute();
    }

    public void deleteByStoreAndYearAndMonth(String type, List<String> storeCodes, String year, String month) {
        jpaQueryFactory.delete(jpaQDo)
                .where(jpaQDo.storeCode.in(storeCodes)
                        .and(jpaQDo.year.eq(year))
                        .and(jpaQDo.month.eq(month))
                        .and(jpaQDo.type.eq(type))
                ).execute();
    }
    public void deleteByStoreAndYearAndMonthAndDeliveryType(String type, List<String> storeCodes, String year, String month, String deliveryType) {
        String[] deliveryTypeList = deliveryType.split(",");
        jpaQueryFactory.delete(jpaQDo)
                .where(jpaQDo.storeCode.in(storeCodes)
                        .and(jpaQDo.year.eq(year))
                        .and(jpaQDo.month.eq(month))
                        .and(jpaQDo.type.eq(type))
                        .and(jpaQDo.deliveryType.in(deliveryTypeList))
                ).execute();
    }
//    public boolean isCanDelivery(String storeCode, String region, String deliveryType, String year, String month, String day) {
//        // 先看门店的符合条件的数量，type是否有数据，没数据的话，再看区域
//        JPAQuery<ScpCalendarStoreRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpCalendarStoreRespVO.class,
//                jpaQDo.storeCode,
//                jpaQDo.storeName,
//                jpaQDo.storeId,
//                jpaQDo.type
//        )).from(jpaQDo)
//        .where(((jpaQDo.storeCode.eq(storeCode).or(jpaQDo.storeCode.eq(storeCode)))
//                .and(jpaQDo.year.eq(year))
//                .and(jpaQDo.month.eq(month))
//                .and(jpaQDo.day.eq(day))
//                .and(jpaQDo.deliveryType.like("%" + deliveryType + "%"))));
//        if(jpaQuery.fetchCount() > 0){
//            return jpaQuery.fetch().get(0).getType().equals("W");
//        }
//        // 再看区域
//        Long count = jpaQueryFactory.selectOne()
//                .from(jpaQDo)
//                .where((jpaQDo.storeCode.eq(storeCode).or(jpaQDo.storeCode.eq(region)))
//                        .and(jpaQDo.year.eq(year))
//                        .and(jpaQDo.month.eq(month))
//                        .and(jpaQDo.day.eq(day))
//                        .and(jpaQDo.deliveryType.like("%" + deliveryType + "%"))
//                        .and(jpaQDo.type.eq("W")))
//                .fetchCount();
//        return count > 0;
//    }
    public Map<String, Boolean> isCanDelivery(String storeCode, String region, List<String> deliveryTypes, String year, String month, String day) {
        // 先映射区域，再映射门店
        Map<String, Boolean> resultMap = new HashMap<>();
        if (region != null) {
            JPAQuery<ScpCalendarStoreRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpCalendarStoreRespVO.class,
                            jpaQDo.storeCode,
                            jpaQDo.storeName,
                            jpaQDo.storeId,
                            jpaQDo.type,
                            jpaQDo.deliveryType,
                            jpaQDo.workStatus
                    )).from(jpaQDo)
                    .where(((jpaQDo.storeCode.eq(region))
                            .and(jpaQDo.year.eq(year))
                            .and(jpaQDo.month.eq(month))
                            .and(jpaQDo.day.eq(day))
                            .and(jpaQDo.type.eq("REGION"))
                            .and(jpaQDo.deliveryType.in(deliveryTypes))
                    ));
            Map<String, String> regionMap = jpaQuery.fetch().stream()
                    .collect(Collectors.toMap(ScpCalendarStoreRespVO::getDeliveryType, ScpCalendarStoreRespVO::getWorkStatus, (t1, t2) -> t1));
            resultMap.putAll(regionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().equals("W"))));
        }

        // 再看门店
        if (storeCode != null) {
            JPAQuery<ScpCalendarStoreRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpCalendarStoreRespVO.class,
                            jpaQDo.storeCode,
                            jpaQDo.storeName,
                            jpaQDo.storeId,
                            jpaQDo.type,
                            jpaQDo.deliveryType,
                            jpaQDo.workStatus
                    )).from(jpaQDo)
                    .where(((jpaQDo.storeCode.eq(storeCode))
                            .and(jpaQDo.year.eq(year))
                            .and(jpaQDo.month.eq(month))
                            .and(jpaQDo.day.eq(day))
                            .and(jpaQDo.type.eq("STORE"))
                            .and(jpaQDo.deliveryType.in(deliveryTypes))
                    ));
            Map<String, String> storeMap = jpaQuery.fetch().stream().collect(Collectors.toMap(ScpCalendarStoreRespVO::getDeliveryType, ScpCalendarStoreRespVO::getWorkStatus, (t1, t2) -> t1));
            resultMap.putAll(storeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().equals("W"))));
        }
        return resultMap;
    }

    public List<ScpStoreDemandCalendarDO> findByUniqueKeys(List<String> deliveryTypeList, String type, String code, String year, String month, String day) {
        JPAQuery<ScpStoreDemandCalendarDO> jpaQuery = jpaQueryFactory.select(jpaQDo)
                .from(jpaQDo)
                .where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        if (deliveryTypeList != null && !deliveryTypeList.isEmpty()) {
            jpaQuery.where(jpaQDo.deliveryType.in(deliveryTypeList));
        } else {
            jpaQuery.where(jpaQDo.deliveryType.isNull());
        }
        if (type != null) {
            jpaQuery.where(jpaQDo.type.eq(type));
        } else {
            jpaQuery.where(jpaQDo.type.isNull());
        }
        if (code != null) {
            jpaQuery.where(jpaQDo.storeCode.eq(code));
        } else {
            jpaQuery.where(jpaQDo.storeCode.isNull());
        }
        if (year != null) {
            jpaQuery.where(jpaQDo.year.eq(year));
        } else {
            jpaQuery.where(jpaQDo.year.isNull());
        }
        if (month != null) {
            jpaQuery.where(jpaQDo.month.eq(month));
        } else {
            jpaQuery.where(jpaQDo.month.isNull());
        }
        if (day != null) {
            jpaQuery.where(jpaQDo.day.eq(day));
        } else {
            jpaQuery.where(jpaQDo.day.isNull());
        }
        return jpaQuery.fetch();
    }


    public List<ScpStoreDemandCalendarDO> findByConcatYearAndMonthAndDeliveryTypeKey(Collection<String> typeSet,
                                                                                     Collection<String> storeCodeSet,
                                                                                     Collection<String> yearSet,
                                                                                     Collection<String> monthSet,
                                                                                     Collection<String> deliverySet) {
        JPAQuery<ScpStoreDemandCalendarDO> jpaQuery = jpaQueryFactory.select(jpaQDo)
                .from(jpaQDo)
                .where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        if (deliverySet != null && !deliverySet.isEmpty()) {
            jpaQuery.where(jpaQDo.deliveryType.in(deliverySet));
        } else {
            jpaQuery.where(jpaQDo.deliveryType.isNull());
        }

        if (typeSet != null && !typeSet.isEmpty()) {
            jpaQuery.where(jpaQDo.type.in(typeSet));
        } else {
            jpaQuery.where(jpaQDo.type.isNull());
        }

        if (storeCodeSet != null && !storeCodeSet.isEmpty()) {
            jpaQuery.where(jpaQDo.storeCode.in(storeCodeSet));
        } else {
            jpaQuery.where(jpaQDo.storeCode.isNull());
        }

        if (yearSet != null && !yearSet.isEmpty()) {
            jpaQuery.where(jpaQDo.year.in(yearSet));
        } else {
            jpaQuery.where(jpaQDo.year.isNull());
        }

        if (monthSet != null && !monthSet.isEmpty()) {
            jpaQuery.where(jpaQDo.month.in(monthSet));
        } else {
            jpaQuery.where(jpaQDo.month.isNull());
        }
        return jpaQuery.fetch();
    }
}