package com.elitesland.scp.infr.repo.mrp;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseRefParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseRefVO;
import com.elitesland.scp.domain.entity.mrp.QScpThousandUseDO;
import com.elitesland.scp.domain.entity.mrp.QScpThousandUseRefDO;
import com.elitesland.scp.domain.entity.mrp.ScpThousandUseRefDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 千元用量商品关联
 *
 * @author wangly
 * @date 2025-03-29
 */
@Repository
@RequiredArgsConstructor
public class ScpThousandUseRefRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final ScpThousandUseRefRepo repo;

    private final QScpThousandUseRefDO qdo = QScpThousandUseRefDO.scpThousandUseRefDO;
    private final QScpThousandUseDO qScpThousandUseDO = QScpThousandUseDO.scpThousandUseDO;


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ScpThousandUseRefVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ScpThousandUseRefVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 主表id
                qdo.masId,
                // 商品id
                qdo.itemId,
                // 类型
                qdo.itemType,
                // 商品编码
                qdo.itemCode,
                // 商品名称
                qdo.itemName,
                // 商品规格
                qdo.itemAttr,
                qdo.itemStatus,
                qdo.uom,
                // 商品辅助单位 [UDC]COM:UOM
                qdo.uom2,
                // 预估千元用量
                qdo.estimateThousNum,
                // 调整千元用量
                qdo.adjustThousNum,
                qdo.ext1,
                qdo.ext2,
                qdo.ext3,
                // 门店id
                qScpThousandUseDO.stWhId,
                // 门店编码
                qScpThousandUseDO.stWhCode,
                // 门店名称
                qScpThousandUseDO.stWhName,
                // 参考开始时间
                qScpThousandUseDO.referenceDataEnd,
                // 参考结束时间
                qScpThousandUseDO.referenceDataStart,
                // 有效开始时间
                qScpThousandUseDO.validDataStart,
                // 有效结束时间
                qScpThousandUseDO.validDataEnd
        )).from(qdo).leftJoin(qScpThousandUseDO).on(qdo.masId.eq(qScpThousandUseDO.id));
    }

    /**
     * 拼装查询条件
     *
     * @param param 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ScpThousandUseRefVO> getJpaQueryWhere(ScpThousandUseRefParam param) {
        JPAQuery<ScpThousandUseRefVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(param));
        jpaQuery.orderBy(qdo.createTime.desc());
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ScpThousandUseRefParam query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo).leftJoin(qScpThousandUseDO).on(qdo.masId.eq(qScpThousandUseDO.id));
        jpaQuery.where(where(query));
        long total = jpaQuery.fetchOne();
        return total;
    }


    /**
     * 查询条件封装
     *
     * @param param 条件
     * @return {@link Predicate}
     */
    private Predicate where(ScpThousandUseRefParam param){
        List<Predicate> list = new ArrayList<>();
        list.add(qdo.deleteFlag.eq(0));
        list.add(qScpThousandUseDO.deleteFlag.eq(0));
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(param.getId())) {
            list.add(qdo.id.eq(param.getId()));
        }
        /** 主表id 精确 */
        if (!ObjectUtils.isEmpty(param.getMasId())) {
            list.add(qdo.masId.eq(param.getMasId()));
        }
        /** 主表id集合 精确 */
        if (!CollectionUtils.isEmpty(param.getMasIdList())) {
            list.add(qdo.masId.in(param.getMasIdList()));
        }
        /** 商品id 精确 */
        if (!ObjectUtils.isEmpty(param.getItemId())) {
            list.add(qdo.itemId.eq(param.getItemId()));
        }
        /** 类型 精确 */
        if (!ObjectUtils.isEmpty(param.getItemType())) {
            list.add(qdo.itemType.eq(param.getItemType()));
        }
        /** 商品编码 精确 */
        if (!ObjectUtils.isEmpty(param.getItemCode())) {
            list.add(qdo.itemCode.eq(param.getItemCode()));
        }
        /** 商品名称 精确 */
        if (!ObjectUtils.isEmpty(param.getItemName())) {
            list.add(qdo.itemName.eq(param.getItemName()));
        }
        /** 商品规格 精确 */
        if (!ObjectUtils.isEmpty(param.getItemAttr())) {
            list.add(qdo.itemAttr.eq(param.getItemAttr()));
        }
        /** 商品状态 精确 */
        if (!ObjectUtils.isEmpty(param.getItemStatus())) {
            list.add(qdo.itemStatus.eq(param.getItemStatus()));
        }
        /** 商品基本单位 [UDC]COM:UOM 精确 */
        if (!ObjectUtils.isEmpty(param.getUom())) {
            list.add(qdo.uom.eq(param.getUom()));
        }
        /** 商品辅助单位 [UDC]COM:UOM 精确 */
        if (!ObjectUtils.isEmpty(param.getUom2())) {
            list.add(qdo.uom2.eq(param.getUom2()));
        }

        /** 预估千元用量 精确 */
        if (!ObjectUtils.isEmpty(param.getEstimateThousNum())) {
            list.add(qdo.estimateThousNum.eq(param.getEstimateThousNum()));
        }
        /** 调整千元用量 精确 */
        if (!ObjectUtils.isEmpty(param.getAdjustThousNum())) {
            list.add(qdo.adjustThousNum.eq(param.getAdjustThousNum()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(param.getExt1())) {
            list.add(qdo.ext1.eq(param.getExt1()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(param.getExt2())) {
            list.add(qdo.ext2.eq(param.getExt2()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(param.getExt3())) {
            list.add(qdo.ext3.eq(param.getExt3()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ScpThousandUseRefVO queryByKey(Long id) {
        JPAQuery<ScpThousandUseRefVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param param 查询参数
     * @return 结果集合
     */
    public List<ScpThousandUseRefVO> queryListDynamic(ScpThousandUseRefParam param) {
        JPAQuery<ScpThousandUseRefVO> jpaQuery = getJpaQueryWhere(param);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param param 查询参数
     * @return 分页结果
     */
    public PagingVO<ScpThousandUseRefVO> queryPaging(ScpThousandUseRefParam param) {
        long total = count(param);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<ScpThousandUseRefVO> jpaQuery = getJpaQueryWhere(param);
        List<ScpThousandUseRefVO> result = jpaQuery
                .offset(param.getPageRequest().getOffset())
                .limit(param.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ScpThousandUseRefVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ScpThousandUseRefDO save(ScpThousandUseRefDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ScpThousandUseRefDO> saveAll(List<ScpThousandUseRefDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param param 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ScpThousandUseRefParam param) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(param.getId()));
        // 记录唯一ID
        if (param.getId() != null) {
            update.set(qdo.id, param.getId());
        }
        // 主表id
        if (param.getMasId() != null) {
            update.set(qdo.masId, param.getMasId());
        }
        // 商品id
        if (param.getItemId() != null) {
            update.set(qdo.itemId, param.getItemId());
        }
        // 类型
        if (param.getItemType() != null) {
            update.set(qdo.itemType, param.getItemType());
        }
        // 商品编码
        if (param.getItemCode() != null) {
            update.set(qdo.itemCode, param.getItemCode());
        }
        // 商品名称
        if (param.getItemName() != null) {
            update.set(qdo.itemName, param.getItemName());
        }
        // 商品规格
        if (param.getItemAttr() != null) {
            update.set(qdo.itemAttr, param.getItemAttr());
        }
        // 商品规格
        if (param.getItemStatus() != null) {
            update.set(qdo.itemStatus, param.getItemStatus());
        }
        // 商品基本单位 [UDC]COM:UOM
        if (param.getUom() != null) {
            update.set(qdo.uom, param.getUom());
        }
        // 商品辅助单位 [UDC]COM:UOM
        if (param.getUom2() != null) {
            update.set(qdo.uom2, param.getUom2());
        }
        // 预估千元用量
        if (param.getEstimateThousNum() != null) {
            update.set(qdo.estimateThousNum, param.getEstimateThousNum());
        }
        // 调整千元用量
        if (param.getAdjustThousNum() != null) {
            update.set(qdo.adjustThousNum, param.getAdjustThousNum());
        }
        if (param.getExt1() != null) {
            update.set(qdo.ext1, param.getExt1());
        }
        if (param.getExt2() != null) {
            update.set(qdo.ext2, param.getExt2());
        }
        if (param.getExt3() != null) {
            update.set(qdo.ext3, param.getExt3());
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));

        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param masIdList 主集合
     * @return 删除的行数
     */
    public long deleteSoftByMasId(List<Long> masIdList) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.masId.in(masIdList));
        return update.execute();
    }
}

