package com.elitesland.scp.provider.order;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.dto.order.*;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.param.ScpDemandOrderRpcParam;
import com.elitesland.scp.service.order.ScpDemandOrderRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

@Slf4j
@Service
@RestController
@RequiredArgsConstructor
@RequestMapping(ScpApplication.URI_PREFIX + ScpDemandOrderRpcService.PATH)
public class ScpDemandOrderRpcServiceImpl implements ScpDemandOrderRpcService {

    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;

    @Override
    public ApiResult<ScpDemandOrderRpcDTO> findById(Long id) {
        if (id == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "id不能为空");
        }
        Optional<ScpDemandOrderDTO> orderOptional = scpDemandOrderDomainService.findDemandOrderById(id);
        if (orderOptional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "订货单不存在");
        }

        return ApiResult.ok(ScpDemandOrderConvert.INSTANCE.dto2RpcDTO(orderOptional.get()));
    }

    @Override
    @Transactional
    public ApiResult<Long> updateAccAmt(ScpDemandOrderRpcParam param) {
        if (param == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "参数不能为空");
        }
        if (param.getId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "id不能为空");
        }
        if (param.getCreditAccAmt() == null && param.getFlzhAccAmt() == null && param.getStoreAccAmt() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "订货单账户支付金额不能全部为空");
        }
        scpDemandOrderRepoProc.updateAccAmt(param);
        return ApiResult.ok(param.getId());
    }

    @Override
    @Transactional
    public ApiResult<Object> updatePayStatus(ScpDemandOrderRpcParam param) {
        log.info("更新订货单支付状态开始：{}", JSONObject.toJSONString(param));
        if (param.getId() == null && StringUtils.isBlank(param.getDocCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "订货单id和编码不能同时为空");
        }
        if (param.getId() == null) {
            Long id = scpDemandOrderRepoProc.findIdByCode(param.getDocCode());
            if (id == null) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "订货单不存在");
            }
            param.setId(id);
        }

        scpDemandOrderRepoProc.updatePayStatus(param);

        scpDemandOrderDRepoProc.updatePayStatusByMasId(param.getId(), param.getPayStatus());
        log.info("更新订货单支付状态结束");
        return ApiResult.ok();
    }

    @Override
    public ApiResult<List<String>> findCodeByPayStatus(String payStatus) {
        log.info("根据支付状态查询订货单开始：{}", payStatus);
        if (StringUtils.isBlank(payStatus)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "支付状态不能为空");
        }
        log.info("根据支付状态查询订货单结束：{}", payStatus);
        return ApiResult.ok(scpDemandOrderRepoProc.findCodeByPayStatus(payStatus));
    }

    @Override
    public ApiResult<Boolean> autoRecvFlag(Long troId) {
        if(scpDemandOrderRepoProc.existRecvOrderByTroId(troId)){
            return ApiResult.ok(false);
        }else{
            return ApiResult.ok(true);
        }
    }
}
