package com.elitesland.scp.provider.whnet;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationSaveVO;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.inv.ScpWhNetRelationConvert;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.param.ScpWhNetRelationParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcSaveVO;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.scp.service.whnet.ScpWhNetRelationProvider;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 22日 11:58
 * @version: 1.0
 */
@Service
@RequiredArgsConstructor
@RestController
@RequestMapping(ScpApplication.URI_PREFIX + ScpWhNetRelationProvider.PATH)
@Slf4j
public class ScpWhNetRelationProviderImpl implements ScpWhNetRelationProvider {

    private final ScpWhNetRelationService scpWhNetRelationService;

    private final RmiOrgOuService rmiOrgOuService;


    @Override
    public List<ScpWhNetRelationRpcDTO> findWhNetRelationRpcDtoByParam(ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam) {
        return scpWhNetRelationService.findWhNetRelationRpcDtoByParam(scpWhNetRelationRpcDtoParam);
    }

    @Override
    public List<ScpWhNetRelationRpcDTO> outFindWhNetRelationRpcDtoByParam(ScpWhNetRelationParam whNetRelationParam) {
        return scpWhNetRelationService.outFindWhNetRelationRpcDtoByParam(whNetRelationParam);
    }

    @Override
    @Transactional
    public ApiResult<String> batchSaveWhNetRelation(List<ScpWhNetRelationRpcSaveVO> saveVOList) {
        log.info("批量保存仓网供应链关系，参数：{}", JSON.toJSONString(saveVOList));
        if (CollectionUtils.isEmpty(saveVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "仓网供应链关系不能为空");
        }
        List<ScpWhNetRelationSaveVO.ScpWhNetRelation> scpWhNetRelations = ScpWhNetRelationConvert.INSTANCE.rpcToSaveVo(saveVOList);

        List<String> ouCodes = scpWhNetRelations.stream().map(ScpWhNetRelationSaveVO.ScpWhNetRelation::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuService.findOuDtoMapByOuCodes(ouCodes);

        scpWhNetRelations.forEach(scpWhNetRelation -> {
            if (scpWhNetRelation != null && scpWhNetRelation.getDeliveryType() != null) {
                if (ScpConstant.PUR_DELIVERY_TYPES.contains(scpWhNetRelation.getDeliveryType())) {
                    // 如果配送类型是 直送、甲指乙采、水果，则采购公司赋值，销售公司为空
                    // 采购公司赋值
                    scpWhNetRelation.setPurCompanyCode(scpWhNetRelation.getOuCode());
                    if (ouMap.containsKey(scpWhNetRelation.getOuCode())) {
                        scpWhNetRelation.setPurCompanyName(ouMap.get(scpWhNetRelation.getOuCode()).getOuName());
                    }
                    // 销售公司为空
                    scpWhNetRelation.setOuCode(null);
                    scpWhNetRelation.setOuName(null);
                }
            }
        });
        ScpWhNetRelationSaveVO scpWhNetRelationSaveVO = new ScpWhNetRelationSaveVO();
        scpWhNetRelationSaveVO.setScpWhNetRelations(scpWhNetRelations);
        scpWhNetRelationService.saveWhNetRelation(scpWhNetRelationSaveVO);
        log.info("批量保存仓网供应链关系，结果：{}", JSON.toJSONString(scpWhNetRelationSaveVO));
        return ApiResult.ok();
    }
}
