package com.elitesland.scp.application.facade.vo.param.order;


import com.elitesland.scp.common.PartitionQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serial;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

@Data
@ApiModel(value = "订货订单查询参数")
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ScpDemandOrderPageParamVO extends ScpsmanAuthQueryParam {
    @Serial
    private static final long serialVersionUID = 2040252488341862849L;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货单编码")
    private String docCode;

    @ApiModelProperty("单据状态")
    private String docStatus;

    @ApiModelProperty("单据状态集合")
    private List<String> docStatusList;

    @ApiModelProperty("门店编码/仓库编码")
    private String demandWhStCode;

    @ApiModelProperty("供应仓库编码")
    private String suppWhCode;

    @ApiModelProperty("需求日期开始")
    private LocalDateTime demandDateFrom;

    @ApiModelProperty("需求日期结束")
    private LocalDateTime demandDateTo;

    @ApiModelProperty(name = "商品编码")
    private List<String> itemCodes;

    @ApiModelProperty("门店编码/仓库编码集合")
    private List<String> demandWhStCodes;

    @ApiModelProperty("供应仓库编码集合")
    private List<String> suppWhCodes;

    @ApiModelProperty(name = "供应类型")
    private String supplyType;

    @ApiModelProperty(name = "是否已行维度")
    private Boolean isHeader = Boolean.FALSE;

    @ApiModelProperty(name = "付款状态,待支付：WAIT_PAY，已付款：PAYED，无需支付：NO_PAY")
    private String payStatus;

    @ApiModelProperty(name = "单据类型")
    private String docType;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("业务类型列表")
    private List<String> businessTypes;

    @ApiModelProperty("付款状态集合")
    private List<String> payStatusList;

    @ApiModelProperty("单据类型集合")
    private List<String> docTypeList;

    @ApiModelProperty("是否评价，true：已评价，false：未评价")
    private Boolean replyFlag;

    private String username;

    @ApiModelProperty("创建人id")
    private Long createUserId;

    @ApiModelProperty(value = "创建人id")
    private Long creatorId;

    @ApiModelProperty("创建日期开始")
    private LocalDateTime createTimeFrom;

    @ApiModelProperty("创建日期结束")
    private LocalDateTime createTimeTo;

    private List<Long> authIds;

    @ApiModelProperty(value = "审批状态")
    private String apprStatus;
    @ApiModelProperty(value = "装修门店编码List")
    private List<String> buildStoreCodeList;
}
