/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.pur.dto.PurPurcPriceRpcDTO;
import com.elitesland.pur.dto.supp.PurItemPriceParamRpcDTO;
import com.elitesland.pur.provider.PurPriceProvider;
import com.elitesland.scp.application.enums.ScpUdcEnum;
import com.elitesland.scp.application.facade.vo.param.app.AddressParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppInvStkRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiPriceRpcService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.ItmItemSuppSimpleRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemSuppRegionRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmBomPriceRpcDtoParam;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class CommonPriceServiceImpl
implements CommonPriceService {
    private static final Logger log = LoggerFactory.getLogger(CommonPriceServiceImpl.class);
    @Autowired
    @Qualifier(value="cloudt_taskExecutor")
    private TaskExecutor taskExecutor;
    private final RmiPriceRpcService rmiPriceRpcService;
    private final RmiItemService rmiItemService;
    private final ScpSupplyAllocationService scpSupplyAllocationService;
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpServiceConfigService serviceConfigService;
    private final ItmItemRpcService itmItemRpcService;
    private final PurPriceProvider purPriceProvider;

    @Override
    public Map<String, List<PriPriceRpcDTO>> getPriceAndStockDetails(List<AppItemActivityItemPriceParamVO> paramVOList, String storeCode, ScpOrderSettingRespVO orderSetting, String type, AtomicReference<Map<String, BigDecimal>> stockMap) {
        CopyOnWriteArrayList priceList = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        ArrayList<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<ItmPriPriceRpcDtoParam>();
        List<ScpStoreCartDO> dataList = paramVOList.stream().map(row -> {
            ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
            storeCartDO.setItemCode(row.getItemCode());
            storeCartDO.setItemCateCode(row.getItemCateCode());
            return storeCartDO;
        }).collect(Collectors.toList());
        Integer pricePlace = SysUtils.getPricePlace();
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.scpWhNetRelationService.findNewWhNetByParam(storeCode, type, dataList);
        List<String> itemCodes = paramVOList.stream().map(AppItemActivityItemPriceParamVO::getItemCode).distinct().collect(Collectors.toList());
        Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap = this.scpSupplyAllocationService.findSupplyAllocationByParam(storeCode, type, itemCodes);
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());
        ArrayList<AppInvStkRespVO> suppPriorityList = new ArrayList<AppInvStkRespVO>();
        ArrayList<AppInvStkRespVO> whPriorityList = new ArrayList<AppInvStkRespVO>();
        block2: for (AppItemActivityItemPriceParamVO activity : paramVOList) {
            AppInvStkRespVO stkParam = new AppInvStkRespVO();
            for (String priority : priorities) {
                ItmPriPriceRpcDtoParam priceParam = null;
                if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                    priceParam = this.buildSuppPriceParamList(supplyAllocationMap, activity, priceList, stkParam);
                    if (stkParam.getItemId() != null) {
                        suppPriorityList.add(stkParam);
                    }
                } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                    List<ScpWhNetRelationRpcDTO> whNetList = whNetMap.get(activity.getItemCode());
                    if (CollUtil.isEmpty(whNetList)) {
                        return null;
                    }
                    ScpWhNetRelationRpcDTO supp = whNetList.get(0);
                    priceParam = this.buildWhPriceParamList(supp, activity, priceList, stkParam);
                    if (stkParam.getItemId() != null) {
                        whPriorityList.add(stkParam);
                    }
                }
                if (priceParam != null && priceParam.getItemCode() == null) continue block2;
                if (priceParam == null || priceParam.getItemCode() == null) continue;
                priceParamList.add(priceParam);
                continue block2;
            }
        }
        if (CollUtil.isEmpty(priceParamList) && CollUtil.isNotEmpty((Collection)priceList)) {
            this.queryInvStock(suppPriorityList, stockMap, whPriorityList);
            return priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
        }
        if (CollUtil.isEmpty(priceParamList) && CollUtil.isEmpty((Collection)priceList)) {
            return new HashMap<String, List<PriPriceRpcDTO>>();
        }
        if (stockMap == null) {
            return this.getItemPrice(priceParamList, priceList, pricePlace);
        }
        CompletableFuture<Map> future1 = CompletableFuture.supplyAsync(() -> this.getItemPrice(priceParamList, priceList, pricePlace), (Executor)this.taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> this.queryInvStock(suppPriorityList, stockMap, whPriorityList), (Executor)this.taskExecutor);
        CompletableFuture.allOf(future1, future2).join();
        try {
            return future1.get();
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519\uff1a", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519\uff1a" + e);
        }
    }

    @Override
    public Map<String, AppItemPriceRespVO> getNewPriceAndStockDetails(List<AppItemActivityItemPriceParamVO> paramVOList, String storeCode, ScpOrderSettingRespVO orderSetting, String type, AtomicReference<Map<String, BigDecimal>> stockMap) {
        List<PriPriceRpcDTO> bomPriceList;
        Map<String, ItmItemSuppSimpleRpcDTO> itemSuppSimpleMap;
        log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u548c\u5e93\u5b58\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(paramVOList));
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.builderWhNetRelationMao(paramVOList, storeCode, type);
        log.info("\u67e5\u8be2\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(whNetMap));
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setStoreCodeList(List.of(storeCode));
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)((List)this.orgStoreRpcService.findSimpleStoreByParam(baseRpcParam).computeData()).get(0);
        ArrayList<PurItemPriceParamRpcDTO.Item> supplyItems = new ArrayList<PurItemPriceParamRpcDTO.Item>();
        ArrayList<AppInvStkRespVO> whPriorityList = new ArrayList<AppInvStkRespVO>();
        ArrayList<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<ItmPriPriceRpcDtoParam>();
        ArrayList<ItmBomPriceRpcDtoParam> bomPriceParams = new ArrayList<ItmBomPriceRpcDtoParam>();
        Integer pricePlace = SysUtils.getAppPricePlace();
        for (AppItemActivityItemPriceParamVO activity : paramVOList) {
            AppInvStkRespVO stkParam = new AppInvStkRespVO();
            log.info("\u5546\u54c1\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)activity));
            List<ScpWhNetRelationRpcDTO> whNetList = whNetMap.get(activity.getItemCode());
            log.info("\u4ef7\u683c\u4ed3\u7f51\u5173\u7cfb\uff1a{}\uff0c\u5546\u54c1\uff1a{}", whNetList, (Object)activity.getItemCode());
            if (CollUtil.isEmpty(whNetList)) continue;
            ScpWhNetRelationRpcDTO supp = whNetList.get(0);
            log.info("\u4ef7\u683c\u4ed3\u7f51\u5173\u7cfb\uff1a{}\uff0c\u5546\u54c1\uff1a{}", (Object)supp, (Object)activity.getItemCode());
            stkParam.setItemId(activity.getItemId());
            stkParam.setItemCode(activity.getItemCode());
            stkParam.setWhId(supp.getSupplyWhId());
            whPriorityList.add(stkParam);
            activity.setWhNetId(supp.getId());
            if (Objects.equals(supp.getOuCode(), orgStoreBaseRpcDTO.getOuCode())) {
                if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getDeliveryChargeFlag())) {
                    activity.setDeliveryChargeFlag(Boolean.TRUE);
                }
                this.builderSuppDeliveryPriceParamWithSameOu(activity, supplyItems);
                activity.setSuppMatch(true);
                continue;
            }
            if (Boolean.TRUE.equals(activity.getCombineItemFlag())) {
                if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getWhChargeFlag())) {
                    activity.setWhChargeFlag(Boolean.TRUE);
                }
                ItmBomPriceRpcDtoParam bomPriceParam = new ItmBomPriceRpcDtoParam();
                bomPriceParam.setItemCode(activity.getItemCode());
                bomPriceParam.setCombineItemCode(activity.getCombineItemCode());
                bomPriceParam.setUom(activity.getUom());
                bomPriceParams.add(bomPriceParam);
                if (!ScpConstant.PUR_TRN_DELIVERY_TYPES.contains(supp.getDeliveryType())) continue;
                activity.setSuppMatch(true);
                continue;
            }
            if (ScpConstant.WH_DELIVERY_TYPES.contains(supp.getDeliveryType())) {
                if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getWhChargeFlag())) {
                    activity.setWhChargeFlag(Boolean.TRUE);
                }
                this.builderWhDeliveryPriceParam(activity, supp, priceParamList);
                continue;
            }
            if (!ScpConstant.PUR_TRN_DELIVERY_TYPES.contains(supp.getDeliveryType())) continue;
            if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getDeliveryChargeFlag())) {
                activity.setDeliveryChargeFlag(Boolean.TRUE);
                activity.setWhChargeFlag(Boolean.TRUE);
            }
            this.builderTrnSuppDeliveryPriceParam(activity, supp, priceParamList);
            activity.setSuppMatch(true);
        }
        Map<String, AppItemActivityItemPriceParamVO> paramVOMap = paramVOList.stream().collect(Collectors.toMap(c -> SysUtils.getItemKey(c.getCombineItemCode(), c.getItemCode()), v -> v, (e1, e2) -> e1));
        Map<String, ScpServiceConfigRespVO> configRespVOMap = this.getServiceConfigRespVOMap(orgStoreBaseRpcDTO);
        HashMap<String, AppItemPriceRespVO> priceResultMap = new HashMap<String, AppItemPriceRespVO>();
        List<String> needSuppItems = paramVOList.stream().filter(d -> Boolean.TRUE.equals(d.getSuppMatch())).map(AppItemActivityItemPriceParamVO::getItemCode).distinct().collect(Collectors.toList());
        log.info("\u5339\u914d\u4f9b\u5e94\u5546\u5546\u54c1\uff1a{}", (Object)JSONObject.toJSONString(needSuppItems));
        if (CollectionUtils.isNotEmpty(needSuppItems)) {
            itemSuppSimpleMap = this.mathItemSuppHandler(needSuppItems, orgStoreBaseRpcDTO);
            log.info("\u5339\u914d\u4f9b\u5e94\u5546\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(itemSuppSimpleMap));
            if (itemSuppSimpleMap != null) {
                supplyItems.forEach(d -> {
                    ItmItemSuppSimpleRpcDTO itemSuppRpcDTO = (ItmItemSuppSimpleRpcDTO)itemSuppSimpleMap.get(d.getItemCode());
                    if (itemSuppRpcDTO != null) {
                        d.setSuppId(itemSuppRpcDTO.getSuppId());
                    }
                });
                this.findPurSupplyPrice(supplyItems, priceResultMap, orgStoreBaseRpcDTO, itemSuppSimpleMap, paramVOMap, configRespVOMap, pricePlace);
            }
        } else {
            itemSuppSimpleMap = null;
        }
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> this.queryNewInvStock(stockMap, whPriorityList), (Executor)this.taskExecutor);
        CopyOnWriteArrayList priceList = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        CompletableFuture<Map> future2 = null;
        if (CollectionUtils.isNotEmpty(priceParamList)) {
            future2 = CompletableFuture.supplyAsync(() -> this.getItemPrice(priceParamList, priceList, pricePlace), (Executor)this.taskExecutor);
        }
        if (CollectionUtils.isNotEmpty(bomPriceParams) && CollectionUtils.isNotEmpty(bomPriceList = this.rmiPriceRpcService.findBomPriceByParam(bomPriceParams))) {
            try {
                Map<String, List<PriPriceRpcDTO>> bomPriceMap = bomPriceList.stream().collect(Collectors.groupingBy(c -> SysUtils.getItemKey(c.getCombineItemCode(), c.getItemCode())));
                this.convertPriceResultMap(bomPriceMap, priceResultMap, paramVOMap, configRespVOMap, itemSuppSimpleMap, pricePlace);
            }
            catch (Exception e) {
                log.info("\u67e5\u8be2\u5b50\u4ef6\u4ef7\u683c\u62a5\u9519\uff1a", (Throwable)e);
                throw new BusinessException("\u67e5\u8be2\u5b50\u4ef6\u4ef7\u683c\u62a5\u9519\uff1a" + e);
            }
        }
        if (future2 != null) {
            CompletableFuture.allOf(future1, future2).join();
            try {
                Map priceDtoMap = future2.get();
                this.convertPriceResultMap(priceDtoMap, priceResultMap, paramVOMap, configRespVOMap, itemSuppSimpleMap, pricePlace);
            }
            catch (Exception e) {
                log.info("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519\uff1a", (Throwable)e);
                throw new BusinessException("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519\uff1a" + e);
            }
        } else {
            CompletableFuture.allOf(future1).join();
        }
        log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u548c\u5e93\u5b58\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(priceResultMap));
        return priceResultMap;
    }

    @Override
    public Map<String, AppItemPriceRespVO> getPurPriceAndStockDetails(List<AppItemActivityItemPriceParamVO> paramVOList, String storeCode, ScpOrderSettingRespVO orderSetting, String type, AtomicReference<Map<String, BigDecimal>> stockMap, AddressParamVO addressParam) {
        List<PriPriceRpcDTO> bomPriceList;
        Map<String, ItmItemSuppSimpleRpcDTO> itemSuppSimpleMap;
        log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u548c\u5e93\u5b58\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(paramVOList));
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.builderWhNetRelationMao(paramVOList, storeCode, type);
        log.info("\u67e5\u8be2\u4ed3\u7f51\u4f9b\u5e94\u5173\u7cfb\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(whNetMap));
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setStoreCodeList(List.of(storeCode));
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)((List)this.orgStoreRpcService.findSimpleStoreByParam(baseRpcParam).computeData()).get(0);
        Assert.notNull((Object)addressParam, (String)"\u5730\u5740\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        orgStoreBaseRpcDTO.setCountry(addressParam.getCountry());
        orgStoreBaseRpcDTO.setProvince(addressParam.getProvince());
        orgStoreBaseRpcDTO.setCity(addressParam.getCity());
        orgStoreBaseRpcDTO.setCounty(addressParam.getCounty());
        ArrayList<PurItemPriceParamRpcDTO.Item> supplyItems = new ArrayList<PurItemPriceParamRpcDTO.Item>();
        ArrayList<AppInvStkRespVO> whPriorityList = new ArrayList<AppInvStkRespVO>();
        ArrayList<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<ItmPriPriceRpcDtoParam>();
        ArrayList<ItmBomPriceRpcDtoParam> bomPriceParams = new ArrayList<ItmBomPriceRpcDtoParam>();
        Integer pricePlace = SysUtils.getAppPricePlace();
        for (AppItemActivityItemPriceParamVO activity : paramVOList) {
            AppInvStkRespVO stkParam = new AppInvStkRespVO();
            log.info("\u5546\u54c1\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)activity));
            List<ScpWhNetRelationRpcDTO> whNetList = whNetMap.get(activity.getItemCode());
            log.info("\u4ef7\u683c\u4ed3\u7f51\u5173\u7cfb\uff1a{}\uff0c\u5546\u54c1\uff1a{}", whNetList, (Object)activity.getItemCode());
            if (CollUtil.isEmpty(whNetList)) continue;
            ScpWhNetRelationRpcDTO supp = whNetList.get(0);
            log.info("\u4ef7\u683c\u4ed3\u7f51\u5173\u7cfb\uff1a{}\uff0c\u5546\u54c1\uff1a{}", (Object)supp, (Object)activity.getItemCode());
            stkParam.setItemId(activity.getItemId());
            stkParam.setItemCode(activity.getItemCode());
            stkParam.setWhId(supp.getSupplyWhId());
            whPriorityList.add(stkParam);
            activity.setWhNetId(supp.getId());
            this.builderSuppDeliveryPriceParamWithSameOu(activity, supplyItems);
            if (Objects.equals(supp.getOuCode(), orgStoreBaseRpcDTO.getOuCode())) {
                if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getDeliveryChargeFlag())) {
                    activity.setDeliveryChargeFlag(Boolean.TRUE);
                }
                activity.setSuppMatch(true);
                continue;
            }
            if (Boolean.TRUE.equals(activity.getCombineItemFlag())) {
                if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getWhChargeFlag())) {
                    activity.setWhChargeFlag(Boolean.TRUE);
                }
                ItmBomPriceRpcDtoParam bomPriceParam = new ItmBomPriceRpcDtoParam();
                bomPriceParam.setItemCode(activity.getItemCode());
                bomPriceParam.setCombineItemCode(activity.getCombineItemCode());
                bomPriceParam.setUom(activity.getUom());
                bomPriceParams.add(bomPriceParam);
                if (!ScpConstant.PUR_DELIVERY_TYPES.contains(supp.getDeliveryType())) continue;
                activity.setSuppMatch(true);
                continue;
            }
            if (ScpConstant.WH_DELIVERY_TYPES.contains(supp.getDeliveryType())) {
                if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getWhChargeFlag())) {
                    activity.setWhChargeFlag(Boolean.TRUE);
                }
                this.builderWhDeliveryPriceParam(activity, supp, priceParamList);
                continue;
            }
            if (!ScpConstant.PUR_DELIVERY_TYPES.contains(supp.getDeliveryType())) continue;
            if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getDeliveryChargeFlag())) {
                activity.setDeliveryChargeFlag(Boolean.TRUE);
                activity.setWhChargeFlag(Boolean.TRUE);
            }
            this.builderTrnSuppDeliveryPriceParam(activity, supp, priceParamList);
            activity.setSuppMatch(true);
        }
        Map<String, AppItemActivityItemPriceParamVO> paramVOMap = paramVOList.stream().collect(Collectors.toMap(c -> SysUtils.getItemKey(c.getCombineItemCode(), c.getItemCode()), v -> v, (e1, e2) -> e1));
        Map<String, ScpServiceConfigRespVO> configRespVOMap = this.getServiceConfigRespVOMap(orgStoreBaseRpcDTO);
        HashMap<String, AppItemPriceRespVO> priceResultMap = new HashMap<String, AppItemPriceRespVO>();
        List<String> needSuppItems = paramVOList.stream().filter(d -> Boolean.TRUE.equals(d.getSuppMatch())).map(AppItemActivityItemPriceParamVO::getItemCode).distinct().collect(Collectors.toList());
        log.info("\u5339\u914d\u4f9b\u5e94\u5546\u5546\u54c1\uff1a{}", (Object)JSONObject.toJSONString(needSuppItems));
        if (CollectionUtils.isNotEmpty(needSuppItems)) {
            itemSuppSimpleMap = this.mathItemSuppHandler(needSuppItems, orgStoreBaseRpcDTO);
            log.info("\u5339\u914d\u4f9b\u5e94\u5546\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(itemSuppSimpleMap));
            if (itemSuppSimpleMap != null) {
                supplyItems.forEach(d -> {
                    ItmItemSuppSimpleRpcDTO itemSuppRpcDTO = (ItmItemSuppSimpleRpcDTO)itemSuppSimpleMap.get(d.getItemCode());
                    if (itemSuppRpcDTO != null) {
                        d.setSuppId(itemSuppRpcDTO.getSuppId());
                    }
                });
                this.findPurSupplyPrice(supplyItems, priceResultMap, orgStoreBaseRpcDTO, itemSuppSimpleMap, paramVOMap, configRespVOMap, pricePlace);
            }
        } else {
            itemSuppSimpleMap = null;
        }
        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> this.queryNewInvStock(stockMap, whPriorityList), (Executor)this.taskExecutor);
        CopyOnWriteArrayList priceList = CollUtil.newCopyOnWriteArrayList(new ArrayList());
        CompletableFuture<Map> future2 = null;
        if (CollectionUtils.isNotEmpty(priceParamList)) {
            future2 = CompletableFuture.supplyAsync(() -> this.getItemPrice(priceParamList, priceList, pricePlace), (Executor)this.taskExecutor);
        }
        if (CollectionUtils.isNotEmpty(bomPriceParams) && CollectionUtils.isNotEmpty(bomPriceList = this.rmiPriceRpcService.findBomPriceByParam(bomPriceParams))) {
            try {
                Map<String, List<PriPriceRpcDTO>> bomPriceMap = bomPriceList.stream().collect(Collectors.groupingBy(c -> SysUtils.getItemKey(c.getCombineItemCode(), c.getItemCode())));
                this.convertPriceResultMap(bomPriceMap, priceResultMap, paramVOMap, configRespVOMap, itemSuppSimpleMap, pricePlace);
            }
            catch (Exception e) {
                log.info("\u67e5\u8be2\u5b50\u4ef6\u4ef7\u683c\u62a5\u9519\uff1a", (Throwable)e);
                throw new BusinessException("\u67e5\u8be2\u5b50\u4ef6\u4ef7\u683c\u62a5\u9519\uff1a" + e);
            }
        }
        if (future2 != null) {
            CompletableFuture.allOf(future1, future2).join();
            try {
                Map priceDtoMap = future2.get();
                this.convertPriceResultMap(priceDtoMap, priceResultMap, paramVOMap, configRespVOMap, itemSuppSimpleMap, pricePlace);
            }
            catch (Exception e) {
                log.info("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519\uff1a", (Throwable)e);
                throw new BusinessException("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519\uff1a" + e);
            }
        } else {
            CompletableFuture.allOf(future1).join();
        }
        log.info("\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u548c\u5e93\u5b58\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(priceResultMap));
        return priceResultMap;
    }

    @NotNull
    private Map<String, ScpServiceConfigRespVO> getServiceConfigRespVOMap(OrgStoreBaseRpcDTO orgStoreBaseRpcDTO) {
        Map<String, ScpServiceConfigRespVO> configRespVOMap = null;
        if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getDeliveryChargeFlag()) || Boolean.TRUE.equals(orgStoreBaseRpcDTO.getWhChargeFlag())) {
            configRespVOMap = this.serviceConfigService.findServiceConfigGroupByStore(orgStoreBaseRpcDTO.getStoreCode(), orgStoreBaseRpcDTO.getRegion(), orgStoreBaseRpcDTO.getStoreLevel());
        }
        return configRespVOMap;
    }

    private void builderSuppDeliveryPriceParamWithSameOu(AppItemActivityItemPriceParamVO activity, List<PurItemPriceParamRpcDTO.Item> supplyItems) {
        PurItemPriceParamRpcDTO.Item item = new PurItemPriceParamRpcDTO.Item();
        item.setItemCode(activity.getItemCode());
        item.setUom(activity.getUom());
        supplyItems.add(item);
    }

    private void builderTrnSuppDeliveryPriceParam(AppItemActivityItemPriceParamVO activity, ScpWhNetRelationRpcDTO supp, List<ItmPriPriceRpcDtoParam> priceParamList) {
        ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
        priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setItemId(activity.getItemId());
        priceParam.setCustCode(supp.getCustCode());
        priceParam.setItemCode(activity.getItemCode());
        priceParam.setUom(activity.getUom());
        priceParam.setCurrCode("CNY");
        priceParam.setOuCode(supp.getPurCompanyCode());
        priceParam.setUuid("INTERNAL_SETTLEMENT_PRICE" + SysUtils.getItemKey(activity.getCombineItemCode(), activity.getItemCode(), activity.getActivityCode()));
        priceParamList.add(priceParam);
    }

    private void builderWhDeliveryPriceParam(AppItemActivityItemPriceParamVO activity, ScpWhNetRelationRpcDTO supp, List<ItmPriPriceRpcDtoParam> priceParamList) {
        ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
        priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setItemId(activity.getItemId());
        priceParam.setCustCode(supp.getCustCode());
        priceParam.setItemCode(activity.getItemCode());
        priceParam.setUom(activity.getUom());
        priceParam.setCurrCode("CNY");
        priceParam.setOuCode(supp.getOuCode());
        priceParam.setUuid("INTERNAL_SETTLEMENT_PRICE" + SysUtils.getItemKey(activity.getCombineItemCode(), activity.getItemCode(), activity.getActivityCode()));
        priceParamList.add(priceParam);
    }

    private Map<String, List<ScpWhNetRelationRpcDTO>> builderWhNetRelationMao(List<AppItemActivityItemPriceParamVO> paramVOList, String storeCode, String type) {
        List<ScpStoreCartDO> dataList = paramVOList.stream().map(row -> {
            ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
            storeCartDO.setItemCode(row.getItemCode());
            storeCartDO.setItemCateCode(row.getItemCateCode());
            storeCartDO.setItemType2(row.getItemType2());
            return storeCartDO;
        }).collect(Collectors.toList());
        log.info("\u83b7\u53d6\u4ed3\u7f51\u5173\u7cfb\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr(dataList));
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = this.scpWhNetRelationService.findNewWhNetByParam(storeCode, type, dataList);
        return whNetMap;
    }

    private void findPurSupplyPrice(List<PurItemPriceParamRpcDTO.Item> supplyItems, Map<String, AppItemPriceRespVO> priceResultMap, OrgStoreBaseRpcDTO orgStoreBaseRpcDTO, Map<String, ItmItemSuppSimpleRpcDTO> simpleItemSuppRpcDTOMap, Map<String, AppItemActivityItemPriceParamVO> paramVOMap, Map<String, ScpServiceConfigRespVO> configRespVOMap, Integer pricePlace) {
        List items = supplyItems.stream().filter(d -> d.getSuppId() != null).collect(Collectors.toList());
        PurItemPriceParamRpcDTO purItemPriceParamRpcDTO = new PurItemPriceParamRpcDTO();
        purItemPriceParamRpcDTO.setCurrCode("CNY");
        purItemPriceParamRpcDTO.setDocTime(LocalDateTime.now());
        purItemPriceParamRpcDTO.setOuId(orgStoreBaseRpcDTO.getOuId());
        purItemPriceParamRpcDTO.setItems(items);
        Map purPurcPriceRpcMap = (Map)this.purPriceProvider.findItemPurPriceGroup(purItemPriceParamRpcDTO).computeData();
        log.info("\u67e5\u8be2\u76f4\u9001\u4ef7\u683c\u53c2\u6570\uff1a{}", (Object)purItemPriceParamRpcDTO);
        for (PurItemPriceParamRpcDTO.Item d2 : items) {
            PurPurcPriceRpcDTO priceRpcDTO;
            if (paramVOMap.get(d2.getItemCode()) == null || (priceRpcDTO = (PurPurcPriceRpcDTO)purPurcPriceRpcMap.get(d2.getItemCode() + "-" + d2.getSuppId() + "-" + d2.getUom())) == null) continue;
            AppItemPriceRespVO priceRespVO = new AppItemPriceRespVO();
            priceRespVO.setItemCode(d2.getItemCode());
            priceRespVO.setSuppId(priceRespVO.getSuppId());
            priceRespVO.setSuppCode(priceRpcDTO.getSuppCode());
            priceRespVO.setSuppName(priceRpcDTO.getSuppName());
            priceRespVO.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
            priceRespVO.setPurPrice(priceRpcDTO.getPrice());
            priceRespVO.setSalePrice(priceRpcDTO.getPrice());
            ItmItemSuppSimpleRpcDTO itmItemSuppSimpleRpcDTO = simpleItemSuppRpcDTOMap.get(d2.getItemCode());
            if (Boolean.TRUE.equals(paramVOMap.get(d2.getItemCode()).getDeliveryChargeFlag())) {
                if (configRespVOMap != null) {
                    log.info("\u67e5\u8be2\u670d\u52a1\u8d39\u53c2\u6570\uff1a{}", configRespVOMap);
                    BigDecimal techRatio = configRespVOMap.get("TECH") == null ? BigDecimal.ZERO : configRespVOMap.get("TECH").getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal mefRatio = configRespVOMap.get("MARKET") == null ? BigDecimal.ZERO : configRespVOMap.get("MARKET").getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal oefRatio = configRespVOMap.get("OPERATE") == null ? BigDecimal.ZERO : configRespVOMap.get("OPERATE").getFeePercentage().multiply(new BigDecimal("0.01"));
                    priceRespVO.setTefPrice(priceRpcDTO.getPrice().multiply(techRatio).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    priceRespVO.setMefPrice(priceRpcDTO.getPrice().multiply(mefRatio).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    priceRespVO.setOefPrice(priceRpcDTO.getPrice().multiply(oefRatio).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    priceRespVO.setPrice(priceRpcDTO.getPrice().add(priceRespVO.getMefPrice()).add(priceRespVO.getTefPrice()).add(priceRespVO.getOefPrice()).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    if (configRespVOMap.get("TECH") != null) {
                        priceRespVO.setTefFeeOuCode(configRespVOMap.get("TECH").getOuCode());
                        priceRespVO.setTefFeeOuName(configRespVOMap.get("TECH").getOuName());
                    }
                    if (configRespVOMap.get("MARKET") != null) {
                        priceRespVO.setMefFeeOuCode(configRespVOMap.get("MARKET").getOuCode());
                        priceRespVO.setMefFeeOuName(configRespVOMap.get("MARKET").getOuName());
                    }
                    if (configRespVOMap.get("OPERATE") != null) {
                        priceRespVO.setOefFeeOuCode(configRespVOMap.get("OPERATE").getOuCode());
                        priceRespVO.setOefFeeOuName(configRespVOMap.get("OPERATE").getOuName());
                    }
                } else {
                    log.info("\u67e5\u8be2\u670d\u52a1\u8d39\u53c2\u6570\u4e3a\u7a7a");
                    priceRespVO.setPrice(priceRpcDTO.getPrice());
                    priceRespVO.setTefPrice(BigDecimal.ZERO);
                    priceRespVO.setMefPrice(BigDecimal.ZERO);
                    priceRespVO.setOefPrice(BigDecimal.ZERO);
                }
                priceRespVO.setIsProjFeeCharged(Boolean.TRUE);
            } else {
                priceRespVO.setPrice(priceRpcDTO.getPrice());
                priceRespVO.setIsProjFeeCharged(Boolean.FALSE);
            }
            priceResultMap.put(d2.getItemCode(), priceRespVO);
        }
    }

    private Map<String, ItmItemSuppSimpleRpcDTO> mathItemSuppHandler(List<String> itemCodes, OrgStoreBaseRpcDTO orgStoreBaseRpcDTO) {
        ItmItemSuppRegionRpcDtoParam regionRpcDtoParam = new ItmItemSuppRegionRpcDtoParam();
        regionRpcDtoParam.setItemCodes(itemCodes);
        regionRpcDtoParam.setCity(orgStoreBaseRpcDTO.getCity());
        regionRpcDtoParam.setCountry(orgStoreBaseRpcDTO.getCountry());
        regionRpcDtoParam.setProvince(orgStoreBaseRpcDTO.getProvince());
        regionRpcDtoParam.setCounty(orgStoreBaseRpcDTO.getCounty());
        regionRpcDtoParam.setDirectDelivery(Boolean.TRUE);
        return (Map)this.itmItemRpcService.findItemSuppByItemRegion(regionRpcDtoParam).computeData();
    }

    private void convertPriceResultMap(Map<String, List<PriPriceRpcDTO>> priceDtoMap, Map<String, AppItemPriceRespVO> priceResultMap, Map<String, AppItemActivityItemPriceParamVO> paramVOMap, Map<String, ScpServiceConfigRespVO> configRespVOMap, Map<String, ItmItemSuppSimpleRpcDTO> itemSuppSimpleMap, Integer pricePlace) {
        for (Map.Entry<String, List<PriPriceRpcDTO>> entry : priceDtoMap.entrySet()) {
            String key = entry.getKey();
            if (!CollectionUtils.isNotEmpty((Collection)entry.getValue())) continue;
            PriPriceRpcDTO priPrice = entry.getValue().get(0);
            log.info("\u7ed3\u7b97\u4ef7priPrice2222:{}\uff0citemSuppMap:{}", (Object)priPrice, (Object)JSONObject.toJSONString(itemSuppSimpleMap));
            if (paramVOMap.get(SysUtils.getItemKey(priPrice.getCombineItemCode(), priPrice.getItemCode())) == null) continue;
            AppItemPriceRespVO vo = new AppItemPriceRespVO();
            log.info("\u7ed3\u7b97\u4ef7priPrice2222:{}", itemSuppSimpleMap);
            if (itemSuppSimpleMap != null && itemSuppSimpleMap.get(priPrice.getItemCode()) != null) {
                vo.setSuppId(itemSuppSimpleMap.get(priPrice.getItemCode()).getSuppId());
                vo.setSuppCode(itemSuppSimpleMap.get(priPrice.getItemCode()).getSuppCode());
                vo.setSuppName(itemSuppSimpleMap.get(priPrice.getItemCode()).getSuppName());
            }
            vo.setItemId(priPrice.getItemId());
            vo.setItemCode(priPrice.getItemCode());
            vo.setCostPrice(priPrice.getPrice());
            vo.setSalePrice(priPrice.getPrice());
            vo.setCombineQty(priPrice.getCombineQty());
            vo.setCombineItemCode(priPrice.getCombineItemCode());
            vo.setCombineItemFlag(StringUtil.isNotEmpty((CharSequence)priPrice.getCombineItemCode()));
            if (Boolean.TRUE.equals(paramVOMap.get(SysUtils.getItemKey(priPrice.getCombineItemCode(), priPrice.getItemCode())).getWhChargeFlag())) {
                vo.setIsProjFeeCharged(Boolean.TRUE);
                if (configRespVOMap != null) {
                    log.info("\u67e5\u8be2\u4ed3\u914d\u670d\u52a1\u8d39\u53c2\u6570\uff1a{}", configRespVOMap);
                    BigDecimal techRatio = configRespVOMap.get("TECH") == null ? BigDecimal.ZERO : configRespVOMap.get("TECH").getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal mefRatio = configRespVOMap.get("MARKET") == null ? BigDecimal.ZERO : configRespVOMap.get("MARKET").getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal oefRatio = configRespVOMap.get("OPERATE") == null ? BigDecimal.ZERO : configRespVOMap.get("OPERATE").getFeePercentage().multiply(new BigDecimal("0.01"));
                    vo.setTefPrice(priPrice.getPrice().multiply(techRatio).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    vo.setMefPrice(priPrice.getPrice().multiply(mefRatio).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    vo.setOefPrice(priPrice.getPrice().multiply(oefRatio).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    vo.setPrice(priPrice.getPrice().add(vo.getMefPrice()).add(vo.getTefPrice()).add(vo.getOefPrice()).setScale((int)pricePlace, RoundingMode.HALF_UP));
                    if (configRespVOMap.get("TECH") != null) {
                        vo.setTefFeeOuCode(configRespVOMap.get("TECH").getOuCode());
                        vo.setTefFeeOuName(configRespVOMap.get("TECH").getOuName());
                    }
                    if (configRespVOMap.get("MARKET") != null) {
                        vo.setMefFeeOuCode(configRespVOMap.get("MARKET").getOuCode());
                        vo.setMefFeeOuName(configRespVOMap.get("MARKET").getOuName());
                    }
                    if (configRespVOMap.get("OPERATE") != null) {
                        vo.setOefFeeOuCode(configRespVOMap.get("OPERATE").getOuCode());
                        vo.setOefFeeOuName(configRespVOMap.get("OPERATE").getOuName());
                    }
                } else {
                    log.info("\u67e5\u8be2\u4ed3\u914d\u670d\u52a1\u8d39\u53c2\u6570\u4e3a\u7a7a");
                    vo.setPrice(priPrice.getPrice());
                    vo.setMefPrice(BigDecimal.ZERO);
                    vo.setTefPrice(BigDecimal.ZERO);
                    vo.setOefPrice(BigDecimal.ZERO);
                }
            } else {
                vo.setPrice(priPrice.getPrice());
                vo.setIsProjFeeCharged(Boolean.FALSE);
            }
            priceResultMap.put(key, vo);
        }
    }

    private void queryNewInvStock(AtomicReference<Map<String, BigDecimal>> stockMap, List<AppInvStkRespVO> whPriorityList) {
        if (stockMap == null) {
            return;
        }
        InvWhItemTotalStkRpcParam stockParam = this.buildStockParam(whPriorityList);
        this.getWhStockMap(stockParam, stockMap, whPriorityList);
    }

    private InvWhItemTotalStkRpcParam buildStockParam(List<AppInvStkRespVO> whPriorityList) {
        if (CollUtil.isNotEmpty(whPriorityList)) {
            List itemIds = whPriorityList.stream().map(AppInvStkRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List whIds = whPriorityList.stream().map(AppInvStkRespVO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            InvWhItemTotalStkRpcParam invWhItemTotalStkRpcParam = new InvWhItemTotalStkRpcParam();
            invWhItemTotalStkRpcParam.setItemIds(itemIds);
            invWhItemTotalStkRpcParam.setWhIds(whIds);
            invWhItemTotalStkRpcParam.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
            return invWhItemTotalStkRpcParam;
        }
        return null;
    }

    private void getWhStockMap(InvWhItemTotalStkRpcParam stkRpcParam, AtomicReference<Map<String, BigDecimal>> stockMap, List<AppInvStkRespVO> whPriorityList) {
        if (stkRpcParam == null) {
            return;
        }
        Map itemCodeAndWhId = whPriorityList.stream().collect(Collectors.groupingBy(AppInvStkRespVO::getItemCode, Collectors.mapping(AppInvStkRespVO::getWhId, Collectors.toList())));
        List<InvWhItemTotalStkRpcDTO> invWhItemTotalStkRpcDTOS = this.rmiInvStkRpcService.queryInvWhItemTotalStk(stkRpcParam);
        if (CollUtil.isNotEmpty(invWhItemTotalStkRpcDTOS)) {
            for (InvWhItemTotalStkRpcDTO dto : invWhItemTotalStkRpcDTOS) {
                List longs = itemCodeAndWhId.get(dto.getItemCode());
                if (!longs.contains(dto.getWhId())) continue;
                stockMap.updateAndGet(currentMap -> {
                    currentMap.put(dto.getItemCode(), dto.getAvalQty2());
                    return currentMap;
                });
            }
        }
    }

    private Map<String, List<PriPriceRpcDTO>> getItemPrice(List<ItmPriPriceRpcDtoParam> priceParamList, List<PriPriceRpcDTO> priceList, Integer pricePlace) {
        List itmPriPriceParamList = BeanUtils.copyToList(priceParamList = new ArrayList(priceParamList.stream().filter(Objects::nonNull).collect(Collectors.toMap(ItmPriPriceRpcDtoParam::getUuid, Function.identity(), (existing, replacement) -> existing)).values()), ItmPriPriceRpcDtoParam.class);
        List<PriPriceRpcDTO> priceByParam = this.rmiPriceRpcService.findPriceByParam(itmPriPriceParamList);
        if (CollUtil.isNotEmpty(priceByParam)) {
            priceList.addAll(priceByParam);
            Map<String, List<PriPriceRpcDTO>> inPriceMap = priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
            priceParamList.removeAll(priceParamList.stream().filter(row -> inPriceMap.containsKey(row.getItemCode())).collect(Collectors.toList()));
            this.getBasePrice(priceParamList, priceList, pricePlace);
        } else {
            this.getBasePrice(priceParamList, priceList, pricePlace);
        }
        Map<String, List<PriPriceRpcDTO>> priceMap = priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
        log.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u7ed3\u7b97\u4ef7\u683c\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(priceMap));
        return priceMap;
    }

    private void getBasePrice(List<ItmPriPriceRpcDtoParam> priceParamList, List<PriPriceRpcDTO> priceList, Integer pricePlace) {
        if (CollUtil.isEmpty(priceParamList)) {
            return;
        }
        List<Long> itemIds = priceParamList.stream().map(ItmPriPriceRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemSimpleRpcDTO> simpleItemMap = this.rmiItemService.findBaseItemMap(itemIds);
        List<ItmPriPriceRpcDtoParam> baseUomList = priceParamList.stream().map(row -> {
            ItmPriPriceRpcDtoParam param = (ItmPriPriceRpcDtoParam)BeanUtils.copyProperties((Object)row, ItmPriPriceRpcDtoParam.class, (String[])new String[0]);
            ItmItemSimpleRpcDTO simpleItem = (ItmItemSimpleRpcDTO)simpleItemMap.get(row.getItemId());
            param.setUom(simpleItem.getUom());
            return param;
        }).collect(Collectors.toList());
        List<PriPriceRpcDTO> basePriceList = this.rmiPriceRpcService.findPriceByParam(baseUomList);
        log.info("\u67e5\u8be2\u57fa\u672c\u5355\u4f4d\u4ef7\u683c:{}", (Object)JSONUtil.toJsonStr(basePriceList));
        if (CollUtil.isNotEmpty(basePriceList)) {
            List resultPriceList = basePriceList.stream().map(row -> {
                PriPriceRpcDTO priPriceRpcDTO = (PriPriceRpcDTO)BeanUtils.copyProperties((Object)row, PriPriceRpcDTO.class, (String[])new String[0]);
                ItmItemSimpleRpcDTO simpleItem = (ItmItemSimpleRpcDTO)simpleItemMap.get(row.getItemId());
                if (simpleItem.getUomRatio2() == null) {
                    return null;
                }
                if (simpleItem.getDecimalPlaces() != null) {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()).setScale((int)pricePlace, 4));
                } else {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()).setScale((int)pricePlace, 4));
                }
                return priPriceRpcDTO;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            priceList.addAll(resultPriceList);
        }
    }

    private void queryInvStock(List<AppInvStkRespVO> suppPriorityList, AtomicReference<Map<String, BigDecimal>> stockMap, List<AppInvStkRespVO> whPriorityList) {
        if (stockMap == null) {
            return;
        }
        for (AppInvStkRespVO stk : suppPriorityList) {
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(stk.getItemCode(), new BigDecimal("9999"));
                return currentMap;
            });
        }
        InvWhItemTotalStkRpcParam stockParam = this.buildStockParam(whPriorityList);
        this.getWhStockMap(stockParam, stockMap, whPriorityList);
    }

    private ItmPriPriceRpcDtoParam buildSuppPriceParamList(Map<String, List<ScpSupplyAllocationRpcDTO>> suppAllocMap, AppItemActivityItemPriceParamVO item, List<PriPriceRpcDTO> priceList, AppInvStkRespVO stkParam) {
        List<ScpSupplyAllocationRpcDTO> suppList = suppAllocMap.get(item.getItemCode());
        if (CollUtil.isEmpty(suppList)) {
            return null;
        }
        stkParam.setItemId(item.getItemId());
        stkParam.setItemCode(item.getItemCode());
        ScpSupplyAllocationRpcDTO supp = suppList.get(0);
        if (StrUtil.isBlank((CharSequence)supp.getSaleOuCode())) {
            PriPriceRpcDTO priPriceRpcDTO = new PriPriceRpcDTO();
            priPriceRpcDTO.setItemId(item.getItemId());
            priPriceRpcDTO.setItemCode(item.getItemCode());
            priPriceRpcDTO.setPrice(BigDecimal.ZERO);
            priPriceRpcDTO.setNetPrice(BigDecimal.ZERO);
            priceList.add(priPriceRpcDTO);
            return new ItmPriPriceRpcDtoParam();
        }
        ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
        priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setItemId(item.getItemId());
        priceParam.setCustCode(supp.getSaleCustCode());
        priceParam.setItemCode(item.getItemCode());
        priceParam.setUom(item.getUom());
        priceParam.setCurrCode("CNY");
        priceParam.setOuCode(supp.getSaleOuCode());
        return priceParam;
    }

    private ItmPriPriceRpcDtoParam buildWhPriceParamList(ScpWhNetRelationRpcDTO supp, AppItemActivityItemPriceParamVO item, List<PriPriceRpcDTO> priceList, AppInvStkRespVO stkParam) {
        stkParam.setItemId(item.getItemId());
        stkParam.setItemCode(item.getItemCode());
        stkParam.setWhId(supp.getSupplyWhId());
        if (StrUtil.isBlank((CharSequence)supp.getOuCode())) {
            PriPriceRpcDTO priPriceRpcDTO = new PriPriceRpcDTO();
            priPriceRpcDTO.setItemId(item.getItemId());
            priPriceRpcDTO.setItemCode(item.getItemCode());
            priPriceRpcDTO.setPrice(BigDecimal.ZERO);
            priPriceRpcDTO.setNetPrice(BigDecimal.ZERO);
            priceList.add(priPriceRpcDTO);
            return new ItmPriPriceRpcDtoParam();
        }
        ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
        priceParam.setPriceCls("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setPriceType("INTERNAL_SETTLEMENT_PRICE");
        priceParam.setItemId(item.getItemId());
        priceParam.setCustCode(supp.getCustCode());
        priceParam.setItemCode(item.getItemCode());
        priceParam.setUom(item.getUom());
        priceParam.setCurrCode("CNY");
        priceParam.setOuCode(supp.getOuCode());
        return priceParam;
    }

    public CommonPriceServiceImpl(RmiPriceRpcService rmiPriceRpcService, RmiItemService rmiItemService, ScpSupplyAllocationService scpSupplyAllocationService, ScpWhNetRelationService scpWhNetRelationService, RmiInvStkRpcService rmiInvStkRpcService, OrgStoreRpcService orgStoreRpcService, ScpServiceConfigService serviceConfigService, ItmItemRpcService itmItemRpcService, PurPriceProvider purPriceProvider) {
        this.rmiPriceRpcService = rmiPriceRpcService;
        this.rmiItemService = rmiItemService;
        this.scpSupplyAllocationService = scpSupplyAllocationService;
        this.scpWhNetRelationService = scpWhNetRelationService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.serviceConfigService = serviceConfigService;
        this.itmItemRpcService = itmItemRpcService;
        this.purPriceProvider = purPriceProvider;
    }
}

