package com.elitesland.scp.application.web.common;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.utils.SysUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "公共接口")
@RestController
@RequestMapping(value = "/common", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class CommonController {

    @ApiOperation("公共接口- 查询订货单配置")
    @GetMapping("/sys/setting")
    public ApiResult<String> setting() {
        log.info("[COMMON-SETTING] setting");
        return ApiResult.ok(SysUtils.getOrderSetting());
    }
}
