package com.elitesland.scp.domain.vo.survey;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "问卷管理查询入参")
public class SurveyPagingParam extends AbstractOrderQueryParam {
    @Serial
    private static final long serialVersionUID = -5469973862376913771L;

    @ApiModelProperty("问卷ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suvId;
    private List<Long> suvIdList;

    @ApiModelProperty("不要的问卷ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long notSuvId;

    @ApiModelProperty(value = "问卷标题")
    private String surveyTitle;

    @ApiModelProperty(value = "问卷状态")
    private String surveyStatus;

    @ApiModelProperty(value = "发布人")
    private String publisherName;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTimeFrom;
    private LocalDateTime createTimeTo;

    @ApiModelProperty(value = "是否需要过滤有效期Y")
    private String needFilterValidTime;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;
    private List<String> ouCodeList;

    @ApiModelProperty(value = "填写状态")
    private String fillStatus;

    @ApiModelProperty(value = "填写人")
    private String username;

    @ApiModelProperty("是否必填")
    private Boolean required;
}
