package com.elitesland.scp.infr.repo.mrp;

import com.elitesland.scp.domain.entity.mrp.ScpMrpDDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface ScpMrpDRepo extends JpaRepository<ScpMrpDDO, Long>, QuerydslPredicateExecutor<ScpMrpDDO> {

    List<ScpMrpDDO> findByMasId(Long masId);

    List<ScpMrpDDO> findByMasIdIn(List<Long> masIds);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_mrp_d where mas_id in ?1 ", nativeQuery = true)
    void deleteByMasIds(List<Long> masIds);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_mrp_d where id in ?1 ", nativeQuery = true)
    void deleteByIds(List<Long> ids);
}
