/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.article;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.enums.ScpUdcEnum;
import com.elitesland.scp.domain.convert.article.ArticleManageConvert;
import com.elitesland.scp.domain.dto.article.ArticleCategoryDTO;
import com.elitesland.scp.domain.dto.article.ArticleInfoDTO;
import com.elitesland.scp.domain.entity.article.ArticleCategoryDO;
import com.elitesland.scp.domain.entity.article.ArticleInfoDO;
import com.elitesland.scp.domain.service.article.ArticleManageService;
import com.elitesland.scp.domain.vo.article.ArticleCategoryPagingParam;
import com.elitesland.scp.domain.vo.article.ArticleCategoryRespVO;
import com.elitesland.scp.domain.vo.article.ArticleCategorySaveVO;
import com.elitesland.scp.domain.vo.article.ArticleCategorySortParam;
import com.elitesland.scp.domain.vo.article.ArticleInfoCategoryRespVO;
import com.elitesland.scp.domain.vo.article.ArticleInfoDetailRespVO;
import com.elitesland.scp.domain.vo.article.ArticleInfoPagingParam;
import com.elitesland.scp.domain.vo.article.ArticleInfoRespVO;
import com.elitesland.scp.domain.vo.article.ArticleInfoSaveVO;
import com.elitesland.scp.domain.vo.article.ArticleInfoShowParam;
import com.elitesland.scp.domain.vo.article.ArticleInfoSortParam;
import com.elitesland.scp.domain.vo.article.CategoryArticleRespVO;
import com.elitesland.scp.domain.vo.article.CategoryShowParam;
import com.elitesland.scp.domain.vo.article.UpCategoryRespVO;
import com.elitesland.scp.infr.repo.article.ArticleCategoryRepo;
import com.elitesland.scp.infr.repo.article.ArticleCategoryRepoProc;
import com.elitesland.scp.infr.repo.article.ArticleInfoRepo;
import com.elitesland.scp.infr.repo.article.ArticleInfoRepoProc;
import com.elitesland.scp.utils.TreeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArticleManageServiceImpl
implements ArticleManageService {
    private static final Logger log = LoggerFactory.getLogger(ArticleManageServiceImpl.class);
    private final ArticleCategoryRepo articleCategoryRepo;
    private final ArticleInfoRepo articleInfoRepo;
    private final ArticleCategoryRepoProc articleCategoryRepoProc;
    private final ArticleInfoRepoProc articleInfoRepoProc;
    private final SeqNumProvider seqNumProvider;
    private final UdcProvider udcProvider;

    private Long loopMatch(ArticleCategoryDTO articleCategoryDTO, List<ArticleCategoryDTO> treeDtoList) {
        Long id = articleCategoryDTO.getId();
        for (ArticleCategoryDTO item : treeDtoList) {
            if (!articleCategoryDTO.getPid().equals(item.getId())) continue;
            id = this.loopMatch(item, treeDtoList);
        }
        return id;
    }

    @Override
    @SysCodeProc
    public PagingVO<ArticleCategoryRespVO> search(ArticleCategoryPagingParam searchParam) {
        List<ArticleCategoryDTO> categoryDTOS = this.articleCategoryRepoProc.findAll();
        List<ArticleCategoryDTO> treeDtoList = TreeUtils.buildTree(null, false, categoryDTOS);
        for (ArticleCategoryDTO child : categoryDTOS) {
            child.setShowFlagName(this.getUdcName(ScpUdcEnum.ARTICLE_SHOW_FLAG_DISPLAY.getCode(), child.getShowFlag()));
        }
        List<ArticleCategoryDTO> categoryDTOList = this.articleCategoryRepoProc.findByCategoryNameAndShowFlag(searchParam);
        Set<Long> firstIdList = categoryDTOList.stream().filter(item -> ObjectUtil.isNull((Object)item.getRootId())).map(item -> item.getId()).collect(Collectors.toSet());
        Set firstIdList1 = categoryDTOList.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getRootId())).map(item -> item.getRootId()).collect(Collectors.toSet());
        firstIdList.addAll(firstIdList1);
        PagingVO<ArticleCategoryDTO> parentDTOList = this.articleCategoryRepoProc.findParentCategoryPagingResults(firstIdList, searchParam);
        Set collect = parentDTOList.stream().map(item -> item.getId()).collect(Collectors.toSet());
        ArrayList<ArticleCategoryDTO> treeList = new ArrayList<ArticleCategoryDTO>();
        for (ArticleCategoryDTO articleCategoryDTO : treeDtoList) {
            for (Long firstId : collect) {
                if (!articleCategoryDTO.getId().equals(firstId)) continue;
                treeList.add(articleCategoryDTO);
            }
        }
        List<ArticleCategoryRespVO> respVOList = ArticleManageConvert.INSTANCE.categoryDtosToVos(treeList);
        return PagingVO.builder().total(parentDTOList.getTotal()).records(respVOList).build();
    }

    private void removeItem(List<ArticleCategoryDTO> list, ArticleCategoryDTO articleCategoryDTO) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateArticleCategory(ArticleCategorySaveVO saveVO) {
        ArticleCategoryDO categoryDO = ArticleManageConvert.INSTANCE.categorySaveVOToDo(saveVO);
        if (ObjectUtil.isNull((Object)saveVO.getId())) {
            if (CollectionUtil.isNotEmpty(saveVO.getPidList())) {
                saveVO.setRootId(saveVO.getPidList().get(0));
            }
            if (ObjectUtil.isNotNull((Object)saveVO.getPid()) && StrUtil.equals((CharSequence)saveVO.getShowFlag(), (CharSequence)ScpUdcEnum.ARTICLE_SHOW_FLAG_DISPLAY.getValueCode())) {
                this.articleCategoryRepo.updateShowById(saveVO.getPid(), saveVO.getShowFlag());
                if (CollectionUtil.isNotEmpty(saveVO.getPidList())) {
                    this.articleCategoryRepo.updateShowById(saveVO.getPidList().get(0), saveVO.getShowFlag());
                }
            }
            if (ObjectUtil.isNotNull((Object)saveVO.getPid())) {
                HashSet<Long> set = new HashSet<Long>();
                this.findParentId(saveVO.getPid(), set);
                if (CollectionUtil.isNotEmpty(set)) {
                    categoryDO.setRootId((Long)set.iterator().next());
                } else {
                    categoryDO.setRootId(saveVO.getPid());
                }
            }
        } else {
            Optional optional = this.articleCategoryRepo.findById(saveVO.getId());
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u627e\u5230\u6587\u7ae0\u5206\u7c7b\u4fe1\u606f");
            }
            if (StrUtil.equals((CharSequence)((ArticleCategoryDO)optional.get()).getShowFlag(), (CharSequence)ScpUdcEnum.ARTICLE_SHOW_FLAG_DISPLAY.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u7f16\u8f91\u9690\u85cf\u7684\u5206\u7c7b");
            }
            if (ObjectUtil.isNull((Object)((ArticleCategoryDO)optional.get()).getPid())) {
                long count = this.articleCategoryRepo.countByPid(((ArticleCategoryDO)optional.get()).getId());
                if (ObjectUtil.isNotNull((Object)saveVO.getPid()) && count > 0L) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e00\u7ea7\u6587\u7ae0\u5206\u7c7b\u4e0b\u8fd8\u6709\u4e8c\u7ea7\u5206\u7c7b\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u7236\u7c7b");
                }
            }
        }
        ArticleCategoryDO save = (ArticleCategoryDO)this.articleCategoryRepo.save(categoryDO);
        return save.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long deleteArticleCategory(Long id) {
        Optional byId = this.articleCategoryRepo.findById(id);
        if (byId.isPresent()) {
            if (StrUtil.equals((CharSequence)((ArticleCategoryDO)byId.get()).getShowFlag(), (CharSequence)ScpUdcEnum.ARTICLE_SHOW_FLAG_DISPLAY.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u9690\u85cf\u7684\u6587\u7ae0\u5206\u7c7b");
            }
            this.articleCategoryRepo.updateDeleteFlagById(id);
            this.articleInfoRepo.updateDeleteFlagByCategoryId(id);
            HashSet<Long> deleteIdSet = new HashSet<Long>();
            this.findChildId(Set.of(id), deleteIdSet);
            if (CollectionUtil.isNotEmpty(deleteIdSet)) {
                this.articleCategoryRepo.updateDeleteFlagByIdIn(deleteIdSet);
                this.articleInfoRepo.updateDeleteFlagByCategoryIdIn(deleteIdSet);
            }
            return id;
        }
        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6587\u7ae0\u5206\u7c7b\u4fe1\u606f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long deleteArticleInfo(Long id) {
        Optional byId = this.articleInfoRepo.findById(id);
        if (byId.isPresent()) {
            if (StrUtil.equals((CharSequence)((ArticleInfoDO)byId.get()).getShowFlag(), (CharSequence)ScpUdcEnum.ARTICLE_SHOW_FLAG_DISPLAY.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u9690\u85cf\u7684\u6587\u7ae0\u4fe1\u606f");
            }
            this.articleInfoRepo.updateDeleteFlagById(id);
            return id;
        }
        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6587\u7ae0\u4fe1\u606f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateArticleInfo(ArticleInfoSaveVO saveVO) {
        if (ObjectUtil.isNull((Object)saveVO.getId())) {
            String articleCode;
            Optional byId = this.articleCategoryRepo.findById(saveVO.getCategoryId());
            if (byId.isPresent()) {
                saveVO.setCategoryName(((ArticleCategoryDO)byId.get()).getCategoryName());
            }
            if (this.articleInfoRepo.existsByArticleCode(articleCode = this.generateCode("ARTICLE_NO"))) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684\u6587\u7ae0\u7f16\u53f7\uff1a" + articleCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            saveVO.setArticleCode(articleCode);
        } else {
            Optional optional = this.articleInfoRepo.findById(saveVO.getId());
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u627e\u5230\u6587\u7ae0\u4fe1\u606f");
            }
            ArticleInfoDO articleInfoDO = (ArticleInfoDO)optional.get();
            if (StrUtil.equals((CharSequence)articleInfoDO.getShowFlag(), (CharSequence)ScpUdcEnum.ARTICLE_SHOW_FLAG_DISPLAY.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u7f16\u8f91\u9690\u85cf\u7684\u6587\u7ae0\u4fe1\u606f");
            }
            saveVO.setArticleCode(articleInfoDO.getArticleCode());
            Optional byId = this.articleCategoryRepo.findById(saveVO.getCategoryId());
            if (byId.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u6587\u7ae0\u5206\u7c7b\u4fe1\u606f");
            }
            saveVO.setCategoryName(((ArticleCategoryDO)byId.get()).getCategoryName());
        }
        ArticleInfoDO articleInfoDO = ArticleManageConvert.INSTANCE.copyArticleInfoSaveToDo(saveVO);
        ArticleInfoDO saveDo = (ArticleInfoDO)this.articleInfoRepo.save(articleInfoDO);
        return saveDo.getId();
    }

    @Override
    public List<UpCategoryRespVO> queryUpCategory(Long id) {
        Optional parentDo;
        Optional byId = this.articleCategoryRepo.findById(id);
        ArrayList<UpCategoryRespVO> respVOS = new ArrayList<UpCategoryRespVO>();
        if (byId.isPresent() && ObjectUtil.isNotNull((Object)((ArticleCategoryDO)byId.get()).getPid()) && (parentDo = this.articleCategoryRepo.findById(((ArticleCategoryDO)byId.get()).getPid())).isPresent()) {
            UpCategoryRespVO resp = new UpCategoryRespVO();
            resp.setId(((ArticleCategoryDO)parentDo.get()).getId());
            resp.setCategoryName(((ArticleCategoryDO)parentDo.get()).getCategoryName());
            respVOS.add(resp);
        }
        return respVOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long categoryShowUpdate(CategoryShowParam param) {
        if (StrUtil.equals((CharSequence)param.getShowFlag(), (CharSequence)ScpUdcEnum.ARTICLE_SHOW_FLAG_DISPLAY.getValueCode())) {
            HashSet<Long> set = new HashSet<Long>();
            set.add(param.getId());
            this.findParentId(param.getId(), set);
            this.articleCategoryRepo.updateShowByIdIn(set, param.getShowFlag());
        } else {
            this.articleCategoryRepo.updateShowById(param.getId(), param.getShowFlag());
        }
        return param.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer categorySortUpdate(ArticleCategorySortParam param) {
        return this.articleCategoryRepo.updateSortById(param.getId(), param.getSortNo());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer infoShowUpdate(ArticleInfoShowParam param) {
        return this.articleInfoRepo.updateShowById(param.getId(), param.getShowFlag());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer infoSortUpdate(ArticleInfoSortParam param) {
        return this.articleInfoRepo.updateSortById(param.getId(), param.getSortNo());
    }

    @Override
    @SysCodeProc
    public PagingVO<ArticleInfoRespVO> infoSearch(ArticleInfoPagingParam searchParam) {
        PagingVO<ArticleInfoDTO> pagingResults = this.articleInfoRepoProc.findArticleInfoPagingResults(searchParam);
        List<ArticleInfoRespVO> respVoList = ArticleManageConvert.INSTANCE.copyInfoDTOsToVos(pagingResults.getRecords());
        if (CollectionUtil.isNotEmpty(respVoList)) {
            for (ArticleInfoRespVO vo : respVoList) {
                HashSet<Long> set = new HashSet<Long>();
                set.add(vo.getCategoryId());
                this.findParentId(vo.getCategoryId(), set);
                List categoryDOList = this.articleCategoryRepo.findAllById(set);
                List nameList = categoryDOList.stream().map(item -> item.getCategoryName()).collect(Collectors.toList());
                String name = CollectionUtil.join(nameList, (CharSequence)"/");
                vo.setCategoryName(name);
            }
        }
        return PagingVO.builder().total(pagingResults.getTotal()).records(respVoList).build();
    }

    @Override
    @SysCodeProc
    public ArticleInfoDetailRespVO queryInfoDetail(Long id) {
        ArticleInfoDTO dto = this.articleInfoRepoProc.findById(id);
        if (ObjectUtil.isNull((Object)dto)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6587\u7ae0\u8be6\u60c5");
        }
        ArticleInfoDetailRespVO respVO = ArticleManageConvert.INSTANCE.infoDTO2DetailVo(dto);
        ArrayList<Long> idList = new ArrayList<Long>();
        if (ObjectUtil.isNotNull((Object)dto.getPid())) {
            idList.add(dto.getPid());
        }
        idList.add(dto.getCategoryId());
        respVO.setCategoryIdList(idList);
        return respVO;
    }

    @Override
    @SysCodeProc
    public List<ArticleInfoCategoryRespVO> queryAllCategory() {
        List<ArticleCategoryDTO> categoryDTOS = this.articleCategoryRepoProc.findAll();
        List<ArticleCategoryDTO> treeDtoList = TreeUtils.buildTree(null, false, categoryDTOS);
        List<ArticleInfoCategoryRespVO> respVOList = ArticleManageConvert.INSTANCE.categoryDTOS2InfoCategoryRespVOs(treeDtoList);
        return respVOList;
    }

    @Override
    public String queryArticleDetail(Long id) {
        Optional byId = this.articleInfoRepo.findById(id);
        if (byId.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6587\u7ae0\u8be6\u60c5");
        }
        return ((ArticleInfoDO)byId.get()).getArticleDetail();
    }

    private void findChildId(Set<Long> pidSet, Set<Long> childIdSet) {
        List<ArticleCategoryDO> categoryDOList = this.articleCategoryRepo.findByPidIn(pidSet);
        if (CollectionUtil.isNotEmpty(categoryDOList)) {
            Set<Long> collect = categoryDOList.stream().map(item -> item.getId()).collect(Collectors.toSet());
            childIdSet.addAll(collect);
            this.findChildId(collect, childIdSet);
        }
    }

    private void findParentId(Long childId, Set<Long> parentIdSet) {
        Optional byId = this.articleCategoryRepo.findById(childId);
        if (byId.isPresent() && ObjectUtil.isNotNull((Object)((ArticleCategoryDO)byId.get()).getPid())) {
            parentIdSet.add(((ArticleCategoryDO)byId.get()).getPid());
            this.findParentId(((ArticleCategoryDO)byId.get()).getPid(), parentIdSet);
        }
    }

    @Override
    public List<CategoryArticleRespVO> queryCategoryArticle() {
        List<ArticleCategoryDTO> categoryDTOS = this.articleCategoryRepoProc.findAllByShowFlag(ScpUdcEnum.ARTICLE_SHOW_FLAG_DISPLAY.getValueCode());
        if (CollectionUtil.isEmpty(categoryDTOS)) {
            return Collections.emptyList();
        }
        Set<Long> categoryIdSet = categoryDTOS.stream().map(item -> item.getId()).collect(Collectors.toSet());
        List<ArticleInfoRespVO> articleInfoRespVOS = this.articleInfoRepoProc.findByCategoryIdInAndShowFlag(categoryIdSet, ScpUdcEnum.ARTICLE_SHOW_FLAG_DISPLAY.getValueCode());
        if (CollectionUtil.isNotEmpty(articleInfoRespVOS)) {
            categoryDTOS.forEach(category -> {
                ArrayList<ArticleInfoRespVO> articleInfoList = new ArrayList<ArticleInfoRespVO>();
                articleInfoRespVOS.stream().forEach(articleInfoRespVO -> {
                    if (ObjectUtil.equals((Object)articleInfoRespVO, (Object)category.getId())) {
                        articleInfoList.add((ArticleInfoRespVO)articleInfoRespVO);
                    }
                });
                category.setArticleInfoRespVOS(articleInfoList);
            });
        }
        List<ArticleCategoryDTO> treeDtoList = TreeUtils.buildTree(null, true, categoryDTOS);
        return ArticleManageConvert.INSTANCE.categoryDTOS2CategoryRespVOs(treeDtoList);
    }

    @Override
    public String queryAppStoreProtocolArticle(String categoryName) {
        List<ArticleInfoRespVO> articleInfoRespVOS = this.articleInfoRepoProc.queryAppStoreProtocolArticle(categoryName);
        if (CollectionUtils.isEmpty(articleInfoRespVOS)) {
            return "";
        }
        return articleInfoRespVOS.get(0).getArticleDetail();
    }

    public String generateCode(String ruleCode) {
        String code = this.seqNumProvider.generateCode("yst-suplan", ruleCode, Collections.emptyList());
        return code;
    }

    public String getUdcName(String udcCode, String valueCode) {
        Map udcCodeValueMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", Set.of(udcCode));
        Map map = (Map)udcCodeValueMap.get(udcCode);
        return CollectionUtil.isEmpty((Map)map) ? null : (StrUtil.isBlank((CharSequence)valueCode) ? null : (String)map.get(valueCode));
    }

    public ArticleManageServiceImpl(ArticleCategoryRepo articleCategoryRepo, ArticleInfoRepo articleInfoRepo, ArticleCategoryRepoProc articleCategoryRepoProc, ArticleInfoRepoProc articleInfoRepoProc, SeqNumProvider seqNumProvider, UdcProvider udcProvider) {
        this.articleCategoryRepo = articleCategoryRepo;
        this.articleInfoRepo = articleInfoRepo;
        this.articleCategoryRepoProc = articleCategoryRepoProc;
        this.articleInfoRepoProc = articleInfoRepoProc;
        this.seqNumProvider = seqNumProvider;
        this.udcProvider = udcProvider;
    }
}

